/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.infra.yaml;

import com.google.common.base.Splitter;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.shardingsphere.elasticjob.infra.json.GsonFactory;
import org.apache.shardingsphere.elasticjob.infra.yaml.ElasticJobYamlRepresenter;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.representer.Representer;

public final class YamlEngine {
    public static String marshal(Object value) {
        return new Yaml((Representer)new ElasticJobYamlRepresenter()).dumpAsMap(value);
    }

    public static <T> T unmarshal(String yamlContent, Class<T> classType) {
        return (T)new Yaml().loadAs(yamlContent, classType);
    }

    public static <T> T unmarshal(String prefix, InputStream configFileInput, Class<T> classType) {
        Map configDataMap = (Map)new Yaml().loadAs(configFileInput, Map.class);
        if (null != configDataMap && StringUtils.isNotBlank((CharSequence)prefix)) {
            List prefixStrList = Splitter.on((String)".").trimResults().omitEmptyStrings().splitToList((CharSequence)prefix);
            for (String prefixStr : prefixStrList) {
                Object configData = configDataMap.get(prefixStr);
                if (configData instanceof Map) {
                    configDataMap = (Map)configData;
                    continue;
                }
                configDataMap = null;
                break;
            }
        }
        if (null != configDataMap) {
            return (T)GsonFactory.getGson().fromJson(GsonFactory.getGson().toJson((Object)configDataMap), classType);
        }
        return null;
    }

    @Generated
    private YamlEngine() {
    }
}

