/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol.types;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.BoundField;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class Schema
extends Type {
    private final BoundField[] fields;
    private final Map<String, BoundField> fieldsByName;

    public Schema(Field ... fs) {
        this.fields = new BoundField[fs.length];
        this.fieldsByName = new HashMap<String, BoundField>();
        for (int i = 0; i < this.fields.length; ++i) {
            Field def = fs[i];
            if (this.fieldsByName.containsKey(def.name)) {
                throw new SchemaException("Schema contains a duplicate field: " + def.name);
            }
            this.fields[i] = new BoundField(def, this, i);
            this.fieldsByName.put(def.name, this.fields[i]);
        }
    }

    @Override
    public void write(ByteBuffer buffer, Object o) {
        Struct r = (Struct)o;
        for (BoundField field2 : this.fields) {
            try {
                Object value = field2.def.type.validate(r.get(field2));
                field2.def.type.write(buffer, value);
            }
            catch (Exception e) {
                throw new SchemaException("Error writing field '" + field2.def.name + "': " + (e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
            }
        }
    }

    @Override
    public Struct read(ByteBuffer buffer) {
        Object[] objects = new Object[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            try {
                objects[i] = this.fields[i].def.type.read(buffer);
                continue;
            }
            catch (Exception e) {
                throw new SchemaException("Error reading field '" + this.fields[i].def.name + "': " + (e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
            }
        }
        return new Struct(this, objects);
    }

    @Override
    public int sizeOf(Object o) {
        int size2 = 0;
        Struct r = (Struct)o;
        for (BoundField field2 : this.fields) {
            try {
                size2 += field2.def.type.sizeOf(r.get(field2));
            }
            catch (Exception e) {
                throw new SchemaException("Error computing size for field '" + field2.def.name + "': " + (e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
            }
        }
        return size2;
    }

    public int numFields() {
        return this.fields.length;
    }

    public BoundField get(int slot) {
        return this.fields[slot];
    }

    public BoundField get(String name) {
        return this.fieldsByName.get(name);
    }

    public BoundField[] fields() {
        return this.fields;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('{');
        for (int i = 0; i < this.fields.length; ++i) {
            b.append(this.fields[i].toString());
            if (i >= this.fields.length - 1) continue;
            b.append(',');
        }
        b.append("}");
        return b.toString();
    }

    @Override
    public Struct validate(Object item) {
        try {
            Struct struct = (Struct)item;
            for (BoundField field2 : this.fields) {
                try {
                    field2.def.type.validate(struct.get(field2));
                }
                catch (SchemaException e) {
                    throw new SchemaException("Invalid value for field '" + field2.def.name + "': " + e.getMessage());
                }
            }
            return struct;
        }
        catch (ClassCastException e) {
            throw new SchemaException("Not a Struct.");
        }
    }

    public void walk(Visitor visitor) {
        Objects.requireNonNull(visitor, "visitor must be non-null");
        Schema.handleNode(this, visitor);
    }

    private static void handleNode(Type node, Visitor visitor) {
        if (node instanceof Schema) {
            Schema schema = (Schema)node;
            visitor.visit(schema);
            for (BoundField f : schema.fields()) {
                Schema.handleNode(f.def.type, visitor);
            }
        } else if (node instanceof ArrayOf) {
            ArrayOf array = (ArrayOf)node;
            visitor.visit(array);
            Schema.handleNode(array.type(), visitor);
        } else {
            visitor.visit(node);
        }
    }

    public static abstract class Visitor {
        public void visit(Schema schema) {
        }

        public void visit(ArrayOf array) {
        }

        public void visit(Type field2) {
        }
    }
}

