/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.nio.ByteBuffer;
import javax.jms.JMSException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.message.AMQMessageDelegate;
import org.apache.qpid.client.message.AMQMessageDelegateFactory;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.transport.util.Functions;

public abstract class AbstractBytesTypedMessage
extends AbstractJMSMessage {
    private boolean _readableMessage = false;

    AbstractBytesTypedMessage(AMQMessageDelegateFactory delegateFactory, boolean fromReceivedMessage) {
        super(delegateFactory, fromReceivedMessage);
        this._readableMessage = fromReceivedMessage;
    }

    AbstractBytesTypedMessage(AMQMessageDelegate delegate, boolean fromReceivedMessage) throws AMQException {
        super(delegate, fromReceivedMessage);
        this._readableMessage = fromReceivedMessage;
    }

    protected void checkReadable() throws MessageNotReadableException {
        if (!this._readableMessage) {
            throw new MessageNotReadableException("You need to call reset() to make the message readable");
        }
    }

    protected void checkWritable() throws MessageNotWriteableException {
        super.checkWritable();
        if (this._readableMessage) {
            throw new MessageNotWriteableException("You need to call clearBody() to make the message writable");
        }
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this._readableMessage = false;
    }

    protected void setReadable(boolean readable) {
        this._readableMessage = readable;
    }

    public String toBodyString() throws JMSException {
        try {
            ByteBuffer data = this.getData();
            if (data != null) {
                return Functions.str((ByteBuffer)data, (int)100, (int)0);
            }
            return "";
        }
        catch (Exception e) {
            JMSException jmse = new JMSException(e.toString());
            jmse.setLinkedException(e);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
    }

    public abstract void reset();
}

