/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;

public interface TypedMessageBuilder<T>
extends Serializable {
    public static final String CONF_KEY = "key";
    public static final String CONF_PROPERTIES = "properties";
    public static final String CONF_EVENT_TIME = "eventTime";
    public static final String CONF_SEQUENCE_ID = "sequenceId";
    public static final String CONF_REPLICATION_CLUSTERS = "replicationClusters";
    public static final String CONF_DISABLE_REPLICATION = "disableReplication";
    public static final String CONF_DELIVERY_AFTER_SECONDS = "deliverAfterSeconds";
    public static final String CONF_DELIVERY_AT = "deliverAt";

    public MessageId send() throws PulsarClientException;

    public CompletableFuture<MessageId> sendAsync();

    public TypedMessageBuilder<T> key(String var1);

    public TypedMessageBuilder<T> keyBytes(byte[] var1);

    public TypedMessageBuilder<T> orderingKey(byte[] var1);

    public TypedMessageBuilder<T> value(T var1);

    public TypedMessageBuilder<T> property(String var1, String var2);

    public TypedMessageBuilder<T> properties(Map<String, String> var1);

    public TypedMessageBuilder<T> eventTime(long var1);

    public TypedMessageBuilder<T> sequenceId(long var1);

    public TypedMessageBuilder<T> replicationClusters(List<String> var1);

    public TypedMessageBuilder<T> disableReplication();

    public TypedMessageBuilder<T> deliverAt(long var1);

    public TypedMessageBuilder<T> deliverAfter(long var1, TimeUnit var3);

    public TypedMessageBuilder<T> loadConf(Map<String, Object> var1);
}

