/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.offload;

import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.DataFormats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OffloadUtils {
    private static final Logger log = LoggerFactory.getLogger(OffloadUtils.class);

    private OffloadUtils() {
    }

    public static Map<String, String> getOffloadDriverMetadata(MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo) {
        MLDataFormats.OffloadDriverMetadata driverMetadata;
        MLDataFormats.OffloadContext ctx;
        HashMap metadata = Maps.newHashMap();
        if (ledgerInfo.hasOffloadContext() && (ctx = ledgerInfo.getOffloadContext()).hasDriverMetadata() && (driverMetadata = ctx.getDriverMetadata()).getPropertiesCount() > 0) {
            driverMetadata.getPropertiesList().forEach(kv -> metadata.put(kv.getKey(), kv.getValue()));
        }
        return metadata;
    }

    public static Map<String, String> getOffloadDriverMetadata(MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo, Map<String, String> defaultOffloadDriverMetadata) {
        MLDataFormats.OffloadDriverMetadata driverMetadata;
        MLDataFormats.OffloadContext ctx;
        if (ledgerInfo.hasOffloadContext() && (ctx = ledgerInfo.getOffloadContext()).hasDriverMetadata() && (driverMetadata = ctx.getDriverMetadata()).getPropertiesCount() > 0) {
            HashMap metadata = Maps.newHashMap();
            driverMetadata.getPropertiesList().forEach(kv -> metadata.put(kv.getKey(), kv.getValue()));
            return metadata;
        }
        return defaultOffloadDriverMetadata;
    }

    public static String getOffloadDriverName(MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo, String defaultDriverName) {
        MLDataFormats.OffloadDriverMetadata driverMetadata;
        MLDataFormats.OffloadContext ctx;
        if (ledgerInfo.hasOffloadContext() && (ctx = ledgerInfo.getOffloadContext()).hasDriverMetadata() && (driverMetadata = ctx.getDriverMetadata()).hasName()) {
            return driverMetadata.getName();
        }
        return defaultDriverName;
    }

    public static void setOffloadDriverMetadata(MLDataFormats.ManagedLedgerInfo.LedgerInfo.Builder infoBuilder, String driverName, Map<String, String> offloadDriverMetadata) {
        infoBuilder.getOffloadContextBuilder().getDriverMetadataBuilder().setName(driverName);
        infoBuilder.getOffloadContextBuilder().getDriverMetadataBuilder().clearProperties();
        offloadDriverMetadata.forEach((k, v) -> infoBuilder.getOffloadContextBuilder().getDriverMetadataBuilder().addProperties(MLDataFormats.KeyValue.newBuilder().setKey((String)k).setValue((String)v).build()));
    }

    public static byte[] buildLedgerMetadataFormat(LedgerMetadata metadata) {
        DataFormats.LedgerMetadataFormat.Builder builder = DataFormats.LedgerMetadataFormat.newBuilder();
        builder.setQuorumSize(metadata.getWriteQuorumSize()).setAckQuorumSize(metadata.getAckQuorumSize()).setEnsembleSize(metadata.getEnsembleSize()).setLength(metadata.getLength()).setState(metadata.isClosed() ? DataFormats.LedgerMetadataFormat.State.CLOSED : DataFormats.LedgerMetadataFormat.State.OPEN).setLastEntryId(metadata.getLastEntryId()).setCtime(metadata.getCtime()).setDigestType(BookKeeper.DigestType.toProtoDigestType((BookKeeper.DigestType)BookKeeper.DigestType.fromApiDigestType((DigestType)metadata.getDigestType())));
        for (Map.Entry e : metadata.getCustomMetadata().entrySet()) {
            builder.addCustomMetadataBuilder().setKey((String)e.getKey()).setValue(ByteString.copyFrom((byte[])((byte[])e.getValue())));
        }
        for (Map.Entry e : metadata.getAllEnsembles().entrySet()) {
            builder.addSegmentBuilder().setFirstEntryId(((Long)e.getKey()).longValue()).addAllEnsembleMember((Iterable)((List)e.getValue()).stream().map(BookieSocketAddress::toString).collect(Collectors.toList()));
        }
        return builder.build().toByteArray();
    }

    public static LedgerMetadata parseLedgerMetadata(byte[] bytes) throws IOException {
        DataFormats.LedgerMetadataFormat ledgerMetadataFormat = ((DataFormats.LedgerMetadataFormat.Builder)DataFormats.LedgerMetadataFormat.newBuilder().mergeFrom(bytes)).build();
        LedgerMetadataBuilder builder = LedgerMetadataBuilder.create().withLastEntryId(ledgerMetadataFormat.getLastEntryId()).withPassword(ledgerMetadataFormat.getPassword().toByteArray()).withClosedState().withMetadataFormatVersion(2).withLength(ledgerMetadataFormat.getLength()).withAckQuorumSize(ledgerMetadataFormat.getAckQuorumSize()).withCreationTime(ledgerMetadataFormat.getCtime()).withWriteQuorumSize(ledgerMetadataFormat.getQuorumSize()).withEnsembleSize(ledgerMetadataFormat.getEnsembleSize());
        ledgerMetadataFormat.getSegmentList().forEach(segment -> {
            ArrayList addressArrayList = new ArrayList();
            segment.getEnsembleMemberList().forEach(address -> {
                try {
                    addressArrayList.add(new BookieSocketAddress(address));
                }
                catch (IOException e) {
                    log.error("Exception when create BookieSocketAddress. ", (Throwable)e);
                }
            });
            builder.newEnsembleEntry(segment.getFirstEntryId(), addressArrayList);
        });
        if (ledgerMetadataFormat.getCustomMetadataCount() > 0) {
            HashMap customMetadata = Maps.newHashMap();
            ledgerMetadataFormat.getCustomMetadataList().forEach(entry -> customMetadata.put(entry.getKey(), entry.getValue().toByteArray()));
            builder.withCustomMetadata((Map)customMetadata);
        }
        switch (ledgerMetadataFormat.getDigestType()) {
            case HMAC: {
                builder.withDigestType(DigestType.MAC);
                break;
            }
            case CRC32: {
                builder.withDigestType(DigestType.CRC32);
                break;
            }
            case CRC32C: {
                builder.withDigestType(DigestType.CRC32C);
                break;
            }
            case DUMMY: {
                builder.withDigestType(DigestType.DUMMY);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unable to convert digest type " + ledgerMetadataFormat.getDigestType());
            }
        }
        return builder.build();
    }
}

