/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.util.ExceptionUtil;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xwpf.XWPFReadException;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public final class XWPFParser {
    private XWPFParser() {
    }

    public static XWPFDocument parse(InputStream stream) throws XWPFReadException, IOException {
        try {
            return new XWPFDocument(stream);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            if (ExceptionUtil.isFatal((Throwable)e)) {
                throw e;
            }
            throw new XWPFReadException("Exception reading XWPFDocument", e);
        }
        catch (Exception e) {
            throw new XWPFReadException("Exception reading XWPFDocument", e);
        }
    }

    public static XWPFDocument parse(InputStream stream, boolean closeStream) throws XWPFReadException, IOException {
        try {
            return new XWPFDocument(stream, closeStream);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            if (ExceptionUtil.isFatal((Throwable)e)) {
                throw e;
            }
            throw new XWPFReadException("Exception reading XWPFDocument", e);
        }
        catch (Exception e) {
            throw new XWPFReadException("Exception reading XWPFDocument", e);
        }
    }

    public static XWPFDocument parse(File file) throws XWPFReadException, IOException {
        OPCPackage pkg = null;
        try {
            pkg = OPCPackage.open(file);
            return new XWPFDocument(pkg);
        }
        catch (IOException e) {
            if (pkg != null) {
                IOUtils.closeQuietly((Closeable)pkg);
            }
            throw e;
        }
        catch (Error | RuntimeException e) {
            if (pkg != null) {
                IOUtils.closeQuietly((Closeable)pkg);
            }
            if (ExceptionUtil.isFatal((Throwable)e)) {
                throw e;
            }
            throw new XWPFReadException("Exception reading XWPFDocument", e);
        }
        catch (Exception e) {
            if (pkg != null) {
                IOUtils.closeQuietly((Closeable)pkg);
            }
            throw new XWPFReadException("Exception reading XWPFDocument", e);
        }
    }

    public static XWPFDocument parse(OPCPackage pkg) throws XWPFReadException, IOException {
        try {
            return new XWPFDocument(pkg);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            if (ExceptionUtil.isFatal((Throwable)e)) {
                throw e;
            }
            throw new XWPFReadException("Exception reading XWPFDocument", e);
        }
        catch (Exception e) {
            throw new XWPFReadException("Exception reading XWPFDocument", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static XWPFDocument parse(PackagePart packagePart) throws XWPFReadException, IOException {
        try (InputStream is = packagePart.getInputStream();){
            XWPFDocument xWPFDocument = new XWPFDocument(is);
            return xWPFDocument;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            if (!ExceptionUtil.isFatal((Throwable)e)) throw new XWPFReadException("Exception reading XWPFDocument", e);
            throw e;
        }
        catch (Exception e) {
            throw new XWPFReadException("Exception reading XWPFDocument", e);
        }
    }
}

