/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.impl.ActorPublisher$;
import org.apache.pekko.stream.impl.CancelledSubscription$;
import org.apache.pekko.stream.impl.ReactiveStreamsCompliance;
import org.apache.pekko.stream.impl.ReactiveStreamsCompliance$;
import org.apache.pekko.stream.impl.SubscribePending$;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NoStackTrace;

@ScalaSignature(bytes="\u0006\u0005\u0005\rwAB\u000e\u001d\u0011\u0003\u0001cE\u0002\u0004)9!\u0005\u0001%\u000b\u0005\u0006a\u0005!\tA\r\u0005\bg\u0005\u0011\r\u0011\"\u00015\u0011\u0019i\u0014\u0001)A\u0005k\u0019!a(\u0001\u0001@\u0011\u0015\u0001T\u0001\"\u0001L\u0011\u001dq\u0015A1A\u0005\u0002=Ca\u0001X\u0001!\u0002\u0013\u0001\u0006bB/\u0002\u0005\u0004%\tA\u0018\u0005\u0007E\u0006\u0001\u000b\u0011B0\t\u000b\r\fA\u0011\u00013\u0007\u000b!b\u0002\u0001I4\t\u0011ua!Q1A\u0005\u0002uD\u0011\"!\u0003\r\u0005\u0003\u0005\u000b\u0011\u0002@\t\rAbA\u0011AA\u0006\u0011%\t\t\u0002\u0004b\u0001\n\u0013\t\u0019\u0002\u0003\u0005\u0002F1\u0001\u000b\u0011BA\u000b\u0011%\tI\u0005\u0004b\u0001\n#\tY\u0005C\u0004\u0002N1\u0001\u000b\u0011\u0002>\t\u000f\u0005=C\u0002\"\u0011\u0002R!9\u0011q\r\u0007\u0005\u0002\u0005%\u0004bBA<\u0019\u0011\u0005\u0011\u0011\u0010\u0005\n\u0003\u000bc\u0001\u0019!C\u0005\u0003\u000fC\u0011\"!#\r\u0001\u0004%I!a#\t\u0011\u0005EE\u0002)Q\u0005\u0003\u007fBq!a'\r\t\u0013\ti*\u0001\bBGR|'\u000fU;cY&\u001c\b.\u001a:\u000b\u0005uq\u0012\u0001B5na2T!a\b\u0011\u0002\rM$(/Z1n\u0015\t\t#%A\u0003qK.\\wN\u0003\u0002$I\u00051\u0011\r]1dQ\u0016T\u0011!J\u0001\u0004_J<\u0007CA\u0014\u0002\u001b\u0005a\"AD!di>\u0014\b+\u001e2mSNDWM]\n\u0003\u0003)\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003\u0019\n1DT8s[\u0006d7\u000b[;uI><hNU3bg>tW*Z:tC\u001e,W#A\u001b\u0011\u0005YZT\"A\u001c\u000b\u0005aJ\u0014\u0001\u00027b]\u001eT\u0011AO\u0001\u0005U\u00064\u0018-\u0003\u0002=o\t11\u000b\u001e:j]\u001e\fADT8s[\u0006d7\u000b[;uI><hNU3bg>tW*Z:tC\u001e,\u0007EA\fO_Jl\u0017\r\\*ikR$wn\u001e8Fq\u000e,\u0007\u000f^5p]N\u0019Q\u0001Q\"\u0011\u0005Y\n\u0015B\u0001\"8\u0005UIE\u000e\\3hC2\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:\u0004\"\u0001R%\u000e\u0003\u0015S!AR$\u0002\u000f\r|g\u000e\u001e:pY*\u0011\u0001\nL\u0001\u0005kRLG.\u0003\u0002K\u000b\naaj\\*uC\u000e\\GK]1dKR\tA\n\u0005\u0002N\u000b5\t\u0011!\u0001\u000bO_Jl\u0017\r\\*ikR$wn\u001e8SK\u0006\u001cxN\\\u000b\u0002!B\u0011\u0011+\u0017\b\u0003%^s!a\u0015,\u000e\u0003QS!!V\u0019\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0013B\u0001--\u0003\u001d\u0001\u0018mY6bO\u0016L!AW.\u0003\u0013QC'o\\<bE2,'B\u0001--\u0003UquN]7bYNCW\u000f\u001e3po:\u0014V-Y:p]\u0002\n\u0001dU8nK:{'/\\1m'\",H\u000fZ8x]J+\u0017m]8o+\u0005y\u0006cA\u0016a!&\u0011\u0011\r\f\u0002\u0005'>lW-A\rT_6,gj\u001c:nC2\u001c\u0006.\u001e;e_^t'+Z1t_:\u0004\u0013!B1qa2LXcA3\u0002<R\u0019a-!0\u0011\t\u001db\u0011\u0011X\u000b\u0003QR\u001c2\u0001D5m!\t1$.\u0003\u0002lo\t1qJ\u00196fGR\u00042!\u001c9s\u001b\u0005q'BA8%\u0003=\u0011X-Y2uSZ,7\u000f\u001e:fC6\u001c\u0018BA9o\u0005%\u0001VO\u00197jg\",'\u000f\u0005\u0002ti2\u0001A!B;\r\u0005\u00041(!\u0001+\u0012\u0005]T\bCA\u0016y\u0013\tIHFA\u0004O_RD\u0017N\\4\u0011\u0005-Z\u0018B\u0001?-\u0005\r\te._\u000b\u0002}B\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002A\u0005)\u0011m\u0019;pe&!\u0011qAA\u0001\u0005!\t5\r^8s%\u00164\u0017!B5na2\u0004C\u0003BA\u0007\u0003\u001f\u00012a\n\u0007s\u0011\u0015ir\u00021\u0001\u007f\u0003I\u0001XM\u001c3j]\u001e\u001cVOY:de&\u0014WM]:\u0016\u0005\u0005U\u0001CBA\f\u0003G\t9#\u0004\u0002\u0002\u001a)!\u00111DA\u000f\u0003\u0019\tGo\\7jG*!\u0011qDA\u0011\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u0011fJA!!\n\u0002\u001a\ty\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0004\u0002*\u0005M\u0012qG\u0007\u0003\u0003WQA!!\f\u00020\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003ca\u0013AC2pY2,7\r^5p]&!\u0011QGA\u0016\u0005\r\u0019V-\u001d\u0019\u0005\u0003s\t\t\u0005E\u0003n\u0003w\ty$C\u0002\u0002>9\u0014!bU;cg\u000e\u0014\u0018NY3s!\r\u0019\u0018\u0011\t\u0003\f\u0003\u0007\n\u0012\u0011!A\u0001\u0006\u0003\t9EA\u0002`IE\n1\u0003]3oI&twmU;cg\u000e\u0014\u0018NY3sg\u0002\n\"A\u001d>\u0002\u0013]\f7.Z+q\u001bN<W#\u0001>\u0002\u0015]\f7.Z+q\u001bN<\u0007%A\u0005tk\n\u001c8M]5cKR!\u00111KA-!\rY\u0013QK\u0005\u0004\u0003/b#\u0001B+oSRDq!a\u0017\u0015\u0001\u0004\ti&\u0001\u0006tk\n\u001c8M]5cKJ\u0004D!a\u0018\u0002dA)Q.a\u000f\u0002bA\u00191/a\u0019\u0005\u0019\u0005\u0015\u0014\u0011LA\u0001\u0002\u0003\u0015\t!a\u0012\u0003\u0007}##'\u0001\fuC.,\u0007+\u001a8eS:<7+\u001e2tGJL'-\u001a:t)\t\tY\u0007\u0005\u0004\u0002*\u0005M\u0012Q\u000e\u0019\u0005\u0003_\n\u0019\bE\u0003n\u0003w\t\t\bE\u0002t\u0003g\"1\"!\u001e\u0016\u0003\u0003\u0005\tQ!\u0001\u0002H\t\u0019q\fJ\u001a\u0002\u0011MDW\u000f\u001e3po:$B!a\u0015\u0002|!9\u0011Q\u0010\fA\u0002\u0005}\u0014A\u0002:fCN|g\u000e\u0005\u0003,\u0003\u0003\u0003\u0016bAABY\t1q\n\u001d;j_:\fab\u001d5vi\u0012|wO\u001c*fCN|g.\u0006\u0002\u0002\u0000\u0005\u00112\u000f[;uI><hNU3bg>tw\fJ3r)\u0011\t\u0019&!$\t\u0013\u0005=\u0005$!AA\u0002\u0005}\u0014a\u0001=%c\u0005y1\u000f[;uI><hNU3bg>t\u0007\u0005K\u0002\u001a\u0003+\u00032aKAL\u0013\r\tI\n\f\u0002\tm>d\u0017\r^5mK\u00061\"/\u001a9peR\u001cVOY:de&\u0014WMR1jYV\u0014X\r\u0006\u0003\u0002T\u0005}\u0005bBA.5\u0001\u0007\u0011\u0011\u0015\u0019\u0005\u0003G\u000b9\u000bE\u0003n\u0003w\t)\u000bE\u0002t\u0003O#A\"!+\u0002 \u0006\u0005\t\u0011!B\u0001\u0003\u000f\u00121a\u0018\u00135Q\ra\u0011Q\u0016\t\u0005\u0003_\u000b),\u0004\u0002\u00022*\u0019\u00111\u0017\u0011\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00028\u0006E&aC%oi\u0016\u0014h.\u00197Ba&\u00042a]A^\t\u0015)8B1\u0001w\u0011\u0015i2\u00021\u0001\u007fQ\r\t\u0011Q\u0016\u0015\u0004\u0001\u00055\u0006")
@InternalApi
public class ActorPublisher<T>
implements Publisher<T> {
    private final ActorRef impl;
    private final AtomicReference<Seq<Subscriber<? super T>>> pendingSubscribers;
    private final Object wakeUpMsg;
    private volatile Option<Throwable> shutdownReason;

    public static <T> ActorPublisher<T> apply(ActorRef impl) {
        return ActorPublisher$.MODULE$.apply(impl);
    }

    public static Some<Throwable> SomeNormalShutdownReason() {
        return ActorPublisher$.MODULE$.SomeNormalShutdownReason();
    }

    public static Throwable NormalShutdownReason() {
        return ActorPublisher$.MODULE$.NormalShutdownReason();
    }

    public static String NormalShutdownReasonMessage() {
        return ActorPublisher$.MODULE$.NormalShutdownReasonMessage();
    }

    public ActorRef impl() {
        return this.impl;
    }

    private AtomicReference<Seq<Subscriber<? super T>>> pendingSubscribers() {
        return this.pendingSubscribers;
    }

    public Object wakeUpMsg() {
        return this.wakeUpMsg;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        ReactiveStreamsCompliance$.MODULE$.requireNonNullSubscriber(subscriber);
        this.doSubscribe$1(subscriber);
    }

    public Seq<Subscriber<? super T>> takePendingSubscribers() {
        Seq pending = (Seq)this.pendingSubscribers().getAndSet((Seq<Subscriber<T>>)Nil$.MODULE$);
        if (pending == null) {
            return Nil$.MODULE$;
        }
        return (Seq)pending.reverse();
    }

    public void shutdown(Option<Throwable> reason) {
        this.shutdownReason_$eq(reason);
        Seq seq = this.pendingSubscribers().getAndSet(null);
        if (seq == null) {
            return;
        }
        seq.foreach((Function1 & Serializable)subscriber -> {
            this.reportSubscribeFailure(subscriber);
            return BoxedUnit.UNIT;
        });
    }

    private Option<Throwable> shutdownReason() {
        return this.shutdownReason;
    }

    private void shutdownReason_$eq(Option<Throwable> x$1) {
        this.shutdownReason = x$1;
    }

    private void reportSubscribeFailure(Subscriber<? super T> subscriber) {
        block7: {
            try {
                boolean bl = false;
                Some some = null;
                Option<Throwable> option = this.shutdownReason();
                if (option instanceof Some) {
                    bl = true;
                    some = (Some)option;
                    if (some.value() instanceof ReactiveStreamsCompliance.SpecViolation) {
                        break block7;
                    }
                }
                if (bl) {
                    Throwable e = (Throwable)some.value();
                    ReactiveStreamsCompliance$.MODULE$.tryOnSubscribe(subscriber, CancelledSubscription$.MODULE$);
                    ReactiveStreamsCompliance$.MODULE$.tryOnError(subscriber, e);
                    break block7;
                }
                if (None$.MODULE$.equals(option)) {
                    ReactiveStreamsCompliance$.MODULE$.tryOnSubscribe(subscriber, CancelledSubscription$.MODULE$);
                    ReactiveStreamsCompliance$.MODULE$.tryOnComplete(subscriber);
                    break block7;
                }
                throw new MatchError(option);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ReactiveStreamsCompliance.SpecViolation) {
                }
                throw throwable;
            }
        }
    }

    private final void doSubscribe$1(Subscriber subscriber$1) {
        block2: {
            BoxedUnit boxedUnit;
            Subscriber subscriber;
            Seq<Subscriber<T>> current;
            do {
                if ((current = this.pendingSubscribers().get()) == null) {
                    this.reportSubscribeFailure(subscriber$1);
                    boxedUnit = BoxedUnit.UNIT;
                    break block2;
                }
                subscriber = subscriber$1;
            } while (!this.pendingSubscribers().compareAndSet(current, (Seq<Subscriber<T>>)current.$plus$colon((Object)subscriber)));
            Object x$1 = this.wakeUpMsg();
            ActorRef x$2 = this.impl().$bang$default$2(x$1);
            this.impl().$bang(x$1, x$2);
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public ActorPublisher(ActorRef impl) {
        this.impl = impl;
        this.pendingSubscribers = new AtomicReference<Nil$>(Nil$.MODULE$);
        this.wakeUpMsg = SubscribePending$.MODULE$;
        this.shutdownReason = None$.MODULE$;
    }

    public static class NormalShutdownException
    extends IllegalStateException
    implements NoStackTrace {
        public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        @Override
        public Throwable fillInStackTrace() {
            return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
        }

        public NormalShutdownException() {
            super(ActorPublisher$.MODULE$.NormalShutdownReasonMessage());
            NoStackTrace.$init$((NoStackTrace)this);
        }
    }
}

