/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.crypto.CryptoOutputStream;
import org.apache.hadoop.ozone.client.io.KeyOutputStream;
import org.apache.hadoop.ozone.om.helpers.OmMultipartCommitUploadPartInfo;

public class OzoneOutputStream
extends OutputStream {
    private final OutputStream outputStream;

    public OzoneOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
    }

    @Override
    public synchronized void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        this.outputStream.close();
    }

    public OmMultipartCommitUploadPartInfo getCommitUploadPartInfo() {
        OutputStream wrappedStream;
        if (this.outputStream instanceof KeyOutputStream) {
            return ((KeyOutputStream)this.outputStream).getCommitUploadPartInfo();
        }
        if (this.outputStream instanceof CryptoOutputStream && (wrappedStream = ((CryptoOutputStream)this.outputStream).getWrappedStream()) instanceof KeyOutputStream) {
            return ((KeyOutputStream)wrappedStream).getCommitUploadPartInfo();
        }
        return null;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }
}

