/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.el22;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import java.beans.FeatureDescriptor;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.el.ELContextStore;
import org.apache.webbeans.el22.WrappedValueExpressionNode;

public class WebBeansELResolver
extends ELResolver {
    private final WebBeansContext webBeansContext = WebBeansContext.getInstance();

    public Class<?> getCommonPropertyType(ELContext arg0, Object arg1) {
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext arg0, Object arg1) {
        return null;
    }

    public Class<?> getType(ELContext arg0, Object arg1, Object arg2) throws ELException {
        return null;
    }

    public Object getValue(ELContext context, Object base, Object property) throws ELException {
        BeanManagerImpl beanManager = this.webBeansContext.getBeanManagerImpl();
        if (!beanManager.isInUse()) {
            return null;
        }
        String beanName = (String)property;
        ELContextStore elContextStore = ELContextStore.getInstance((boolean)true);
        Object contextualInstance = elContextStore.findBeanByName(beanName);
        if (contextualInstance != null) {
            context.setPropertyResolved(true);
            return contextualInstance;
        }
        if (base instanceof WrappedValueExpressionNode) {
            String baseBeanName = ((WrappedValueExpressionNode)base).getFqBeanName();
            return this.findDottedName(context, baseBeanName, beanManager, elContextStore, beanName);
        }
        Set beans = beanManager.getBeans(beanName);
        if (beans != null && !beans.isEmpty()) {
            return this.getBeanWithScope(context, beanManager, beanName, elContextStore, beans);
        }
        return this.findDottedName(context, null, beanManager, elContextStore, beanName);
    }

    private Object getBeanWithScope(ELContext context, BeanManagerImpl beanManager, String beanName, ELContextStore elContextStore, Set<Bean<?>> beans) {
        Bean bean = beanManager.resolve(beans);
        if (bean.getScope().equals(Dependent.class)) {
            return this.getDependentContextualInstance(beanManager, elContextStore, context, bean);
        }
        return this.getNormalScopedContextualInstance(beanManager, elContextStore, context, bean, beanName);
    }

    private Object findDottedName(ELContext context, Object base, BeanManagerImpl beanManager, ELContextStore elContextStore, String beanName) {
        String fqBeanName = base == null ? beanName : base + "." + beanName;
        Set<Bean<?>> anyBeanName = beanManager.getBeans().stream().filter(b -> b.getName() != null).filter(b -> b.getName().startsWith(fqBeanName)).collect(Collectors.toSet());
        if (anyBeanName.size() == 1 && fqBeanName.equals(((Bean)anyBeanName.iterator().next()).getName())) {
            return this.getBeanWithScope(context, beanManager, beanName, elContextStore, anyBeanName);
        }
        if (!anyBeanName.isEmpty()) {
            context.setPropertyResolved(true);
            return new WrappedValueExpressionNode(fqBeanName);
        }
        return null;
    }

    protected Object getNormalScopedContextualInstance(BeanManagerImpl manager, ELContextStore store, ELContext context, Bean<?> bean, String beanName) {
        CreationalContextImpl creationalContext = manager.createCreationalContext(bean);
        Object contextualInstance = manager.getReference(bean, Object.class, (CreationalContext)creationalContext);
        if (contextualInstance != null) {
            context.setPropertyResolved(true);
            store.addNormalScoped(beanName, contextualInstance);
        }
        return contextualInstance;
    }

    protected Object getDependentContextualInstance(BeanManagerImpl manager, ELContextStore store, ELContext context, Bean<?> bean) {
        Object contextualInstance = store.getDependent(bean);
        if (contextualInstance != null) {
            context.setPropertyResolved(true);
        } else {
            CreationalContextImpl creationalContext = manager.createCreationalContext(bean);
            contextualInstance = manager.getReference(bean, WebBeansELResolver.bestType(bean), (CreationalContext)creationalContext);
            if (contextualInstance != null) {
                context.setPropertyResolved(true);
                store.addDependent(bean, contextualInstance, (CreationalContext)creationalContext);
            }
        }
        return contextualInstance;
    }

    private static Type bestType(Bean<?> bean) {
        if (bean == null) {
            return Object.class;
        }
        Class bc = bean.getBeanClass();
        if (bc != null) {
            return bc;
        }
        if (OwbBean.class.isInstance(bean)) {
            return ((OwbBean)OwbBean.class.cast(bean)).getReturnType();
        }
        return Object.class;
    }

    public boolean isReadOnly(ELContext arg0, Object arg1, Object arg2) throws ELException {
        return false;
    }

    public void setValue(ELContext arg0, Object arg1, Object arg2, Object arg3) throws ELException {
    }
}

