/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.ml.maxent.io.BinaryGISModelReader;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.tokenize.TokenizerFactory;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.BaseModel;
import opennlp.tools.util.model.ModelUtil;

public final class TokenizerModel
extends BaseModel {
    private static final String COMPONENT_NAME = "TokenizerME";
    private static final String TOKENIZER_MODEL_ENTRY = "token.model";

    public TokenizerModel(MaxentModel tokenizerModel, Map<String, String> manifestInfoEntries, TokenizerFactory tokenizerFactory) {
        super(COMPONENT_NAME, tokenizerFactory.getLanguageCode(), manifestInfoEntries, tokenizerFactory);
        this.artifactMap.put(TOKENIZER_MODEL_ENTRY, tokenizerModel);
        this.checkArtifactMap();
    }

    public TokenizerModel(InputStream in) throws IOException {
        super(COMPONENT_NAME, in);
    }

    public TokenizerModel(File modelFile) throws IOException {
        super(COMPONENT_NAME, modelFile);
    }

    public TokenizerModel(URL modelURL) throws IOException {
        super(COMPONENT_NAME, modelURL);
    }

    private static boolean isModelCompatible(MaxentModel model) {
        return ModelUtil.validateOutcomes(model, "T", "F");
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(TOKENIZER_MODEL_ENTRY) instanceof AbstractModel)) {
            throw new InvalidFormatException("Token model is incomplete!");
        }
        if (!TokenizerModel.isModelCompatible(this.getMaxentModel())) {
            throw new InvalidFormatException("The maxent model is not compatible with the tokenizer!");
        }
    }

    public TokenizerFactory getFactory() {
        return (TokenizerFactory)this.toolFactory;
    }

    @Override
    protected Class<? extends BaseToolFactory> getDefaultFactory() {
        return TokenizerFactory.class;
    }

    public MaxentModel getMaxentModel() {
        return (MaxentModel)this.artifactMap.get(TOKENIZER_MODEL_ENTRY);
    }

    public Dictionary getAbbreviations() {
        if (this.getFactory() != null) {
            return this.getFactory().getAbbreviationDictionary();
        }
        return null;
    }

    public boolean useAlphaNumericOptimization() {
        return this.getFactory() != null && this.getFactory().isUseAlphaNumericOptmization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            System.err.println("TokenizerModel [-alphaNumericOptimization] languageCode packageName modelName");
            System.exit(1);
        }
        int ai = 0;
        boolean alphaNumericOptimization = false;
        if ("-alphaNumericOptimization".equals(args[ai])) {
            alphaNumericOptimization = true;
        }
        int n = ++ai;
        String languageCode = args[n];
        int n2 = ++ai;
        String packageName = args[n2];
        String modelName = args[++ai];
        AbstractModel model = new BinaryGISModelReader(new DataInputStream(new FileInputStream(modelName))).getModel();
        TokenizerModel packageModel = new TokenizerModel(model, null, TokenizerFactory.create(null, languageCode, null, alphaNumericOptimization, null));
        try (FileOutputStream out = null;){
            out = new FileOutputStream(packageName);
            packageModel.serialize(out);
        }
    }
}

