/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.File;
import java.io.IOException;
import opennlp.tools.ml.maxent.GIS;
import opennlp.tools.ml.maxent.GISModel;
import opennlp.tools.ml.maxent.io.SuffixSensitiveGISModelWriter;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.FileEventStream;
import opennlp.tools.ml.model.OnePassRealValueDataIndexer;

public class RealValueFileEventStream
extends FileEventStream {
    public RealValueFileEventStream(String fileName) throws IOException {
        super(fileName);
    }

    public RealValueFileEventStream(String fileName, String encoding) throws IOException {
        super(fileName, encoding);
    }

    public RealValueFileEventStream(File file) throws IOException {
        super(file);
    }

    public static float[] parseContexts(String[] contexts) {
        boolean hasRealValue = false;
        float[] values = new float[contexts.length];
        for (int ci = 0; ci < contexts.length; ++ci) {
            int ei = contexts[ci].lastIndexOf("=");
            if (ei > 0 && ei + 1 < contexts[ci].length()) {
                boolean gotReal = true;
                try {
                    values[ci] = Float.parseFloat(contexts[ci].substring(ei + 1));
                }
                catch (NumberFormatException e) {
                    gotReal = false;
                    System.err.println("Unable to determine value in context:" + contexts[ci]);
                    values[ci] = 1.0f;
                }
                if (!gotReal) continue;
                if (values[ci] < 0.0f) {
                    throw new RuntimeException("Negative values are not allowed: " + contexts[ci]);
                }
                contexts[ci] = contexts[ci].substring(0, ei);
                hasRealValue = true;
                continue;
            }
            values[ci] = 1.0f;
        }
        if (!hasRealValue) {
            values = null;
        }
        return values;
    }

    @Override
    public Event read() throws IOException {
        String line = this.reader.readLine();
        if (line != null) {
            int si = line.indexOf(32);
            String outcome = line.substring(0, si);
            String[] contexts = line.substring(si + 1).split(" ");
            float[] values = RealValueFileEventStream.parseContexts(contexts);
            return new Event(outcome, contexts, values);
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        GISModel model;
        if (args.length == 0) {
            System.err.println("Usage: RealValueFileEventStream eventfile [iterations cutoff]");
            System.exit(1);
        }
        int ai = 0;
        String eventFile = args[ai++];
        int iterations = 100;
        int cutoff = 5;
        if (ai < args.length) {
            iterations = Integer.parseInt(args[ai++]);
            cutoff = Integer.parseInt(args[ai++]);
        }
        try (RealValueFileEventStream es = new RealValueFileEventStream(eventFile);){
            model = GIS.trainModel(iterations, new OnePassRealValueDataIndexer(es, cutoff));
        }
        new SuffixSensitiveGISModelWriter(model, new File(eventFile + ".bin.gz")).persist();
    }
}

