/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent.quasinewton;

import java.util.Iterator;
import opennlp.tools.ml.maxent.quasinewton.ArrayMath;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.Context;

public class QNModel
extends AbstractModel {
    public QNModel(Context[] params, String[] predLabels, String[] outcomeNames) {
        super(params, predLabels, outcomeNames);
        this.modelType = AbstractModel.ModelType.MaxentQn;
    }

    @Override
    public int getNumOutcomes() {
        return this.outcomeNames.length;
    }

    private Integer getPredIndex(String predicate) {
        return (Integer)this.pmap.get(predicate);
    }

    @Override
    public double[] eval(String[] context) {
        return this.eval(context, new double[this.evalParams.getNumOutcomes()]);
    }

    @Override
    public double[] eval(String[] context, double[] probs) {
        return this.eval(context, null, probs);
    }

    @Override
    public double[] eval(String[] context, float[] values) {
        return this.eval(context, values, new double[this.evalParams.getNumOutcomes()]);
    }

    private double[] eval(String[] context, float[] values, double[] probs) {
        Context[] params = this.evalParams.getParams();
        for (int ci = 0; ci < context.length; ++ci) {
            Integer predIdx = this.getPredIndex(context[ci]);
            if (predIdx == null) continue;
            double predValue = 1.0;
            if (values != null) {
                predValue = values[ci];
            }
            double[] parameters = params[predIdx].getParameters();
            int[] outcomes = params[predIdx].getOutcomes();
            for (int i = 0; i < outcomes.length; ++i) {
                int oi;
                int n = oi = outcomes[i];
                probs[n] = probs[n] + predValue * parameters[i];
            }
        }
        double logSumExp = ArrayMath.logSumOfExps(probs);
        for (int oi = 0; oi < this.outcomeNames.length; ++oi) {
            probs[oi] = Math.exp(probs[oi] - logSumExp);
        }
        return probs;
    }

    public static double[] eval(int[] context, float[] values, double[] probs, int nOutcomes, int nPredLabels, double[] parameters) {
        for (int i = 0; i < context.length; ++i) {
            int predIdx = context[i];
            double predValue = values != null ? (double)values[i] : 1.0;
            for (int oi = 0; oi < nOutcomes; ++oi) {
                int n = oi;
                probs[n] = probs[n] + predValue * parameters[oi * nPredLabels + predIdx];
            }
        }
        double logSumExp = ArrayMath.logSumOfExps(probs);
        for (int oi = 0; oi < nOutcomes; ++oi) {
            probs[oi] = Math.exp(probs[oi] - logSumExp);
        }
        return probs;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QNModel)) {
            return false;
        }
        QNModel objModel = (QNModel)obj;
        if (this.outcomeNames.length != objModel.outcomeNames.length) {
            return false;
        }
        for (int i = 0; i < this.outcomeNames.length; ++i) {
            if (this.outcomeNames[i].equals(objModel.outcomeNames[i])) continue;
            return false;
        }
        if (this.pmap.size() != objModel.pmap.size()) {
            return false;
        }
        String[] pmapArray = new String[this.pmap.size()];
        Iterator iterator = this.pmap.keySet().iterator();
        while (iterator.hasNext()) {
            String pred;
            pmapArray[((Integer)this.pmap.get((Object)pred)).intValue()] = pred = (String)iterator.next();
        }
        for (int i = 0; i < this.pmap.size(); ++i) {
            if (i == (Integer)objModel.pmap.get(pmapArray[i])) continue;
            return false;
        }
        Context[] contextComparing = objModel.evalParams.getParams();
        if (this.evalParams.getParams().length != contextComparing.length) {
            return false;
        }
        for (int i = 0; i < this.evalParams.getParams().length; ++i) {
            if (this.evalParams.getParams()[i].getOutcomes().length != contextComparing[i].getOutcomes().length) {
                return false;
            }
            int j = 0;
            while (i < this.evalParams.getParams()[i].getOutcomes().length) {
                if (this.evalParams.getParams()[i].getOutcomes()[j] != contextComparing[i].getOutcomes()[j]) {
                    return false;
                }
                ++i;
            }
            if (this.evalParams.getParams()[i].getParameters().length != contextComparing[i].getParameters().length) {
                return false;
            }
            j = 0;
            while (i < this.evalParams.getParams()[i].getParameters().length) {
                if (this.evalParams.getParams()[i].getParameters()[j] != contextComparing[i].getParameters()[j]) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

