/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.brat;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.tokenize.WhitespaceTokenizer;

public class AnnotationConfiguration {
    public static final String SPAN_TYPE = "Span";
    public static final String ENTITY_TYPE = "Entity";
    public static final String RELATION_TYPE = "Relation";
    public static final String ATTRIBUTE_TYPE = "Attribute";
    private final Map<String, String> typeToClassMap;

    public AnnotationConfiguration(Map<String, String> typeToClassMap) {
        this.typeToClassMap = Collections.unmodifiableMap(new HashMap<String, String>(typeToClassMap));
    }

    public String getTypeClass(String type) {
        return this.typeToClassMap.get(type);
    }

    public static AnnotationConfiguration parse(InputStream in) throws IOException {
        String line;
        HashMap<String, String> typeToClassMap = new HashMap<String, String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));
        String sectionType = null;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            if (line.startsWith("[") && line.endsWith("]")) {
                sectionType = line.substring(line.indexOf(91) + 1, line.indexOf(93));
                continue;
            }
            String typeName = WhitespaceTokenizer.INSTANCE.tokenize(line)[0];
            switch (sectionType) {
                case "entities": {
                    typeToClassMap.put(typeName, ENTITY_TYPE);
                    break;
                }
                case "relations": {
                    typeToClassMap.put(typeName, RELATION_TYPE);
                    break;
                }
                case "attributes": {
                    typeToClassMap.put(typeName, ATTRIBUTE_TYPE);
                    break;
                }
            }
        }
        return new AnnotationConfiguration(typeToClassMap);
    }

    public static AnnotationConfiguration parse(File annConfigFile) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(annConfigFile));){
            AnnotationConfiguration annotationConfiguration = AnnotationConfiguration.parse(in);
            return annotationConfiguration;
        }
    }
}

