/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.core;

import javax.ws.rs.ext.RuntimeDelegate;

public class EntityTag {
    private final boolean isWeak;
    private final String value;
    private static final RuntimeDelegate.HeaderDelegate<EntityTag> headerDelegate = RuntimeDelegate.getInstance().createHeaderDelegate(EntityTag.class);

    public EntityTag(String value) {
        this(value, false);
    }

    public EntityTag(String value, boolean weak) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.value = value;
        this.isWeak = weak;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EntityTag)) {
            return false;
        }
        EntityTag other = (EntityTag)obj;
        if (this.isWeak != other.isWeak()) {
            return false;
        }
        return this.value.equals(other.getValue());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.isWeak ? 1 : 0);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isWeak() {
        return this.isWeak;
    }

    public String toString() {
        return headerDelegate.toString(this);
    }

    public static EntityTag valueOf(String value) {
        return headerDelegate.fromString(value);
    }
}

