/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.util;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.util.JavaIntrospector;

class GenericBeanInfo
extends SimpleBeanInfo {
    private static final int _DEFAULT_VALUE = -2;
    private JavaIntrospector _introspector;
    private GenericBeanInfo _oldBeanInfo;
    private BeanDescriptor _beanDescriptor;
    private EventSetDescriptor[] _events;
    private int _defaultEvent = -2;
    private PropertyDescriptor[] _properties;
    private int _defaultProperty = -2;
    private MethodDescriptor[] _methods;
    private BeanInfo _targetBeanInfo;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(GenericBeanInfo.class);

    public GenericBeanInfo(JavaIntrospector introspector, BeanInfo targetBeanInfo) {
        this._introspector = introspector;
        this._targetBeanInfo = targetBeanInfo;
    }

    GenericBeanInfo(GenericBeanInfo old) {
        this._oldBeanInfo = old;
        this._targetBeanInfo = old._targetBeanInfo;
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        if (this._properties == null) {
            if (this._introspector != null) {
                try {
                    this._properties = this._introspector.__getTargetPropertyInfo();
                    this._defaultProperty = this._introspector.__getTargetDefaultPropertyIndex();
                }
                catch (IntrospectionException introspectionException) {}
            } else {
                PropertyDescriptor[] oldProperties = this._oldBeanInfo.getPropertyDescriptors();
                if (oldProperties != null) {
                    int len = oldProperties.length;
                    PropertyDescriptor[] newProperties = new PropertyDescriptor[len];
                    for (int i = 0; i < len; ++i) {
                        PropertyDescriptor oldProperty = oldProperties[i];
                        newProperties[i] = oldProperty instanceof IndexedPropertyDescriptor ? GenericBeanInfo._cloneIndexedPropertyDescriptor((IndexedPropertyDescriptor)oldProperty) : GenericBeanInfo._clonePropertyDescriptor(oldProperty);
                    }
                    this._properties = newProperties;
                }
                this._defaultProperty = this._oldBeanInfo.getDefaultPropertyIndex();
            }
        }
        return this._properties;
    }

    @Override
    public int getDefaultPropertyIndex() {
        if (this._defaultProperty == -2) {
            this.getPropertyDescriptors();
        }
        return this._defaultProperty;
    }

    @Override
    public EventSetDescriptor[] getEventSetDescriptors() {
        if (this._events == null) {
            if (this._introspector != null) {
                try {
                    this._events = this._introspector.__getTargetEventInfo();
                    this._defaultEvent = this._introspector.__getTargetDefaultEventIndex();
                }
                catch (IntrospectionException introspectionException) {}
            } else {
                EventSetDescriptor[] oldEventSet = this._oldBeanInfo.getEventSetDescriptors();
                if (oldEventSet != null) {
                    int len = oldEventSet.length;
                    EventSetDescriptor[] newEventSet = new EventSetDescriptor[len];
                    for (int i = 0; i < len; ++i) {
                        newEventSet[i] = GenericBeanInfo._cloneEventSetDescriptor(oldEventSet[i]);
                    }
                    this._events = newEventSet;
                }
                this._defaultEvent = this._oldBeanInfo.getDefaultEventIndex();
            }
        }
        return this._events;
    }

    @Override
    public int getDefaultEventIndex() {
        if (this._defaultEvent == -2) {
            this.getEventSetDescriptors();
        }
        return this._defaultEvent;
    }

    @Override
    public MethodDescriptor[] getMethodDescriptors() {
        if (this._methods == null) {
            if (this._introspector != null) {
                try {
                    this._methods = this._introspector.__getTargetMethodInfo();
                }
                catch (IntrospectionException introspectionException) {}
            } else {
                MethodDescriptor[] oldMethods = this._oldBeanInfo.getMethodDescriptors();
                if (oldMethods != null) {
                    int len = oldMethods.length;
                    MethodDescriptor[] newMethods = new MethodDescriptor[len];
                    for (int i = 0; i < len; ++i) {
                        newMethods[i] = GenericBeanInfo._cloneMethodDescriptor(oldMethods[i]);
                    }
                    this._methods = newMethods;
                }
            }
        }
        return this._methods;
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        if (this._beanDescriptor == null) {
            if (this._introspector != null) {
                try {
                    this._beanDescriptor = this._introspector.__getTargetBeanDescriptor();
                }
                catch (IntrospectionException introspectionException) {}
            } else {
                this._beanDescriptor = GenericBeanInfo._cloneBeanDescriptor(this._oldBeanInfo.getBeanDescriptor());
            }
        }
        return this._beanDescriptor;
    }

    @Override
    public Image getIcon(int iconKind) {
        if (this._targetBeanInfo != null) {
            return this._targetBeanInfo.getIcon(iconKind);
        }
        return super.getIcon(iconKind);
    }

    private static void _copyPropertyDescriptor(PropertyDescriptor oldDescriptor, PropertyDescriptor newDescriptor) {
        newDescriptor.setBound(oldDescriptor.isBound());
        newDescriptor.setConstrained(oldDescriptor.isConstrained());
        newDescriptor.setPropertyEditorClass(oldDescriptor.getPropertyEditorClass());
        GenericBeanInfo._copyFeatureDescriptor(oldDescriptor, newDescriptor);
    }

    private static void _copyFeatureDescriptor(FeatureDescriptor oldDescriptor, FeatureDescriptor newDescriptor) {
        newDescriptor.setName(oldDescriptor.getName());
        newDescriptor.setDisplayName(oldDescriptor.getDisplayName());
        newDescriptor.setExpert(oldDescriptor.isExpert());
        newDescriptor.setHidden(oldDescriptor.isHidden());
        newDescriptor.setShortDescription(oldDescriptor.getShortDescription());
        JavaIntrospector.__addFeatureValues(oldDescriptor, newDescriptor);
    }

    private static IndexedPropertyDescriptor _cloneIndexedPropertyDescriptor(IndexedPropertyDescriptor oldDescriptor) {
        try {
            IndexedPropertyDescriptor newDescriptor = new IndexedPropertyDescriptor(oldDescriptor.getName(), oldDescriptor.getReadMethod(), oldDescriptor.getWriteMethod(), oldDescriptor.getIndexedReadMethod(), oldDescriptor.getIndexedWriteMethod());
            GenericBeanInfo._copyPropertyDescriptor(oldDescriptor, newDescriptor);
            return newDescriptor;
        }
        catch (Exception e) {
            _LOG.severe((Throwable)e);
            return null;
        }
    }

    private static PropertyDescriptor _clonePropertyDescriptor(PropertyDescriptor oldDescriptor) {
        try {
            PropertyDescriptor newDescriptor = new PropertyDescriptor(oldDescriptor.getName(), oldDescriptor.getReadMethod(), oldDescriptor.getWriteMethod());
            GenericBeanInfo._copyPropertyDescriptor(oldDescriptor, newDescriptor);
            return newDescriptor;
        }
        catch (Exception e) {
            _LOG.severe((Throwable)e);
            return null;
        }
    }

    private static BeanDescriptor _cloneBeanDescriptor(BeanDescriptor oldDescriptor) {
        try {
            BeanDescriptor newDescriptor = new BeanDescriptor(oldDescriptor.getBeanClass(), oldDescriptor.getCustomizerClass());
            GenericBeanInfo._copyFeatureDescriptor(oldDescriptor, newDescriptor);
            return newDescriptor;
        }
        catch (Exception e) {
            _LOG.severe((Throwable)e);
            return null;
        }
    }

    private static MethodDescriptor _cloneMethodDescriptor(MethodDescriptor oldDescriptor) {
        try {
            MethodDescriptor newDescriptor = new MethodDescriptor(oldDescriptor.getMethod(), oldDescriptor.getParameterDescriptors());
            GenericBeanInfo._copyFeatureDescriptor(oldDescriptor, newDescriptor);
            return newDescriptor;
        }
        catch (Exception e) {
            _LOG.severe((Throwable)e);
            return null;
        }
    }

    private static EventSetDescriptor _cloneEventSetDescriptor(EventSetDescriptor oldDescriptor) {
        EventSetDescriptor newDescriptor = JavaIntrospector.__createMergedEventSetStub(oldDescriptor, oldDescriptor.getListenerMethodDescriptors());
        newDescriptor.setInDefaultEventSet(oldDescriptor.isInDefaultEventSet());
        return newDescriptor;
    }
}

