/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.share.xml;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.myfaces.trinidad.util.ArrayMap;

class NamespaceSupport {
    public static final String XMLNS = "http://www.w3.org/XML/1998/namespace";
    private static final Iterator<String> _EMPTY_ITERATOR = new ArrayList().iterator();
    private Context[] _contexts;
    private Context _currentContext;
    private int _contextPos;
    private boolean _isReset;

    public NamespaceSupport() {
        this.reset();
    }

    public void reset() {
        if (!this._isReset) {
            this._contexts = new Context[32];
            this._contextPos = 0;
            this._contexts[this._contextPos] = this._currentContext = new Context();
            this._currentContext.declarePrefix("xml", XMLNS);
            this._isReset = true;
        }
    }

    public void pushContext() {
        this._isReset = false;
        int max = this._contexts.length;
        ++this._contextPos;
        if (this._contextPos >= max) {
            Context[] newContexts = new Context[max * 2];
            System.arraycopy(this._contexts, 0, newContexts, 0, max);
            this._contexts = newContexts;
        }
        this._currentContext = this._contexts[this._contextPos];
        if (this._contextPos > 0) {
            if (this._currentContext == null) {
                this._contexts[this._contextPos] = this._currentContext = new Context(this._contexts[this._contextPos - 1]);
            } else {
                this._currentContext.setParent(this._contexts[this._contextPos - 1]);
            }
        } else if (this._currentContext == null) {
            this._contexts[this._contextPos] = this._currentContext = new Context();
        }
    }

    public void popContext() {
        --this._contextPos;
        if (this._contextPos < 0) {
            throw new EmptyStackException();
        }
        this._currentContext = this._contexts[this._contextPos];
    }

    public boolean declarePrefix(String prefix, String uri) {
        if (prefix.equals("xml") || prefix.equals("xmlns")) {
            return false;
        }
        this._currentContext.declarePrefix(prefix, uri);
        return true;
    }

    public String[] processName(String qName, String[] parts, boolean isAttribute) {
        int colonIndex = qName.indexOf(58);
        if (colonIndex < 0) {
            parts[0] = isAttribute ? "" : this._currentContext.getURI("");
            parts[1] = qName = qName.intern();
            parts[2] = qName;
            return parts;
        }
        String[] myParts = this._currentContext.processName(qName, isAttribute);
        if (myParts == null) {
            return null;
        }
        parts[0] = myParts[0];
        parts[1] = myParts[1];
        parts[2] = myParts[2];
        return parts;
    }

    public String getURI(String prefix) {
        return this._currentContext.getURI(prefix);
    }

    public Iterator<String> getPrefixes() {
        return this._currentContext.getPrefixes();
    }

    public String getPrefix(String uri) {
        return this._currentContext.getPrefix(uri);
    }

    public Iterator<String> getPrefixes(String uri) {
        ArrayList<String> prefixes = new ArrayList<String>();
        Iterator<String> allPrefixes = this.getPrefixes();
        while (allPrefixes.hasNext()) {
            String prefix = allPrefixes.next();
            if (!uri.equals(this.getURI(prefix))) continue;
            prefixes.add(prefix);
        }
        return prefixes.iterator();
    }

    public Iterator<String> getDeclaredPrefixes() {
        return this._currentContext.getDeclaredPrefixes();
    }

    static final class Context {
        private ArrayMap<String, String> _prefixTable;
        private ArrayMap<String, String> _uriTable;
        private Hashtable<String, String[]> _elementNameTable;
        private Hashtable<String, String[]> _attributeNameTable;
        private String _defaultNS;
        private ArrayList<String> _declarations;
        private boolean _tablesSharedWithParent;

        Context() {
            this.copyTables();
        }

        Context(Context parent) {
            this.setParent(parent);
        }

        void setParent(Context parent) {
            this._declarations = null;
            this._prefixTable = parent._prefixTable;
            this._uriTable = parent._uriTable;
            this._elementNameTable = parent._elementNameTable;
            this._attributeNameTable = parent._attributeNameTable;
            this._defaultNS = parent._defaultNS;
            this._tablesSharedWithParent = true;
        }

        void declarePrefix(String prefix, String uri) {
            if (this._tablesSharedWithParent) {
                this.copyTables();
            }
            if (this._declarations == null) {
                this._declarations = new ArrayList();
            }
            prefix = prefix.intern();
            uri = uri.intern();
            if ("".equals(prefix)) {
                this._defaultNS = "".equals(uri) ? null : uri;
            } else {
                this._prefixTable.put((Object)prefix, (Object)uri);
                this._uriTable.put((Object)uri, (Object)prefix);
            }
            this._declarations.add(prefix);
        }

        String[] processName(String qName, boolean isAttribute) {
            String[] name;
            Hashtable<String, Object> table;
            if (isAttribute) {
                table = this._elementNameTable;
                if (table == null) {
                    table = new Hashtable();
                    this._elementNameTable = table;
                }
            } else {
                table = this._attributeNameTable;
                if (table == null) {
                    table = new Hashtable(37);
                    this._elementNameTable = table;
                }
            }
            if ((name = table.get(qName)) != null) {
                return name;
            }
            name = new String[3];
            int index = qName.indexOf(58);
            if (index == -1) {
                name[0] = isAttribute || this._defaultNS == null ? "" : this._defaultNS;
                name[1] = qName.intern();
                name[2] = name[1];
            } else {
                String prefix = qName.substring(0, index);
                String local = qName.substring(index + 1);
                String uri = this.getURI(prefix);
                if (uri == null) {
                    return null;
                }
                name[0] = uri;
                name[1] = local.intern();
                name[2] = qName.intern();
            }
            table.put(name[2], name);
            return name;
        }

        String getURI(String prefix) {
            if ("".equals(prefix)) {
                return this._defaultNS;
            }
            if (this._prefixTable == null) {
                return null;
            }
            return (String)this._prefixTable.get((Object)prefix);
        }

        String getPrefix(String uri) {
            if (this._uriTable == null) {
                return null;
            }
            return (String)this._uriTable.get((Object)uri);
        }

        Iterator<String> getDeclaredPrefixes() {
            if (this._declarations == null) {
                return _EMPTY_ITERATOR;
            }
            return this._declarations.iterator();
        }

        Iterator<String> getPrefixes() {
            if (this._prefixTable == null) {
                return _EMPTY_ITERATOR;
            }
            return this._prefixTable.keySet().iterator();
        }

        private void copyTables() {
            this._prefixTable = this._prefixTable != null ? (ArrayMap)this._prefixTable.clone() : new ArrayMap(5);
            this._uriTable = this._uriTable != null ? (ArrayMap)this._uriTable.clone() : new ArrayMap(5);
            this._elementNameTable = null;
            this._attributeNameTable = null;
            this._tablesSharedWithParent = false;
        }
    }
}

