/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.painter;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import org.apache.myfaces.trinidadinternal.image.painter.AbstractPainter;
import org.apache.myfaces.trinidadinternal.image.painter.PaintContext;
import org.apache.myfaces.trinidadinternal.image.painter.StringUtils;

public class TextPainter
extends AbstractPainter {
    private boolean _supportMnemonics;
    private Object _dataKey;
    private static final Object _FONT_LOCK = new Object();

    public TextPainter() {
        this._init(PaintContext.LABEL_KEY, true);
    }

    public TextPainter(Object dataKey) {
        this._init(dataKey, true);
    }

    public TextPainter(Object dataKey, boolean supportMnemonics) {
        this._init(dataKey, supportMnemonics);
    }

    @Override
    public Dimension getPreferredSize(PaintContext context) {
        return this._getSize(context, true);
    }

    @Override
    public Dimension getMinimumSize(PaintContext context) {
        return this._getSize(context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Object object = _FONT_LOCK;
        synchronized (object) {
            int textLength;
            String text;
            TextPainter._resetFont(g);
            FontMetrics metrics = g.getFontMetrics();
            if (metrics != null && (text = this.getStringData(context)) != null && (textLength = text.length()) != 0) {
                Object mnemonic;
                int stringHeight;
                float alignmentX = context.getInteriorAlignmentX();
                int numLines = TextPainter._getNumberOfTextLines(text);
                float alignmentY = context.getInteriorAlignmentY();
                if (alignmentY != 0.0f && (stringHeight = numLines * metrics.getHeight()) < height) {
                    y = (int)((float)y + (float)(height - stringHeight) * alignmentY);
                }
                y += metrics.getAscent();
                int mnemonicIndex = -1;
                if (this._supportMnemonics && (mnemonic = context.getPaintData(PaintContext.MNEMONIC_INDEX_KEY)) != null && mnemonic instanceof Integer) {
                    mnemonicIndex = (Integer)mnemonic;
                }
                if (numLines == 1 && text.charAt(textLength - 1) != '\n') {
                    this.paintText(context, g, metrics, text, x, y, width, alignmentX, mnemonicIndex);
                } else {
                    int lastIndex;
                    int currIndex = -1;
                    int lineHeight = metrics.getHeight();
                    while ((lastIndex = currIndex + 1) < textLength) {
                        currIndex = text.indexOf(10, lastIndex);
                        if (currIndex == -1) {
                            currIndex = textLength;
                        }
                        this.paintText(context, g, metrics, text.substring(lastIndex, currIndex), x, y, width, alignmentX, mnemonicIndex - lastIndex);
                        y += lineHeight;
                    }
                }
            }
        }
    }

    protected String getPaintText(PaintContext context, String text, FontMetrics metrics, int availableWidth) {
        return text;
    }

    protected String getStringData(PaintContext context) {
        return (String)this.getData(context);
    }

    protected String getMinimumStringData(PaintContext context) {
        return this.getStringData(context);
    }

    @Override
    protected Object getData(PaintContext context) {
        Object data = super.getData(context);
        if (data != null) {
            return data.toString();
        }
        return null;
    }

    @Override
    protected Object getDataKey() {
        return this._dataKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension _getSize(PaintContext context, boolean usePreferredSize) {
        int width = 0;
        int height = 0;
        Font font = context.getPaintFont();
        Graphics g = context.getPaintGraphics();
        if (font != null) {
            String text = usePreferredSize ? this.getStringData(context) : this.getMinimumStringData(context);
            Object object = _FONT_LOCK;
            synchronized (object) {
                TextPainter._resetFont(g);
                FontMetrics metrics = context.getFontMetrics(font);
                if (metrics != null && text != null) {
                    int numLines = TextPainter._getNumberOfTextLines(text);
                    if (numLines == 1) {
                        text = StringUtils.getDisplayString(text, context);
                        width = TextPainter._getStringWidth(text, metrics, g);
                    } else {
                        width = TextPainter._getMaxLineWidth(context, text, metrics, g);
                    }
                    height = numLines * metrics.getHeight() - metrics.getLeading();
                }
            }
        }
        return new Dimension(width, height);
    }

    private static final int _getNumberOfTextLines(String text) {
        int currIndex;
        int numLines = 0;
        int foundIndex = -1;
        int textLength = text.length();
        while ((currIndex = foundIndex + 1) != textLength) {
            foundIndex = text.indexOf(10, currIndex);
            ++numLines;
            if (foundIndex != -1) continue;
        }
        return numLines;
    }

    private static final int _getStringWidth(String text, FontMetrics metrics, Graphics g) {
        return (int)metrics.getStringBounds(text, g).getWidth();
    }

    private static final int _getMaxLineWidth(PaintContext context, String text, FontMetrics metrics, Graphics g) {
        int lastIndex;
        int maxWidth = 0;
        int currIndex = -1;
        int textLength = text.length();
        while ((lastIndex = currIndex + 1) < textLength) {
            String subtext;
            int currWidth;
            currIndex = text.indexOf(10, lastIndex);
            if (currIndex == -1) {
                currIndex = textLength;
            }
            if (maxWidth >= (currWidth = TextPainter._getStringWidth(subtext = StringUtils.getDisplayString(text.substring(lastIndex, currIndex), context), metrics, g))) continue;
            maxWidth = currWidth;
        }
        return maxWidth;
    }

    protected int paintText(PaintContext context, Graphics g, FontMetrics metrics, String text, int x, int y, int availableWidth, float alignmentX, int mnemonicIndex) {
        int stringWidth;
        text = StringUtils.getDisplayString(text, context);
        String paintText = this.getPaintText(context, text, metrics, availableWidth);
        if (alignmentX != 0.0f && (stringWidth = TextPainter._getStringWidth(paintText, metrics, g)) < availableWidth) {
            x = (int)((float)x + (float)(availableWidth - stringWidth) * alignmentX);
        }
        Graphics2D g2 = (Graphics2D)g;
        AttributedString as = new AttributedString(paintText);
        as.addAttribute(TextAttribute.FONT, g2.getFont());
        Boolean direction = context.getReadingDirection() == 1 ? TextAttribute.RUN_DIRECTION_LTR : TextAttribute.RUN_DIRECTION_RTL;
        as.addAttribute(TextAttribute.RUN_DIRECTION, direction);
        g2.drawString(as.getIterator(), x, y);
        if (mnemonicIndex >= 0 && mnemonicIndex < paintText.length()) {
            TextLayout layout = new TextLayout(as.getIterator(), g2.getFontRenderContext());
            TextHitInfo leading = TextHitInfo.leading(mnemonicIndex);
            TextHitInfo trailing = TextHitInfo.trailing(mnemonicIndex);
            Rectangle r = layout.getVisualHighlightShape(leading, trailing).getBounds();
            int left = r.x + x;
            g.drawLine(left + 1, y + 1, left + r.width - 1, y + 1);
        }
        return x;
    }

    private void _init(Object dataKey, boolean supportMnemonics) {
        this._dataKey = dataKey;
        this._supportMnemonics = supportMnemonics;
    }

    private static void _resetFont(Graphics g) {
        Font font = g.getFont();
        g.setFont(new Font(font.getName(), font.getStyle(), 1));
        g.getFontMetrics();
        g.setFont(font);
    }
}

