/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.faces.annotation.ExcludeFromManagedRequestScope;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import org.apache.myfaces.trinidad.config.Configurator;
import org.apache.myfaces.trinidad.context.ExternalContextDecorator;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.context.RequestContextFactory;
import org.apache.myfaces.trinidad.context.WindowManager;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.SkinFactory;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidad.util.ComponentReference;
import org.apache.myfaces.trinidad.util.ExternalContextUtils;
import org.apache.myfaces.trinidad.util.RequestStateMap;
import org.apache.myfaces.trinidad.util.RequestType;
import org.apache.myfaces.trinidadinternal.config.ConfigPropertyServiceImpl;
import org.apache.myfaces.trinidadinternal.config.ThreadLocalResetter;
import org.apache.myfaces.trinidadinternal.config.URLEncoderExternalContext;
import org.apache.myfaces.trinidadinternal.context.RequestContextFactoryImpl;
import org.apache.myfaces.trinidadinternal.context.external.ServletCookieMap;
import org.apache.myfaces.trinidadinternal.context.external.ServletRequestHeaderMap;
import org.apache.myfaces.trinidadinternal.context.external.ServletRequestHeaderValuesMap;
import org.apache.myfaces.trinidadinternal.context.external.ServletRequestMap;
import org.apache.myfaces.trinidadinternal.context.external.ServletRequestParameterMap;
import org.apache.myfaces.trinidadinternal.context.external.ServletRequestParameterValuesMap;
import org.apache.myfaces.trinidadinternal.skin.SkinFactoryImpl;
import org.apache.myfaces.trinidadinternal.skin.provider.ExternalSkinProvider;
import org.apache.myfaces.trinidadinternal.skin.provider.SkinProviderRegistry;
import org.apache.myfaces.trinidadinternal.skin.provider.TrinidadSkinProvider;

public final class GlobalConfiguratorImpl
extends Configurator {
    private static volatile boolean _sSetRequestBugTested = false;
    private static boolean _sHasSetRequestBug = false;
    private final ReentrantLock _initLock = new ReentrantLock();
    private AtomicBoolean _initialized = new AtomicBoolean(false);
    private List<Configurator> _services;
    private static final Map<ClassLoader, GlobalConfiguratorImpl> _CONFIGURATORS = new HashMap<ClassLoader, GlobalConfiguratorImpl>();
    private static final String _IN_REQUEST = GlobalConfiguratorImpl.class.getName() + ".IN_REQUEST";
    private static final String _REQUEST_CONTEXT = GlobalConfiguratorImpl.class.getName() + ".REQUEST_CONTEXT";
    private static final String _REQUEST_TYPE = GlobalConfiguratorImpl.class.getName() + ".REQUEST_TYPE";
    private static final String _CONFIGURATORS_ABORTED = GlobalConfiguratorImpl.class.getName() + ".CONFIGURATORS_ABORTED";
    private static final String _REDIRECT_ISSUED = GlobalConfiguratorImpl.class.getName() + ".REDIRECT_ISSUED";
    private static final String _FINISH_INITIALIZATION_LIST_KEY = ComponentReference.class.getName() + "#FINISH_INITIALIZATION";
    private AtomicReference<ThreadLocalResetter> _threadResetter = new AtomicReference();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(GlobalConfiguratorImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final GlobalConfiguratorImpl getInstance() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            Map<ClassLoader, GlobalConfiguratorImpl> map = _CONFIGURATORS;
            synchronized (map) {
                GlobalConfiguratorImpl config = _CONFIGURATORS.get(loader);
                if (config == null) {
                    try {
                        config = new GlobalConfiguratorImpl();
                        _CONFIGURATORS.put(loader, config);
                    }
                    catch (RuntimeException e) {
                        _LOG.severe((Throwable)e);
                        throw e;
                    }
                    _LOG.fine("GlobalConfigurator has been created.");
                }
                return config;
            }
        }
        _LOG.severe("CANNOT_FIND_CONTEXT_CLASS_LOADER");
        return null;
    }

    public static boolean isRequestStarted(ExternalContext ec) {
        return RequestStateMap.getInstance((ExternalContext)ec).get((Object)_REQUEST_TYPE) != null;
    }

    private static final boolean _isDisabled(ExternalContext ec) {
        Boolean inRequest = (Boolean)RequestStateMap.getInstance((ExternalContext)ec).get((Object)_IN_REQUEST);
        if (inRequest == null) {
            return GlobalConfiguratorImpl.isConfiguratorServiceDisabled((ExternalContext)ec);
        }
        boolean disabled = inRequest;
        if (disabled != GlobalConfiguratorImpl.isConfiguratorServiceDisabled((ExternalContext)ec)) {
            _LOG.warning("Configurator services were disabled after beginRequest was executed.  Cannot disable configurator services");
        }
        return disabled;
    }

    private GlobalConfiguratorImpl() {
    }

    public void beginRequest(ExternalContext ec) {
        assert (ec != null);
        RequestStateMap state = RequestStateMap.getInstance((ExternalContext)ec);
        RequestType requestType = (RequestType)state.get((Object)_REQUEST_TYPE);
        if (requestType == null) {
            requestType = ExternalContextUtils.getRequestType((ExternalContext)ec);
            RequestStateMap.getInstance((ExternalContext)ec).put((Object)_REQUEST_TYPE, (Object)requestType);
            if (!GlobalConfiguratorImpl._isDisabled(ec)) {
                if (!this._initialized.get()) {
                    this.init(ec);
                }
                this._attachRequestContext(ec);
                if (state.get((Object)_IN_REQUEST) == null && !Boolean.TRUE.equals(state.get((Object)_CONFIGURATORS_ABORTED))) {
                    if (this._beginWindowManagerRequest(ec)) {
                        this._startConfiguratorServiceRequest(ec);
                    } else {
                        FacesContext.getCurrentInstance().responseComplete();
                        state.put((Object)_CONFIGURATORS_ABORTED, (Object)Boolean.TRUE);
                    }
                }
            } else {
                _LOG.fine("GlobalConfigurator: Configurators have been disabled for this request.");
            }
        } else {
            if (!requestType.equals((Object)ExternalContextUtils.getRequestType((ExternalContext)ec))) {
                throw new IllegalStateException("The previous action request was not ended.");
            }
            _LOG.fine("BeginRequest called multiple times for this request");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this._initialized.get()) {
            try {
                this._initLock.lock();
                if (this._initialized.get()) {
                    for (Configurator config : this._services) {
                        try {
                            config.destroy();
                        }
                        catch (Throwable t) {
                            _LOG.severe(t);
                        }
                    }
                    this._services = null;
                    this._initialized.set(false);
                }
            }
            finally {
                this._releaseManagedThreadLocals();
                this._initLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endRequest(ExternalContext ec) {
        RequestStateMap state = RequestStateMap.getInstance((ExternalContext)ec);
        if (state.get((Object)_REQUEST_TYPE) != null) {
            try {
                this._endRequest(ec, state);
            }
            finally {
                state.remove((Object)_REQUEST_TYPE);
            }
        }
    }

    public ExternalContext getExternalContext(ExternalContext ec) {
        RequestStateMap state = RequestStateMap.getInstance((ExternalContext)ec);
        RequestType type = (RequestType)state.get((Object)_REQUEST_TYPE);
        ec = new URLEncoderExternalContext((ExternalContext)ec);
        if (type == null) {
            this.beginRequest((ExternalContext)ec);
            type = (RequestType)state.get((Object)_REQUEST_TYPE);
        } else if (!ExternalContextUtils.getRequestType((ExternalContext)ec).equals((Object)type)) {
            throw new IllegalStateException("The expected request type is not the same as the current request type.");
        }
        if (!GlobalConfiguratorImpl._isDisabled(ec)) {
            if (!type.isPortlet() && GlobalConfiguratorImpl._isSetRequestBugPresent(ec)) {
                ec = new ClearRequestExternalContext((ExternalContext)ec);
            }
            for (Configurator config : this._services) {
                ec = config.getExternalContext(ec);
            }
        }
        if (RequestType.ACTION.equals((Object)type)) {
            ec = new RecordRedirectExternalContext((ExternalContext)ec);
        }
        return ec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(ExternalContext ec) {
        assert (ec != null);
        if (!this._initialized.get()) {
            try {
                Object provider;
                Object trinidadSkinProvider;
                Object externalSkinProvider;
                this._initLock.lock();
                if (this._initialized.get()) return;
                this._services = ClassLoaderUtils.getServices((String)Configurator.class.getName());
                this._setupRequestContextFactory();
                if (SkinFactory.getFactory() == null) {
                    SkinFactory.setFactory((SkinFactory)new SkinFactoryImpl());
                }
                if ((externalSkinProvider = ec.getApplicationMap().get("org.apache.myfaces.trinidad.skin.EXTERNAL_SKIN_PROVIDER_INSTANCE")) == null) {
                    ec.getApplicationMap().put("org.apache.myfaces.trinidad.skin.EXTERNAL_SKIN_PROVIDER_INSTANCE", new ExternalSkinProvider());
                }
                if ((trinidadSkinProvider = ec.getApplicationMap().get("org.apache.myfaces.trinidad.skin.TRINIDAD_SKIN_PROVIDER_INSTANCE")) == null) {
                    ec.getApplicationMap().put("org.apache.myfaces.trinidad.skin.TRINIDAD_SKIN_PROVIDER_INSTANCE", new TrinidadSkinProvider());
                }
                if ((provider = ec.getApplicationMap().get("org.apache.myfaces.trinidad.skin.SKIN_PROVIDER_INSTANCE")) == null) {
                    ec.getApplicationMap().put("org.apache.myfaces.trinidad.skin.SKIN_PROVIDER_INSTANCE", new SkinProviderRegistry());
                }
                ConfigPropertyServiceImpl.initialize(ec);
                for (Configurator config : this._services) {
                    config.init(ec);
                }
                this._initialized.set(true);
                return;
            }
            finally {
                this._releaseManagedThreadLocals();
                this._initLock.unlock();
            }
        } else {
            _LOG.warning("CONFIGURATOR_SERVICES_INITIALIZED");
        }
    }

    @Deprecated
    public void reloadSkins(ExternalContext externalContext, SkinFactory skinFactory) {
        for (Configurator config : this._services) {
            config.reloadSkins(externalContext, skinFactory);
        }
    }

    void __setThreadLocalResetter(ThreadLocalResetter resetter) {
        if (resetter == null) {
            throw new NullPointerException();
        }
        this._threadResetter.set(resetter);
    }

    private void _setupRequestContextFactory() {
        if (RequestContextFactory.getFactory() != null) {
            return;
        }
        RequestContextFactoryImpl requestContextFactory = null;
        List factories = ClassLoaderUtils.getServices((String)RequestContextFactory.class.getName());
        requestContextFactory = factories.isEmpty() ? new RequestContextFactoryImpl() : (RequestContextFactory)factories.get(0);
        RequestContextFactory.setFactory((RequestContextFactory)requestContextFactory);
    }

    private void _attachRequestContext(ExternalContext ec) {
        Object cachedRequestContext;
        RequestContext context = RequestContext.getCurrentInstance();
        if (context != null) {
            if (_LOG.isWarning()) {
                _LOG.warning("REQUESTCONTEXT_NOT_PROPERLY_RELEASED");
            }
            this._releaseRequestContext(ec);
        }
        if ((cachedRequestContext = RequestStateMap.getInstance((ExternalContext)ec).get((Object)_REQUEST_CONTEXT)) instanceof RequestContext) {
            context = (RequestContext)cachedRequestContext;
            context.attach();
        } else {
            RequestContextFactory factory = RequestContextFactory.getFactory();
            assert (factory != null);
            context = factory.createContext(ec);
            RequestStateMap.getInstance((ExternalContext)ec).put((Object)_REQUEST_CONTEXT, (Object)context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _endRequest(ExternalContext ec, RequestStateMap state) {
        if (!GlobalConfiguratorImpl._isDisabled(ec)) {
            try {
                this._endConfiguratorServiceRequest(ec, state);
            }
            finally {
                this._releaseRequestState(ec);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _endConfiguratorServiceRequest(ExternalContext ec, RequestStateMap state) {
        boolean isRedirected = null != ec.getRequestMap().remove(_REDIRECT_ISSUED);
        try {
            if ((ExternalContextUtils.isResponseWritable((ExternalContext)ec) || isRedirected) && !Boolean.TRUE.equals(state.get((Object)_CONFIGURATORS_ABORTED))) {
                this._endConfiguratorServices(ec);
            }
        }
        finally {
            if (!isRedirected) {
                state.saveState(ec);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _releaseRequestState(ExternalContext ec) {
        try {
            this._releaseThreadLocals(ec);
        }
        finally {
            this._finishComponentReferenceInitialization(ec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _releaseThreadLocals(ExternalContext ec) {
        try {
            this._releaseRequestContext(ec);
        }
        finally {
            this._releaseManagedThreadLocals();
        }
    }

    private void _releaseRequestContext(ExternalContext ec) {
        RequestContext context = RequestContext.getCurrentInstance();
        if (context != null) {
            context.release();
        }
    }

    private void _releaseManagedThreadLocals() {
        ThreadLocalResetter resetter = this._threadResetter.get();
        if (resetter != null) {
            resetter.__removeThreadLocals();
        }
    }

    private void _finishComponentReferenceInitialization(ExternalContext ec) {
        Map requestMap = ec.getRequestMap();
        Collection initializeList = (Collection)requestMap.get(_FINISH_INITIALIZATION_LIST_KEY);
        if (initializeList != null && !initializeList.isEmpty()) {
            RuntimeException initializationException = null;
            for (ComponentReference reference : initializeList) {
                try {
                    reference.ensureInitialization();
                }
                catch (RuntimeException rte) {
                    initializationException = rte;
                }
            }
            initializeList.clear();
            if (initializationException != null) {
                throw initializationException;
            }
        }
    }

    private void _endConfiguratorServices(ExternalContext ec) {
        RequestStateMap.getInstance((ExternalContext)ec).remove((Object)_IN_REQUEST);
        if (this._services != null) {
            for (Configurator config : this._services) {
                try {
                    config.endRequest(ec);
                }
                catch (Throwable t) {
                    _LOG.severe(t);
                }
            }
        }
    }

    private void _startConfiguratorServiceRequest(ExternalContext ec) {
        boolean disabled = GlobalConfiguratorImpl.isConfiguratorServiceDisabled((ExternalContext)ec);
        RequestStateMap.getInstance((ExternalContext)ec).put((Object)_IN_REQUEST, (Object)disabled);
        for (Configurator config : this._services) {
            try {
                config.beginRequest(ec);
            }
            catch (Throwable t) {
                _LOG.severe(t);
            }
        }
    }

    private boolean _beginWindowManagerRequest(ExternalContext ec) {
        WindowManager wm = RequestContext.getCurrentInstance().getWindowManager();
        boolean cont = true;
        try {
            cont = wm.beginRequest(ec);
        }
        catch (IOException e) {
            _LOG.severe((Throwable)e);
        }
        return cont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean _isSetRequestBugPresent(ExternalContext ec) {
        if (_sSetRequestBugTested) return _sHasSetRequestBug;
        Class<GlobalConfiguratorImpl> clazz = GlobalConfiguratorImpl.class;
        synchronized (GlobalConfiguratorImpl.class) {
            if (_sSetRequestBugTested) return _sHasSetRequestBug;
            ServletRequest orig = (ServletRequest)ec.getRequest();
            ec.getInitParameterMap();
            ec.setRequest((Object)new TestRequest(orig));
            _sHasSetRequestBug = !TestRequest.isTestParamPresent(ec);
            _sSetRequestBugTested = true;
            ec.setRequest((Object)orig);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _sHasSetRequestBug;
        }
    }

    private static class TestRequest
    extends ServletRequestWrapper {
        private static String _TEST_PARAM = TestRequest.class.getName() + ".TEST_PARAM";

        public TestRequest(ServletRequest request) {
            super(request);
        }

        public String getParameter(String string) {
            if (_TEST_PARAM.equals(string)) {
                return "passed";
            }
            return super.getParameter(string);
        }

        public static final boolean isTestParamPresent(ExternalContext ec) {
            return RequestStateMap.getInstance((ExternalContext)ec).get((Object)_TEST_PARAM) != null;
        }
    }

    @ExcludeFromManagedRequestScope
    private static class AppliedClass {
        public static final AppliedClass APPLIED = new AppliedClass();

        private AppliedClass() {
        }
    }

    private static class RecordRedirectExternalContext
    extends ExternalContextDecorator {
        private ExternalContext _ec;

        public RecordRedirectExternalContext(ExternalContext ec) {
            assert (ec != null);
            this._ec = ec;
        }

        public void redirect(String url) throws IOException {
            super.redirect(url);
            this._ec.getRequestMap().put(_REDIRECT_ISSUED, AppliedClass.APPLIED);
        }

        protected ExternalContext getExternalContext() {
            return this._ec;
        }
    }

    private static class ClearRequestExternalContext
    extends ExternalContextDecorator {
        private ExternalContext _ec;
        private Map<String, Object> _requestCookieMap;
        private Map<String, String> _requestHeaderMap;
        private Map<String, String[]> _requestHeaderValuesMap;
        private Map<String, Object> _requestMap;
        private Map<String, String> _requestParameterMap;
        private Map<String, String[]> _requestParameterValuesMap;

        public ClearRequestExternalContext(ExternalContext ec) {
            this._ec = ec;
        }

        protected ExternalContext getExternalContext() {
            return this._ec;
        }

        public void setRequest(Object request) {
            super.setRequest(request);
            this._requestCookieMap = null;
            this._requestHeaderMap = null;
            this._requestHeaderValuesMap = null;
            this._requestMap = null;
            this._requestParameterMap = null;
            this._requestParameterValuesMap = null;
        }

        public Map<String, Object> getRequestCookieMap() {
            this._checkRequest();
            if (this._requestCookieMap == null) {
                this._requestCookieMap = new ServletCookieMap(this._getHttpServletRequest());
            }
            return this._requestCookieMap;
        }

        public Map<String, String> getRequestHeaderMap() {
            if (this._requestHeaderMap == null) {
                this._requestHeaderMap = new ServletRequestHeaderMap(this._getHttpServletRequest());
            }
            return this._requestHeaderMap;
        }

        public Map<String, String[]> getRequestHeaderValuesMap() {
            if (this._requestHeaderValuesMap == null) {
                this._requestHeaderValuesMap = new ServletRequestHeaderValuesMap(this._getHttpServletRequest());
            }
            return this._requestHeaderValuesMap;
        }

        public Map<String, Object> getRequestMap() {
            this._checkRequest();
            if (this._requestMap == null) {
                this._requestMap = new ServletRequestMap((ServletRequest)this.getRequest());
            }
            return this._requestMap;
        }

        public Map<String, String> getRequestParameterMap() {
            this._checkRequest();
            if (this._requestParameterMap == null) {
                this._requestParameterMap = new ServletRequestParameterMap((ServletRequest)this.getRequest());
            }
            return this._requestParameterMap;
        }

        public Map<String, String[]> getRequestParameterValuesMap() {
            this._checkRequest();
            if (this._requestParameterValuesMap == null) {
                this._requestParameterValuesMap = new ServletRequestParameterValuesMap((ServletRequest)this.getRequest());
            }
            return this._requestParameterValuesMap;
        }

        private void _checkRequest() {
            if (super.getRequest() == null) {
                throw new UnsupportedOperationException("Request is null on this context.");
            }
        }

        private HttpServletRequest _getHttpServletRequest() {
            this._checkRequest();
            if (!(this.getRequest() instanceof HttpServletRequest)) {
                throw new IllegalArgumentException("Only HttpServletRequest supported");
            }
            return (HttpServletRequest)this.getRequest();
        }
    }
}

