/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.application;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.application.StateManagerWrapper;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.ResponseStateManager;
import javax.faces.view.StateManagementStrategy;
import javax.faces.view.ViewDeclarationLanguage;
import javax.servlet.http.HttpSession;
import org.apache.myfaces.trinidad.bean.util.StateUtils;
import org.apache.myfaces.trinidad.component.UIXComponentBase;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.context.Window;
import org.apache.myfaces.trinidad.context.WindowManager;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidad.util.ExternalContextUtils;
import org.apache.myfaces.trinidad.util.ref.PseudoReference;
import org.apache.myfaces.trinidad.util.ref.PseudoReferenceFactory;
import org.apache.myfaces.trinidad.util.ref.SoftPseudoReferenceFactory;
import org.apache.myfaces.trinidad.util.ref.StrongPseudoReferenceFactory;
import org.apache.myfaces.trinidadinternal.application.Structure;
import org.apache.myfaces.trinidadinternal.context.TrinidadPhaseListener;
import org.apache.myfaces.trinidadinternal.util.ObjectInputStreamResolveClass;
import org.apache.myfaces.trinidadinternal.util.SubKeyMap;
import org.apache.myfaces.trinidadinternal.util.TokenCache;
import org.apache.myfaces.trinidadinternal.util.TokenCacheDebugUtils;

public class StateManagerImpl
extends StateManagerWrapper {
    public static final String RESPONSE_STATE_MANAGER_STATE_KEY = "org.apache.myfaces.trinidadinternal.application.StateManagerImp.RESPONSE_STATE_MANAGER_STATE";
    public static final String CACHE_VIEW_ROOT_INIT_PARAM = "org.apache.myfaces.trinidad.CACHE_VIEW_ROOT";
    public static final String CLIENT_STATE_METHOD_PARAM_NAME = "org.apache.myfaces.trinidad.CLIENT_STATE_METHOD";
    public static final String CLIENT_STATE_MAX_TOKENS_PARAM_NAME = "org.apache.myfaces.trinidad.CLIENT_STATE_MAX_TOKENS";
    public static final String COMPRESS_VIEW_STATE_PARAM_NAME = "org.apache.myfaces.trinidad.COMPRESS_VIEW_STATE";
    public static final String CLIENT_STATE_METHOD_TOKEN = "token";
    public static final String CLIENT_STATE_METHOD_ALL = "all";
    private static final boolean _CACHE_VIEW_ROOT_PER_WINDOW = false;
    private final StateManager _delegate;
    private AtomicReference<PseudoReferenceFactory<ViewRootState>> _viewRootStateRefFactoryHolder;
    private static final Character _SUBKEY_SEPARATOR = new Character('.');
    private static final int _DEFAULT_CACHE_SIZE = 15;
    private static final String _VIEW_CACHE_KEY = "org.apache.myfaces.trinidadinternal.application.VIEW_CACHE";
    private static final String _PER_PAGE_STATE_SAVING = "org.apache.myfaces.trinidadimpl.PER_PAGE_STATE_SAVING";
    private static final String _CACHED_VIEW_STATE = "org.apache.myfaces.trinidadinternal.application.CachedViewState";
    private static final String _REQUEST_STATE_TOKEN_KEY = "org.apache.myfaces.trinidadinternal.application.REQUEST_STATE_TOKEN";
    private static final String _PINNED_STATE_TOKEN_KEY = "org.apache.myfaces.trinidadinternal.application.PINNED_STATE_TOKEN";
    private static final String _REUSE_REQUEST_TOKEN_FOR_RESPONSE_KEY = "org.apache.myfaces.trinidadinternal.application.REUSE_REQUEST_TOKEN_FOR_RESPONSE";
    private static final String _ACTIVE_PAGE_TOKEN_SESSION_KEY = "org.apache.myfaces.trinidadinternal.application.StateManagerImp.ACTIVE_PAGE_STATE";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(StateManagerImpl.class);

    public StateManagerImpl(StateManager delegate) {
        this._delegate = delegate;
    }

    public StateManager getWrapped() {
        return this._delegate;
    }

    public String getViewState(FacesContext context) {
        Object state = this.saveView(context);
        if (state != null) {
            return context.getRenderKit().getResponseStateManager().getViewState(context, state);
        }
        return null;
    }

    private boolean _useViewRootCache(FacesContext context, RequestContext trinContext) {
        return this._getOrCreateViewRootStateRefFactory(context, trinContext) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object saveView(FacesContext context) {
        assert (context != null);
        Object viewState = this._getCachedViewState(context);
        if (viewState != null) {
            return viewState;
        }
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot.isTransient()) {
            return null;
        }
        String viewId = viewRoot.getViewId();
        StateManagementStrategy sms = this._getStateManagementStrategy(context, viewId);
        Map contextAttributes = context.getAttributes();
        try {
            contextAttributes.put("javax.faces.IS_SAVING_STATE", Boolean.TRUE);
            if (sms != null) {
                if (this._useViewRootCache(context, RequestContext.getCurrentInstance())) {
                    viewRoot.clearInitialState();
                }
                viewState = sms.saveView(context);
            } else {
                StateManagerImpl._removeTransientComponents((UIComponent)viewRoot);
                Structure structure = !this._needStructure(context) ? null : new Structure((UIComponent)viewRoot);
                Object state = viewRoot.processSaveState(context);
                viewState = new Object[]{structure, state};
            }
        }
        finally {
            contextAttributes.remove("javax.faces.IS_SAVING_STATE");
        }
        if (this._saveAsToken(context, false)) {
            viewState = this._saveStateToCache(context, viewState, viewRoot);
        }
        this._saveCachedViewState(context, viewState);
        return viewState;
    }

    public static Object saveComponentTree(FacesContext context, UIComponent component) {
        Structure structure = new Structure(component);
        Object state = component.processSaveState(context);
        return new PageState(context, StateManagerImpl._getViewRootStateRefFactory(context, RequestContext.getCurrentInstance()), new Object[]{structure, state}, null);
    }

    public static UIComponent restoreComponentTree(FacesContext context, Object savedState) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (savedState == null) {
            throw new NullPointerException();
        }
        if (!(savedState instanceof PageState)) {
            throw new IllegalArgumentException(_LOG.getMessage("INVALID_SAVED_STATE_OBJECT"));
        }
        PageState viewState = (PageState)savedState;
        Object[] stateArray = (Object[])viewState.getViewState(context);
        Object structure = stateArray[0];
        Object state = stateArray[1];
        UIComponent component = ((Structure)structure).createComponent();
        if (state != null) {
            component.processRestoreState(context, state);
        }
        return component;
    }

    public static Object saveViewRoot(FacesContext context, UIViewRoot root) {
        StateManagerImpl._removeTransientComponents((UIComponent)root);
        Structure structure = new Structure((UIComponent)root);
        Object state = root.processSaveState(context);
        return new PageState(context, StateManagerImpl._getViewRootStateRefFactory(context, RequestContext.getCurrentInstance()), new Object[]{structure, state}, root);
    }

    public static UIViewRoot restoreViewRoot(FacesContext context, Object saved) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (saved == null) {
            throw new NullPointerException();
        }
        PageState viewState = (PageState)saved;
        UIViewRoot root = viewState.popRoot(context);
        if (root != null) {
            return root;
        }
        Object[] stateArray = (Object[])viewState.getViewState(context);
        Object structure = stateArray[0];
        Object state = stateArray[1];
        root = (UIViewRoot)((Structure)structure).createComponent();
        if (state != null) {
            root.processRestoreState(context, state);
        }
        return root;
    }

    private Object _saveStateToCache(FacesContext context, Object viewState, UIViewRoot root) {
        String token;
        ExternalContext extContext = context.getExternalContext();
        RequestContext trinContext = RequestContext.getCurrentInstance();
        TokenCache cache = this._getViewCache(trinContext, extContext);
        assert (cache != null);
        String subkey = StateManagerImpl._getViewCacheKey(extContext, trinContext, _SUBKEY_SEPARATOR);
        Map sessionMap = extContext.getSessionMap();
        SubKeyMap<PageState> stateMap = new SubKeyMap<PageState>(sessionMap, subkey);
        PageState pageState = new PageState(context, this._getOrCreateViewRootStateRefFactory(context, trinContext), viewState, root);
        String requestToken = StateManagerImpl._getRequestTokenForResponse(context);
        if (requestToken != null && cache.isAvailable(requestToken)) {
            stateMap.put(requestToken, pageState);
            token = requestToken;
        } else {
            String pinnedToken = (String)extContext.getRequestMap().get(_PINNED_STATE_TOKEN_KEY);
            token = cache.addNewEntry(pageState, stateMap, pinnedToken);
        }
        assert (token != null);
        extContext.getRequestMap().put(_REQUEST_STATE_TOKEN_KEY, token);
        String newActivePageStateKey = stateMap.getBaseKey(token);
        this._clearViewRootCache(extContext, newActivePageStateKey);
        return new Object[]{token, null};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clearViewRootCache(ExternalContext extContext, String newActivePageStateKey) {
        Map sessionMap = extContext.getSessionMap();
        Object object = extContext.getSession(true);
        synchronized (object) {
            String keyToActivePageStateKey = _ACTIVE_PAGE_TOKEN_SESSION_KEY;
            String oldActivePageStateKey = (String)sessionMap.get(keyToActivePageStateKey);
            if (!newActivePageStateKey.equals(oldActivePageStateKey)) {
                PageState activePageState;
                if (oldActivePageStateKey != null && (activePageState = (PageState)sessionMap.get(oldActivePageStateKey)) != null) {
                    activePageState.clearViewRootState();
                }
                sessionMap.put(keyToActivePageStateKey, newActivePageStateKey);
            }
        }
    }

    public static String getActivePageToken(RequestContext trinContext, ExternalContext external) {
        String activePageStateKey = StateManagerImpl._getActivePageTokenKey(external, trinContext);
        if (activePageStateKey != null) {
            String tokenPrefix = StateManagerImpl._getViewCacheKey(external, trinContext, _SUBKEY_SEPARATOR);
            String tokenSuffix = (String)external.getSessionMap().get(activePageStateKey);
            return tokenPrefix + tokenSuffix;
        }
        return null;
    }

    public static void pinStateToRequest(FacesContext context, String stateToken) {
        context.getExternalContext().getRequestMap().put(_PINNED_STATE_TOKEN_KEY, stateToken);
    }

    public static String getStateToken(FacesContext context) {
        return (String)context.getExternalContext().getRequestMap().get(_REQUEST_STATE_TOKEN_KEY);
    }

    public static void reuseRequestTokenForResponse(ExternalContext ec) {
        ec.getRequestMap().put(_REUSE_REQUEST_TOKEN_FOR_RESPONSE_KEY, Boolean.TRUE);
    }

    public static void clearReuseRequestTokenForResponse(ExternalContext ec) {
        ec.getRequestMap().remove(_REUSE_REQUEST_TOKEN_FOR_RESPONSE_KEY);
    }

    private static void _updateRequestTokenForResponse(FacesContext context, String token) {
        Map requestMap = context.getExternalContext().getRequestMap();
        if (Boolean.TRUE.equals(requestMap.get(_REUSE_REQUEST_TOKEN_FOR_RESPONSE_KEY))) {
            requestMap.put(_REUSE_REQUEST_TOKEN_FOR_RESPONSE_KEY, token);
        }
    }

    private static String _getRequestTokenForResponse(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        Object token = requestMap.get(_REUSE_REQUEST_TOKEN_FOR_RESPONSE_KEY);
        if (Boolean.TRUE.equals(token)) {
            return null;
        }
        return (String)token;
    }

    public static boolean isValidViewStateToken(ExternalContext external, String token) {
        if (token != null && StateManagerImpl._calculateTokenStateSaving(external, true)) {
            return StateManagerImpl._getPageState(external, token) != null;
        }
        return false;
    }

    public static void remapViewState(ExternalContext external, String windowId, String token) {
        String oldSubkey = StateManagerImpl._getViewCacheKey(external, null, _SUBKEY_SEPARATOR);
        Map sessionMap = external.getSessionMap();
        SubKeyMap oldStateMap = new SubKeyMap(sessionMap, oldSubkey);
        PageState viewState = (PageState)oldStateMap.remove(token);
        if (viewState == null) {
            throw new IllegalArgumentException();
        }
        String windowSubkey = StateManagerImpl._getPerWindowCacheKey(windowId, _VIEW_CACHE_KEY, _SUBKEY_SEPARATOR);
        SubKeyMap<PageState> newStateMap = new SubKeyMap<PageState>(sessionMap, windowSubkey);
        newStateMap.put(token, viewState);
    }

    public static void removeViewStatesForWindow(ExternalContext extContext, String windowId) {
        String cacheKey = StateManagerImpl._getPerWindowCacheKey(windowId, _VIEW_CACHE_KEY, null);
        TokenCache cache = TokenCache.getTokenCacheFromSession(extContext, cacheKey, false, -1);
        if (cache != null) {
            String subkey = StateManagerImpl._getPerWindowCacheKey(windowId, _VIEW_CACHE_KEY, _SUBKEY_SEPARATOR);
            Map sessionMap = extContext.getSessionMap();
            SubKeyMap stateMap = new SubKeyMap(sessionMap, subkey);
            cache.clear(stateMap);
            sessionMap.remove(cacheKey);
        }
    }

    private static PageState _getPageState(ExternalContext external, String token) {
        String subkey = StateManagerImpl._getViewCacheKey(external, RequestContext.getCurrentInstance(), _SUBKEY_SEPARATOR);
        SubKeyMap stateMap = new SubKeyMap(external.getSessionMap(), subkey);
        return (PageState)stateMap.get(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        UIViewRoot root;
        Object state;
        Object structure;
        ExternalContext extContext = context.getExternalContext();
        Map requestMap = extContext.getRequestMap();
        UIViewRoot launchView = (UIViewRoot)requestMap.remove("org.apache.myfaces.trinidad.PageFlowSourceView");
        if (launchView != null) {
            TrinidadPhaseListener.markPostback(context);
            return launchView;
        }
        ResponseStateManager rsm = StateManagerImpl._getResponseStateManager(context, renderKitId);
        if (this._saveAsToken(context, true)) {
            String token = (String)rsm.getTreeStructureToRestore(context, viewId);
            if (token == null) {
                _LOG.finest("No token in the request for view \"{0}\";  probably a first view.", (Object)viewId);
                return null;
            }
            _LOG.finer("Restoring saved view state for token {0}", (Object)token);
            PageState viewState = StateManagerImpl._getPageState(extContext, token);
            if (viewState != null) {
                StateManagerImpl._updateRequestTokenForResponse(context, token);
            }
            RequestContext trinContext = RequestContext.getCurrentInstance();
            boolean isAvailable = this._getViewCache(trinContext, extContext).isAvailable(token);
            assert (viewState != null == isAvailable);
            if (viewState == null) {
                _LOG.severe("CANNOT_FIND_SAVED_VIEW_STATE", (Object)token);
                if (TokenCacheDebugUtils.debugTokenCache()) {
                    TokenCacheDebugUtils.startLog("Restore View");
                    String sessionId = "";
                    boolean isNewSession = false;
                    Object session = extContext.getSession(false);
                    if (session == null) {
                        isNewSession = true;
                    } else if (session instanceof HttpSession) {
                        isNewSession = ((HttpSession)session).isNew();
                        sessionId = ((HttpSession)session).getId();
                    }
                    if (isNewSession) {
                        TokenCacheDebugUtils.addToLog("The session is new. Session id = " + sessionId);
                    } else {
                        TokenCacheDebugUtils.addToLog("The session is NOT new. Session id = " + sessionId);
                    }
                    String subkey = StateManagerImpl._getViewCacheKey(extContext, RequestContext.getCurrentInstance(), _SUBKEY_SEPARATOR);
                    SubKeyMap stateMap = new SubKeyMap(extContext.getSessionMap(), subkey);
                    TokenCacheDebugUtils.logCacheInfo(stateMap, null, "token '" + token + "' not found");
                    _LOG.severe(TokenCacheDebugUtils.getLogString());
                }
                return null;
            }
            _LOG.fine("Successfully found view state for token {0}", (Object)token);
            UIViewRoot root2 = viewState.popRoot(context);
            if (root2 != null) {
                _LOG.finer("UIViewRoot for token {0} already exists. Bypassing restoreState", (Object)token);
                return root2;
            }
            StateManagementStrategy sms = this._getStateManagementStrategy(context, viewId);
            if (sms != null) {
                try {
                    requestMap.put(RESPONSE_STATE_MANAGER_STATE_KEY, viewState.getViewState(context));
                    root2 = sms.restoreView(context, viewId, renderKitId);
                }
                finally {
                    requestMap.remove(RESPONSE_STATE_MANAGER_STATE_KEY);
                }
                return root2;
            }
            Object[] stateArray = (Object[])viewState.getViewState(context);
            structure = stateArray[0];
            state = stateArray[1];
        } else {
            StateManagementStrategy sms = this._getStateManagementStrategy(context, viewId);
            if (sms != null) {
                return sms.restoreView(context, viewId, renderKitId);
            }
            Object[] stateArray = (Object[])rsm.getState(context, viewId);
            structure = stateArray[0];
            state = stateArray[1];
        }
        if (structure == null) {
            root = context.getViewRoot();
            if (root == null && this._needStructure(context)) {
                _LOG.severe("NO_STRUCTURE_ROOT_AVAILABLE");
                return null;
            }
            if (state != null) {
                root.processRestoreState(context, state);
            }
            return root;
        }
        if (!(structure instanceof Structure)) {
            _LOG.severe("NO_STRUCTURE_AVAILABLE");
            return null;
        }
        try {
            root = (UIViewRoot)((Structure)structure).createComponent();
            if (state != null) {
                root.processRestoreState(context, state);
            }
            _LOG.finer("Restored state for view \"{0}\"", (Object)viewId);
            return root;
        }
        catch (ClassNotFoundException cnfe) {
            _LOG.severe((Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            _LOG.severe((Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            _LOG.severe((Throwable)iae);
        }
        return null;
    }

    public void setPerViewStateSaving(String perViewStateSaving) {
        Map attrs = FacesContext.getCurrentInstance().getAttributes();
        attrs.put(_PER_PAGE_STATE_SAVING, StateSaving.valueOf(perViewStateSaving.toUpperCase()));
    }

    public boolean isSavingStateInClient(FacesContext context) {
        return this._delegate.isSavingStateInClient(context);
    }

    protected Object getTreeStructureToSave(FacesContext context) {
        throw new UnsupportedOperationException();
    }

    protected Object getComponentStateToSave(FacesContext context) {
        throw new UnsupportedOperationException();
    }

    protected UIViewRoot restoreTreeStructure(FacesContext context, String viewId, String renderKitId) {
        throw new UnsupportedOperationException();
    }

    protected void restoreComponentState(FacesContext context, UIViewRoot viewRoot, String renderKitId) {
        throw new UnsupportedOperationException();
    }

    private static String _getTokenCacheKey(RequestContext trinContext, ExternalContext extContext) {
        return StateManagerImpl._getViewCacheKey(extContext, trinContext, null);
    }

    private TokenCache _getViewCache(RequestContext trinContext, ExternalContext extContext) {
        String cacheKey = StateManagerImpl._getTokenCacheKey(trinContext, extContext);
        return TokenCache.getTokenCacheFromSession(extContext, cacheKey, true, this._getCacheSize(extContext));
    }

    private static String _getActivePageTokenKey(ExternalContext extContext, RequestContext trinContext) {
        return StateManagerImpl._getPerWindowCacheKey(StateManagerImpl._getCurrWindowId(extContext, trinContext), _ACTIVE_PAGE_TOKEN_SESSION_KEY, null);
    }

    private static String _getViewCacheKey(ExternalContext extContext, RequestContext trinContext, Character suffix) {
        return StateManagerImpl._getPerWindowCacheKey(StateManagerImpl._getCurrWindowId(extContext, trinContext), _VIEW_CACHE_KEY, suffix);
    }

    private static String _getCurrWindowId(ExternalContext external, RequestContext trinContext) {
        Window currWindow;
        WindowManager wm;
        if (trinContext != null && (wm = trinContext.getWindowManager()) != null && (currWindow = wm.getCurrentWindow(external)) != null) {
            return currWindow.getId();
        }
        return null;
    }

    private static String _getPerWindowCacheKey(String windowId, String prefix, Character suffix) {
        if (windowId != null || suffix != null) {
            int windowPartSize = windowId != null ? windowId.length() + 1 : 0;
            int builderSize = prefix.length() + windowPartSize;
            if (suffix != null) {
                ++builderSize;
            }
            StringBuilder keyBuilder = new StringBuilder(builderSize);
            keyBuilder.append(prefix);
            if (windowId != null) {
                keyBuilder.append('.');
                keyBuilder.append(windowId);
            }
            if (suffix != null) {
                keyBuilder.append(suffix);
            }
            return keyBuilder.toString();
        }
        return prefix;
    }

    private static boolean _calculateTokenStateSaving(ExternalContext external, boolean checkRequestToken) {
        UIViewRoot viewRoot;
        String viewStateValue;
        Map initParameters = external.getInitParameterMap();
        Object stateSavingMethod = initParameters.get("javax.faces.STATE_SAVING_METHOD");
        if (stateSavingMethod == null || "server".equalsIgnoreCase((String)stateSavingMethod)) {
            return true;
        }
        Object clientMethod = initParameters.get(CLIENT_STATE_METHOD_PARAM_NAME);
        if (clientMethod != null && CLIENT_STATE_METHOD_ALL.equalsIgnoreCase((String)clientMethod)) {
            return false;
        }
        if (checkRequestToken && (viewStateValue = (String)external.getRequestParameterMap().get("javax.faces.ViewState")) != null && !viewStateValue.startsWith("!")) {
            return false;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        return context == null || (viewRoot = context.getViewRoot()) == null || !"HTML_BASIC".equals(viewRoot.getRenderKitId());
    }

    private boolean _saveAsToken(FacesContext context, boolean checkRequestToken) {
        Map attrMap = FacesContext.getCurrentInstance().getAttributes();
        StateSaving stateSaving = (StateSaving)((Object)attrMap.get(_PER_PAGE_STATE_SAVING));
        Boolean forceStateSavingPerView = null;
        if (StateSaving.CLIENT.equals((Object)stateSaving)) {
            forceStateSavingPerView = Boolean.FALSE;
        } else if (StateSaving.SERVER.equals((Object)stateSaving)) {
            forceStateSavingPerView = Boolean.TRUE;
        }
        if (forceStateSavingPerView != null) {
            return forceStateSavingPerView;
        }
        return StateManagerImpl._calculateTokenStateSaving(context.getExternalContext(), checkRequestToken);
    }

    private int _getCacheSize(ExternalContext extContext) {
        Object maxTokens = extContext.getInitParameterMap().get(CLIENT_STATE_MAX_TOKENS_PARAM_NAME);
        if (maxTokens != null) {
            try {
                return Math.max(1, Integer.parseInt((String)maxTokens));
            }
            catch (NumberFormatException nfe) {
                _LOG.warning("Ignoring servlet init parameter:org.apache.myfaces.trinidad.CLIENT_STATE_MAX_TOKENS\n unable to parse:" + maxTokens, (Throwable)nfe);
                _LOG.warning((Throwable)nfe);
            }
        }
        return 15;
    }

    private PseudoReferenceFactory<ViewRootState> _getOrCreateViewRootStateRefFactory(FacesContext context, RequestContext trinContext) {
        if (this._viewRootStateRefFactoryHolder == null) {
            this._viewRootStateRefFactoryHolder = StateManagerImpl._getViewRootStateRefFactoryHolder(context, trinContext);
        }
        return this._viewRootStateRefFactoryHolder.get();
    }

    private static PseudoReferenceFactory<ViewRootState> _getViewRootStateRefFactory(FacesContext context, RequestContext trinContext) {
        return StateManagerImpl._getViewRootStateRefFactoryHolder(context, trinContext).get();
    }

    private static AtomicReference<PseudoReferenceFactory<ViewRootState>> _getViewRootStateRefFactoryHolder(FacesContext context, RequestContext trinContext) {
        PseudoReferenceFactory<ViewRootState> factory;
        ConcurrentMap sharedAppMap = trinContext.getApplicationScopedConcurrentMap();
        AtomicReference<Object> factoryHolder = (AtomicReference<Object>)sharedAppMap.get(CACHE_VIEW_ROOT_INIT_PARAM);
        if (factoryHolder != null) {
            return factoryHolder;
        }
        ExternalContext extContext = context.getExternalContext();
        String viewRootCaching = extContext.getInitParameter(CACHE_VIEW_ROOT_INIT_PARAM);
        String caseInsensitiveViewRootCaching = viewRootCaching != null && viewRootCaching.length() > 0 ? viewRootCaching.toLowerCase() : "true";
        if ("false".equals(caseInsensitiveViewRootCaching)) {
            factory = null;
        } else if ("strong".equals(caseInsensitiveViewRootCaching)) {
            factory = new PseudoReferenceFactory<ViewRootState>();
        } else if ("soft".equals(caseInsensitiveViewRootCaching)) {
            factory = new SoftPseudoReferenceFactory();
        } else if ("true".equals(caseInsensitiveViewRootCaching)) {
            factory = StateManagerImpl._instantiateDefaultPseudoReferenceFactory();
        } else {
            factory = StateManagerImpl._instantiatePseudoReferenceFactoryFromClass(viewRootCaching);
            if (factory == null) {
                factory = StateManagerImpl._instantiateDefaultPseudoReferenceFactory();
            }
        }
        factoryHolder = new AtomicReference<Object>(factory);
        sharedAppMap.put(CACHE_VIEW_ROOT_INIT_PARAM, factoryHolder);
        return factoryHolder;
    }

    private static PseudoReferenceFactory<ViewRootState> _instantiateDefaultPseudoReferenceFactory() {
        StrongPseudoReferenceFactory factory = new StrongPseudoReferenceFactory();
        Object service = ClassLoaderUtils.getService((String)CACHE_VIEW_ROOT_INIT_PARAM);
        if (service != null) {
            try {
                factory = (PseudoReferenceFactory)service;
            }
            catch (ClassCastException e) {
                _LOG.warning("Default service registered for org.apache.myfaces.trinidad.CACHE_VIEW_ROOT is not of the correct type.", (Throwable)e);
            }
        }
        return factory;
    }

    private static PseudoReferenceFactory<ViewRootState> _instantiatePseudoReferenceFactoryFromClass(String className) {
        try {
            Class factoryClass = ClassLoaderUtils.loadClass((String)className);
            return (PseudoReferenceFactory)factoryClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            _LOG.warning("Could not find PseudoReferenceFactory class " + className + " for " + " Servlet Initialization Parameter " + CACHE_VIEW_ROOT_INIT_PARAM);
        }
        catch (InstantiationException e) {
            StateManagerImpl._logInstantiationError(className, e);
        }
        catch (IllegalAccessException e) {
            StateManagerImpl._logInstantiationError(className, e);
        }
        catch (ClassCastException e) {
            StateManagerImpl._logInstantiationError(className, e);
        }
        return null;
    }

    private static void _logInstantiationError(String className, Throwable e) {
        _LOG.warning("Could not instantiate a PseudoReferenceFactory for Servlet Initialization Parameter org.apache.myfaces.trinidad.CACHE_VIEW_ROOT with value " + className, e);
    }

    private boolean _needStructure(FacesContext context) {
        return true;
    }

    private static ResponseStateManager _getResponseStateManager(FacesContext context, String renderKitId) {
        RenderKitFactory factory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit kit = factory.getRenderKit(context, renderKitId);
        return kit.getResponseStateManager();
    }

    private static void _removeTransientComponents(UIComponent root) {
        ArrayList<UIComponent> components = new ArrayList<UIComponent>();
        StateManagerImpl._gatherTransientComponents(root, components);
        for (UIComponent kid : components) {
            List children;
            UIComponent parent = kid.getParent();
            if (parent.getChildCount() > 0 && (children = parent.getChildren()).remove(kid)) continue;
            Map facets = parent.getFacets();
            Iterator facetIter = facets.values().iterator();
            while (facetIter.hasNext()) {
                if (facetIter.next() != kid) continue;
                facetIter.remove();
            }
            assert (false);
        }
    }

    private static void _gatherTransientComponents(UIComponent component, List<UIComponent> componentsToRemove) {
        Iterator kids = component.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!(component instanceof UIXComponentBase) && kid.isTransient()) {
                componentsToRemove.add(kid);
                continue;
            }
            StateManagerImpl._gatherTransientComponents(kid, componentsToRemove);
        }
    }

    private Object _getCachedViewState(FacesContext context) {
        return context.getExternalContext().getRequestMap().get(_CACHED_VIEW_STATE);
    }

    private void _saveCachedViewState(FacesContext context, Object state) {
        context.getExternalContext().getRequestMap().put(_CACHED_VIEW_STATE, state);
    }

    private StateManagementStrategy _getStateManagementStrategy(FacesContext context, String viewId) {
        ViewDeclarationLanguage vdl = context.getApplication().getViewHandler().getViewDeclarationLanguage(context, viewId);
        if (vdl != null) {
            return vdl.getStateManagementStrategy(context, viewId);
        }
        return null;
    }

    private static enum StateSaving {
        DEFAULT("default"),
        CLIENT("client"),
        SERVER("server");

        private String _stateSaving;

        private StateSaving(String stateSaving) {
            this._stateSaving = stateSaving;
        }
    }

    private static final class PageState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Object _viewState;
        private transient PseudoReference<ViewRootState> _cachedState;

        public PageState(FacesContext context, PseudoReferenceFactory<ViewRootState> viewRootStateRefFactory, Object viewState, UIViewRoot root) {
            if (!(viewState instanceof Serializable)) {
                throw new IllegalArgumentException("Viewstate " + viewState + " is not a Serializable");
            }
            boolean zipState = this._zipState(context);
            if (zipState || StateUtils.checkComponentTreeStateSerialization((FacesContext)context)) {
                if (zipState) {
                    this._viewState = this._zipToBytes(viewState);
                } else {
                    this._viewState = viewState;
                    try {
                        new ObjectOutputStream(new ByteArrayOutputStream()).writeObject(viewState);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(_LOG.getMessage("COMPONENT_TREE_SERIALIZATION_FAILED"), e);
                    }
                }
            } else {
                this._viewState = viewState;
            }
            this._cachedState = root != null && viewRootStateRefFactory != null ? viewRootStateRefFactory.create((Object)new ViewRootState(context, root), null) : null;
        }

        public Object getViewState(FacesContext context) {
            if (this._zipState(context)) {
                return this._unzipBytes((byte[])this._viewState);
            }
            return this._viewState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearViewRootState() {
            PageState pageState = this;
            synchronized (pageState) {
                this._cachedState = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UIViewRoot popRoot(FacesContext fc) {
            UIViewRoot root = null;
            Object viewRootState = null;
            PageState pageState = this;
            synchronized (pageState) {
                if (this._cachedState != null) {
                    ViewRootState rootState = (ViewRootState)this._cachedState.get();
                    if (rootState != null) {
                        root = rootState.getViewRoot();
                        viewRootState = rootState.getViewRootState();
                    }
                    this._cachedState = null;
                }
            }
            if (root != null) {
                UIViewRoot newRoot = (UIViewRoot)fc.getApplication().createComponent("javax.faces.ViewRoot");
                if (ExternalContextUtils.isPortlet((ExternalContext)fc.getExternalContext())) {
                    try {
                        newRoot = (UIViewRoot)root.getClass().newInstance();
                    }
                    catch (InstantiationException e) {
                        _LOG.finest("Unable to instantiate new root of type class \"{0}\".", root.getClass());
                    }
                    catch (IllegalAccessException e) {
                        _LOG.finest("IllegalAccessException on new root of type class \"{0}\".", root.getClass());
                    }
                }
                newRoot.restoreState(fc, viewRootState);
                ArrayList temp = new ArrayList(root.getChildCount());
                temp.addAll(root.getChildren());
                newRoot.getChildren().addAll(temp);
                if (root.getFacetCount() > 0) {
                    HashMap facets = new HashMap(root.getFacetCount());
                    facets.putAll(root.getFacets());
                    newRoot.getFacets().putAll(facets);
                }
                return newRoot;
            }
            return null;
        }

        private boolean _zipState(FacesContext fc) {
            String zipStateObject = fc.getExternalContext().getInitParameter(StateManagerImpl.COMPRESS_VIEW_STATE_PARAM_NAME);
            if (zipStateObject == null) {
                return false;
            }
            return zipStateObject.toString().equalsIgnoreCase("true");
        }

        private Object _unzipBytes(byte[] zippedBytes) {
            Inflater decompressor = new Inflater();
            try {
                decompressor.setInput(zippedBytes);
                ByteArrayOutputStream bos = new ByteArrayOutputStream(zippedBytes.length);
                byte[] buf = new byte[zippedBytes.length * 5];
                while (!decompressor.finished()) {
                    try {
                        int count = decompressor.inflate(buf);
                        bos.write(buf, 0, count);
                    }
                    catch (DataFormatException e) {
                        throw new RuntimeException(_LOG.getMessage("UNZIP_STATE_FAILED"), e);
                    }
                }
                ByteArrayInputStream baos = new ByteArrayInputStream(bos.toByteArray());
                ObjectInputStreamResolveClass ois = new ObjectInputStreamResolveClass(baos);
                Object unzippedState = ois.readObject();
                ois.close();
                Object object = unzippedState;
                return object;
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(_LOG.getMessage("UNZIP_STATE_FAILED"), cnfe);
            }
            catch (IOException ioe) {
                throw new RuntimeException(_LOG.getMessage("UNZIP_STATE_FAILED"), ioe);
            }
            finally {
                decompressor.end();
            }
        }

        private byte[] _zipToBytes(Object viewState) {
            Deflater compresser = new Deflater(1);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(viewState);
                oos.flush();
                oos.close();
                byte[] ret = baos.toByteArray();
                compresser.setInput(ret);
                compresser.finish();
                baos.reset();
                byte[] buf = new byte[ret.length / 5];
                while (!compresser.finished()) {
                    int count = compresser.deflate(buf);
                    baos.write(buf, 0, count);
                }
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
            catch (IOException e) {
                throw new RuntimeException(_LOG.getMessage("ZIP_STATE_FAILED"), e);
            }
            finally {
                compresser.end();
            }
        }
    }

    private static final class ViewRootState {
        private final UIViewRoot _viewRoot;
        private final Object _viewRootState;

        public ViewRootState(FacesContext context, UIViewRoot viewRoot) {
            if (viewRoot == null) {
                throw new NullPointerException();
            }
            this._viewRoot = viewRoot;
            this._viewRootState = viewRoot.saveState(context);
        }

        public UIViewRoot getViewRoot() {
            return this._viewRoot;
        }

        public Object getViewRootState() {
            return this._viewRootState;
        }
    }
}

