/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command.branch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.branch.AbstractBranchCommand;
import org.apache.maven.scm.command.branch.BranchScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.jgit.command.CustomizableSshSessionFactoryCommand;
import org.apache.maven.scm.provider.git.jgit.command.JGitTransportConfigCallback;
import org.apache.maven.scm.provider.git.jgit.command.JGitUtils;
import org.apache.maven.scm.provider.git.jgit.command.PushException;
import org.apache.maven.scm.provider.git.jgit.command.ScmProviderAwareSshdSessionFactory;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.slf4j.Logger;

public class JGitBranchCommand
extends AbstractBranchCommand
implements GitCommand,
CustomizableSshSessionFactoryCommand {
    private BiFunction<GitScmProviderRepository, Logger, ScmProviderAwareSshdSessionFactory> sshSessionFactorySupplier = ScmProviderAwareSshdSessionFactory::new;

    @Override
    public void setSshSessionFactorySupplier(BiFunction<GitScmProviderRepository, Logger, ScmProviderAwareSshdSessionFactory> sshSessionFactorySupplier) {
        this.sshSessionFactorySupplier = sshSessionFactorySupplier;
    }

    protected ScmResult executeBranchCommand(ScmProviderRepository repo, ScmFileSet fileSet, String branch, String message) throws ScmException {
        if (branch == null || branch.trim().isEmpty()) {
            throw new ScmException("branch name must be specified");
        }
        if (!fileSet.getFileList().isEmpty()) {
            throw new ScmException("This provider doesn't support branching subsets of a directory");
        }
        Git git = null;
        try {
            git = JGitUtils.openRepo(fileSet.getBasedir());
            Ref branchResult = git.branchCreate().setName(branch).call();
            this.logger.info("created [" + branchResult.getName() + "]");
            if (this.logger.isDebugEnabled()) {
                for (String branchName : JGitBranchCommand.getShortLocalBranchNames(git)) {
                    this.logger.debug("local branch available: " + branchName);
                }
            }
            if (repo.isPushChanges()) {
                this.logger.info("push branch [" + branch + "] to remote...");
                JGitTransportConfigCallback transportConfigCallback = new JGitTransportConfigCallback(this.sshSessionFactorySupplier.apply((GitScmProviderRepository)repo, this.logger));
                JGitUtils.push(git, (GitScmProviderRepository)repo, new RefSpec("refs/heads/" + branch), EnumSet.of(RemoteRefUpdate.Status.OK, RemoteRefUpdate.Status.UP_TO_DATE), Optional.of(transportConfigCallback));
            }
            RevWalk revWalk = new RevWalk(git.getRepository());
            RevCommit commit = revWalk.parseCommit((AnyObjectId)branchResult.getObjectId());
            revWalk.close();
            TreeWalk walk = new TreeWalk(git.getRepository());
            walk.reset();
            walk.setRecursive(true);
            walk.addTree((AnyObjectId)commit.getTree());
            ArrayList<ScmFile> files = new ArrayList<ScmFile>();
            while (walk.next()) {
                files.add(new ScmFile(walk.getPathString(), ScmFileStatus.CHECKED_OUT));
            }
            walk.close();
            BranchScmResult branchScmResult = new BranchScmResult("JGit branch", files);
            return branchScmResult;
        }
        catch (PushException e) {
            this.logger.debug("Failed to push branch", (Throwable)e);
            BranchScmResult branchScmResult = new BranchScmResult("JGit branch", "Failed to push changes: " + e.getMessage(), "", false);
            return branchScmResult;
        }
        catch (IOException | GitAPIException e) {
            throw new ScmException("JGit branch failed!", e);
        }
        finally {
            JGitUtils.closeRepo(git);
        }
    }

    public static Set<String> getShortLocalBranchNames(Git git) throws GitAPIException {
        HashSet<String> branches = new HashSet<String>();
        Iterator iter = git.branchList().call().iterator();
        while (iter.hasNext()) {
            branches.add(Repository.shortenRefName((String)((Ref)iter.next()).getName()));
        }
        return branches;
    }
}

