/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer.internal;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class DefaultEnforcementRuleHelper
implements EnforcerRuleHelper {
    private Log log;
    private ExpressionEvaluator evaluator;
    private PlexusContainer container;
    private Map<String, Object> cache;

    public DefaultEnforcementRuleHelper(MavenSession session, ExpressionEvaluator evaluator, Log log, PlexusContainer container) {
        this.evaluator = evaluator;
        this.log = log;
        this.container = container != null ? container : session.getContainer();
        this.cache = new HashMap<String, Object>();
    }

    public Log getLog() {
        return this.log;
    }

    public File alignToBaseDirectory(File file) {
        return this.evaluator.alignToBaseDirectory(file);
    }

    public Object evaluate(String expression) throws ExpressionEvaluationException {
        return this.evaluator.evaluate(expression);
    }

    public <T> T getComponent(Class<T> clazz) throws ComponentLookupException {
        return (T)this.container.lookup(clazz);
    }

    public Object getComponent(String componentKey) throws ComponentLookupException {
        return this.container.lookup(componentKey);
    }

    public Object getComponent(String role, String roleHint) throws ComponentLookupException {
        return this.container.lookup(role, roleHint);
    }

    public List<Object> getComponentList(String role) throws ComponentLookupException {
        return this.container.lookupList(role);
    }

    public Map<String, Object> getComponentMap(String role) throws ComponentLookupException {
        return this.container.lookupMap(role);
    }

    public <T> T getComponent(Class<T> clazz, String roleHint) throws ComponentLookupException {
        return (T)this.container.lookup(clazz, roleHint);
    }

    public PlexusContainer getContainer() {
        return this.container;
    }

    public Object getCache(String key, Supplier<?> producer) {
        return this.cache.computeIfAbsent(key, x -> producer.get());
    }
}

