/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.enforcer.DefaultEnforcementRuleHelper;
import org.apache.maven.plugins.enforcer.EnforcerExpressionEvaluator;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.path.PathTranslator;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

@Mojo(name="enforce", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true, requiresDependencyCollection=ResolutionScope.TEST)
public class EnforceMojo
extends AbstractMojo
implements Contextualizable {
    @Component(role=PathTranslator.class)
    protected PathTranslator translator;
    @Component
    protected MavenSession session;
    @Component
    protected MavenProject project;
    @Parameter(property="enforcer.fail", defaultValue="true")
    protected boolean fail = true;
    @Parameter(property="enforcer.skip", defaultValue="false")
    protected boolean skip = false;
    @Parameter(property="enforcer.failFast", defaultValue="false")
    protected boolean failFast = false;
    @Parameter(required=true)
    private EnforcerRule[] rules;
    @Parameter(property="enforcer.ignoreCache", defaultValue="false")
    protected boolean ignoreCache = false;
    protected static Hashtable<String, EnforcerRule> cache = new Hashtable();
    protected PlexusContainer container;

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        EnforcerExpressionEvaluator evaluator = new EnforcerExpressionEvaluator(this.session, this.translator, this.project);
        if (!this.skip) {
            ArrayList<String> list = new ArrayList<String>();
            if (this.rules == null || this.rules.length <= 0) throw new MojoExecutionException("No rules are configured. Use the skip flag if you want to disable execution.");
            String currentRule = "Unknown";
            DefaultEnforcementRuleHelper helper = new DefaultEnforcementRuleHelper(this.session, (ExpressionEvaluator)evaluator, log, this.container);
            if (!this.fail) {
                this.failFast = false;
            }
            for (int i = 0; i < this.rules.length; ++i) {
                EnforcerRule rule = this.rules[i];
                if (rule == null) continue;
                currentRule = rule.getClass().getName();
                log.debug((CharSequence)("Executing rule: " + currentRule));
                try {
                    if (!this.ignoreCache && !this.shouldExecute(rule)) continue;
                    EnforcerRule enforcerRule = rule;
                    synchronized (enforcerRule) {
                        rule.execute((EnforcerRuleHelper)helper);
                        continue;
                    }
                }
                catch (EnforcerRuleException e) {
                    if (this.failFast) {
                        throw new MojoExecutionException(currentRule + " failed with message:\n" + e.getMessage(), (Exception)((Object)e));
                    }
                    list.add("Rule " + i + ": " + currentRule + " failed with message:\n" + e.getMessage());
                    log.debug((CharSequence)"Adding failure due to exception", (Throwable)e);
                }
            }
            if (list.isEmpty()) return;
            for (String failure : list) {
                log.warn((CharSequence)failure);
            }
            if (!this.fail) return;
            throw new MojoExecutionException("Some Enforcer rules have failed. Look above for specific messages explaining why the rule failed.");
        }
        log.info((CharSequence)"Skipping Rule Enforcement.");
    }

    protected boolean shouldExecute(EnforcerRule rule) {
        if (rule.isCacheable()) {
            Log log = this.getLog();
            log.debug((CharSequence)("Rule " + rule.getClass().getName() + " is cacheable."));
            String key = rule.getClass().getName() + " " + rule.getCacheId();
            if (cache.containsKey(key)) {
                log.debug((CharSequence)("Key " + key + " was found in the cache"));
                if (rule.isResultValid(cache.get(key))) {
                    log.debug((CharSequence)("The cached results are still valid. Skipping the rule: " + rule.getClass().getName()));
                    return false;
                }
            }
            cache.put(key, rule);
        }
        return true;
    }

    public boolean isFail() {
        return this.fail;
    }

    public void setFail(boolean theFail) {
        this.fail = theFail;
    }

    public EnforcerRule[] getRules() {
        return this.rules;
    }

    public void setRules(EnforcerRule[] theRules) {
        this.rules = theRules;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean theSkip) {
        this.skip = theSkip;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean theFailFast) {
        this.failFast = theFailFast;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject theProject) {
        this.project = theProject;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public void setSession(MavenSession theSession) {
        this.session = theSession;
    }

    public PathTranslator getTranslator() {
        return this.translator;
    }

    public void setTranslator(PathTranslator theTranslator) {
        this.translator = theTranslator;
    }
}

