/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ejb;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.XmlStreamReader;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="ejb", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true, defaultPhase=LifecyclePhase.PACKAGE)
public class EjbMojo
extends AbstractMojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private static final String[] DEFAULT_CLIENT_EXCLUDES = new String[]{"**/*Bean.class", "**/*CMP.class", "**/*Session.class", "**/package.html"};
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    private File basedir;
    @Parameter(property="outputDirectory", defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(property="jarName", defaultValue="${project.build.finalName}")
    private String jarName;
    @Parameter(property="ejb.classifier")
    private String classifier;
    @Parameter(property="ejb.ejbJar", defaultValue="META-INF/ejb-jar.xml")
    private String ejbJar = "META-INF/ejb-jar.xml";
    @Parameter(property="ejb.generateClient", defaultValue="false")
    private boolean generateClient;
    @Parameter
    private List<String> clientExcludes;
    @Parameter
    private List<String> clientIncludes;
    @Parameter
    private List<String> excludes;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Parameter(property="ejb.ejbVersion", defaultValue="2.1")
    private String ejbVersion;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver clientJarArchiver;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(property="ejb.escapeBackslashesInFilePath", defaultValue="false")
    private boolean escapeBackslashesInFilePath;
    @Parameter(property="ejb.escapeString")
    protected String escapeString;
    @Parameter(property="ejb.filterDeploymentDescriptor", defaultValue="false")
    private boolean filterDeploymentDescriptor;
    @Parameter
    private List filters;
    @Component(role=MavenFileFilter.class, hint="default")
    private MavenFileFilter mavenFileFilter;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;

    public void execute() throws MojoExecutionException {
        if (!this.outputDirectory.exists()) {
            this.getLog().warn((CharSequence)("The created EJB jar will be empty cause the " + this.outputDirectory.getPath() + " did not exist."));
            this.outputDirectory.mkdirs();
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Building EJB " + this.jarName + " with EJB version " + this.ejbVersion));
        }
        File jarFile = EjbMojo.getEJBJarFile(this.basedir, this.jarName, this.classifier);
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(jarFile);
        File deploymentDescriptor = new File(this.outputDirectory, this.ejbJar);
        if (!this.ejbVersion.matches("\\A[2-3]\\.[0-9]\\z")) {
            throw new MojoExecutionException("ejbVersion is not valid: " + this.ejbVersion + ". Must be 2.x or 3.x (where x is a digit)");
        }
        if (this.ejbVersion.matches("\\A2\\.[0-9]\\z") && !deploymentDescriptor.exists()) {
            throw new MojoExecutionException("Error assembling EJB: " + this.ejbJar + " is required for ejbVersion 2.x");
        }
        try {
            String[] mainJarExcludes = new String[]{this.ejbJar, "**/package.html"};
            if (this.excludes != null && !this.excludes.isEmpty()) {
                this.excludes.add(this.ejbJar);
                mainJarExcludes = this.excludes.toArray(new String[this.excludes.size()]);
            }
            archiver.getArchiver().addDirectory(this.outputDirectory, DEFAULT_INCLUDES, mainJarExcludes);
            if (deploymentDescriptor.exists()) {
                if (this.filterDeploymentDescriptor) {
                    this.getLog().debug((CharSequence)"Filtering deployment descriptor.");
                    MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution();
                    mavenResourcesExecution.setEscapeString(this.escapeString);
                    List filterWrappers = this.mavenFileFilter.getDefaultFilterWrappers(this.project, this.filters, this.escapeBackslashesInFilePath, this.session, mavenResourcesExecution);
                    File unfilteredDeploymentDescriptor = new File(this.outputDirectory, this.ejbJar + ".unfiltered");
                    FileUtils.copyFile((File)deploymentDescriptor, (File)unfilteredDeploymentDescriptor);
                    this.mavenFileFilter.copyFile(unfilteredDeploymentDescriptor, deploymentDescriptor, true, filterWrappers, this.getEncoding(unfilteredDeploymentDescriptor));
                    FileUtils.forceDelete((File)unfilteredDeploymentDescriptor);
                }
                archiver.getArchiver().addFile(deploymentDescriptor, this.ejbJar);
            }
            archiver.createArchive(this.session, this.project, this.archive);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("There was a problem creating the EJB archive: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ManifestException e) {
            throw new MojoExecutionException("There was a problem creating the EJB archive: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("There was a problem creating the EJB archive: " + e.getMessage(), (Exception)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("There was a problem creating the EJB archive: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException("There was a problem filtering the deployment descriptor: " + e.getMessage(), (Exception)((Object)e));
        }
        if (this.classifier != null) {
            this.projectHelper.attachArtifact(this.project, "ejb", this.classifier, jarFile);
        } else {
            this.project.getArtifact().setFile(jarFile);
        }
        if (this.generateClient) {
            String clientJarName = this.jarName;
            if (this.classifier != null) {
                clientJarName = clientJarName + "-" + this.classifier;
            }
            this.getLog().info((CharSequence)("Building EJB client " + clientJarName + "-client"));
            String[] excludes = DEFAULT_CLIENT_EXCLUDES;
            String[] includes = DEFAULT_INCLUDES;
            if (this.clientIncludes != null && !this.clientIncludes.isEmpty()) {
                includes = this.clientIncludes.toArray(new String[this.clientIncludes.size()]);
            }
            if (this.clientExcludes != null && !this.clientExcludes.isEmpty()) {
                excludes = this.clientExcludes.toArray(new String[this.clientExcludes.size()]);
            }
            File clientJarFile = new File(this.basedir, clientJarName + "-client.jar");
            MavenArchiver clientArchiver = new MavenArchiver();
            clientArchiver.setArchiver(this.clientJarArchiver);
            clientArchiver.setOutputFile(clientJarFile);
            try {
                clientArchiver.getArchiver().addDirectory(this.outputDirectory, includes, excludes);
                clientArchiver.createArchive(this.session, this.project, this.archive);
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("There was a problem creating the EJB client archive: " + e.getMessage(), (Exception)((Object)e));
            }
            catch (ManifestException e) {
                throw new MojoExecutionException("There was a problem creating the EJB client archive: " + e.getMessage(), (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("There was a problem creating the EJB client archive: " + e.getMessage(), (Exception)e);
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException("There was a problem creating the EJB client archive: " + e.getMessage(), (Exception)((Object)e));
            }
            if (this.classifier != null) {
                this.projectHelper.attachArtifact(this.project, "ejb-client", this.classifier + "-client", clientJarFile);
            } else {
                this.projectHelper.attachArtifact(this.project, "ejb-client", "client", clientJarFile);
            }
        }
    }

    private static File getEJBJarFile(File basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + ".jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEncoding(File xmlFile) throws IOException {
        String string;
        XmlStreamReader xmlReader = null;
        try {
            xmlReader = new XmlStreamReader(xmlFile);
            string = xmlReader.getEncoding();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(xmlReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)xmlReader);
        return string;
    }
}

