/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.EclipseUtils;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractWtpResourceWriter;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class EclipseWtpComponentWriter
extends AbstractWtpResourceWriter {
    private static final String ATTR_CONTEXT_ROOT = "context-root";
    private static final String DIR_WTP_SETTINGS = ".settings";
    private static final String FILE_DOT_COMPONENT = ".component";

    public EclipseWtpComponentWriter(Log log, File eclipseProjectDir, MavenProject project, Collection artifacts) {
        super(log, eclipseProjectDir, project, artifacts);
    }

    public void write(List referencedReactorArtifacts, EclipseSourceDir[] sourceDirs, ArtifactRepository localRepository, File buildOutputDirectory) throws MojoExecutionException {
        FileWriter w;
        File settingsDir = new File(this.getEclipseProjectDirectory(), DIR_WTP_SETTINGS);
        settingsDir.mkdirs();
        try {
            w = new FileWriter(new File(settingsDir, FILE_DOT_COMPONENT));
        }
        catch (IOException ex) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.erroropeningfile"), (Exception)ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w);
        String packaging = this.getProject().getPackaging();
        this.writeModuleTypeComponent((XMLWriter)writer, packaging, buildOutputDirectory, sourceDirs, referencedReactorArtifacts, localRepository);
        IOUtil.close((Writer)w);
    }

    private void writeModuleTypeComponent(XMLWriter writer, String packaging, File buildOutputDirectory, EclipseSourceDir[] sourceDirs, List referencedReactorArtifacts, ArtifactRepository localRepository) throws MojoExecutionException {
        writer.startElement("project-modules");
        writer.addAttribute("id", "moduleCoreId");
        writer.startElement("wb-module");
        writer.addAttribute("deploy-name", this.getProject().getArtifactId());
        String target = "/";
        if ("war".equalsIgnoreCase(packaging)) {
            target = "/WEB-INF/classes";
            String warSourceDirectory = EclipseUtils.getPluginSetting(this.getProject(), "maven-war-plugin", "warSourceDirectory", "/src/main/webapp");
            writer.startElement("property");
            writer.addAttribute(ATTR_CONTEXT_ROOT, this.getProject().getArtifactId());
            writer.endElement();
            writer.startElement("wb-resource");
            writer.addAttribute("deploy-path", "/");
            writer.addAttribute("source-path", EclipseUtils.toRelativeAndFixSeparator(this.getProject().getBasedir(), new File(this.getEclipseProjectDirectory(), warSourceDirectory), false));
            writer.endElement();
            writer.startElement("property");
            writer.addAttribute("name", "java-output-path");
            writer.addAttribute("value", "/" + EclipseUtils.toRelativeAndFixSeparator(this.getProject().getBasedir(), buildOutputDirectory, false));
            writer.endElement();
        } else if ("ear".equalsIgnoreCase(packaging)) {
            writer.startElement("wb-resource");
            writer.addAttribute("deploy-path", "/");
            writer.addAttribute("source-path", "/");
            writer.endElement();
        }
        if ("war".equalsIgnoreCase(packaging) || "ear".equalsIgnoreCase(packaging)) {
            this.writeWarOrEarResources(writer, this.getProject(), referencedReactorArtifacts, localRepository);
        }
        for (int j = 0; j < sourceDirs.length; ++j) {
            EclipseSourceDir dir = sourceDirs[j];
            if (dir.isTest()) continue;
            writer.startElement("wb-resource");
            writer.addAttribute("deploy-path", target);
            writer.addAttribute("source-path", dir.getPath());
            writer.endElement();
        }
        writer.endElement();
        writer.endElement();
    }
}

