/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseUtils;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseResourceWriter;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class EclipseSettingsWriter
extends AbstractEclipseResourceWriter {
    private static final String PROPERTY_TARGET = "target";
    private static final String PROPERTY_SOURCE = "source";
    private static final String JDK_1_2_SOURCES = "1.2";
    private static final String FILE_ECLIPSE_JDT_CORE_PREFS = "org.eclipse.jdt.core.prefs";
    private static final String PROP_ECLIPSE_PREFERENCES_VERSION = "eclipse.preferences.version";
    private static final String DIR_DOT_SETTINGS = ".settings";
    private static final String PROP_JDT_CORE_COMPILER_COMPLIANCE = "org.eclipse.jdt.core.compiler.compliance";
    private static final String PROP_JDT_CORE_COMPILER_SOURCE = "org.eclipse.jdt.core.compiler.source";
    private static final String ARTIFACT_MAVEN_COMPILER_PLUGIN = "maven-compiler-plugin";

    public EclipseSettingsWriter(Log log, File eclipseProjectDir, MavenProject project) {
        super(log, eclipseProjectDir, project);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write() throws MojoExecutionException {
        Properties coreSettings = new Properties();
        String source = EclipseUtils.getPluginSetting(this.getProject(), ARTIFACT_MAVEN_COMPILER_PLUGIN, PROPERTY_SOURCE, null);
        String target = EclipseUtils.getPluginSetting(this.getProject(), ARTIFACT_MAVEN_COMPILER_PLUGIN, PROPERTY_TARGET, null);
        if (source != null) {
            ((Hashtable)coreSettings).put(PROP_JDT_CORE_COMPILER_SOURCE, source);
            ((Hashtable)coreSettings).put(PROP_JDT_CORE_COMPILER_COMPLIANCE, source);
        }
        if (target != null && !JDK_1_2_SOURCES.equals(target)) {
            ((Hashtable)coreSettings).put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", target);
        }
        if (!((Hashtable)coreSettings).isEmpty()) {
            File settingsDir = new File(this.getEclipseProjectDirectory(), DIR_DOT_SETTINGS);
            settingsDir.mkdirs();
            ((Hashtable)coreSettings).put(PROP_ECLIPSE_PREFERENCES_VERSION, "1");
            try {
                File coreSettingsFile = new File(settingsDir, FILE_ECLIPSE_JDT_CORE_PREFS);
                if (coreSettingsFile.exists()) {
                    File oldCoreSettingsFile = coreSettingsFile;
                    Properties oldsettings = new Properties();
                    oldsettings.load(new FileInputStream(oldCoreSettingsFile));
                    Properties newsettings = (Properties)((Hashtable)oldsettings).clone();
                    ((Hashtable)newsettings).putAll(coreSettings);
                    if (((Hashtable)oldsettings).equals(newsettings)) return;
                    newsettings.store(new FileOutputStream(coreSettingsFile), null);
                    return;
                }
                coreSettings.store(new FileOutputStream(coreSettingsFile), null);
                this.getLog().info((CharSequence)Messages.getString("EclipseSettingsWriter.wrotesettings", coreSettingsFile.getCanonicalPath()));
                return;
            }
            catch (FileNotFoundException e) {
                throw new MojoExecutionException(Messages.getString("EclipseSettingsWriter.cannotcreatesettings"), (Exception)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException(Messages.getString("EclipseSettingsWriter.errorwritingsettings"), (Exception)e);
            }
        } else {
            this.getLog().info((CharSequence)Messages.getString("EclipseSettingsWriter.usingdefaults"));
        }
    }
}

