/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseUtils;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseResourceWriter;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class EclipseProjectWriter
extends AbstractEclipseResourceWriter {
    private static final String ELT_NAME = "name";
    private static final String ELT_BUILD_COMMAND = "buildCommand";
    private static final String ELT_BUILD_SPEC = "buildSpec";
    private static final String ELT_NATURE = "nature";
    private static final String ELT_NATURES = "natures";
    private static final String FILE_DOT_PROJECT = ".project";

    public EclipseProjectWriter(Log log, File eclipseProjectDir, MavenProject project) {
        super(log, eclipseProjectDir, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void write(File projectBaseDir, MavenProject executedProject, List reactorArtifacts, List addedProjectnatures, List addedBuildCommands) throws MojoExecutionException {
        Iterator it;
        FileWriter w;
        LinkedHashSet<String> projectnatures = new LinkedHashSet<String>();
        LinkedHashSet<String> buildCommands = new LinkedHashSet<String>();
        File dotProject = new File(this.getEclipseProjectDirectory(), FILE_DOT_PROJECT);
        if (dotProject.exists()) {
            FileReader reader;
            block20: {
                this.getLog().info((CharSequence)Messages.getString("EclipsePlugin.keepexisting", dotProject.getAbsolutePath()));
                reader = null;
                try {
                    Xpp3Dom buildSpec;
                    reader = new FileReader(dotProject);
                    Xpp3Dom dom = Xpp3DomBuilder.build((Reader)reader);
                    Xpp3Dom naturesElement = dom.getChild(ELT_NATURES);
                    if (naturesElement != null) {
                        Xpp3Dom[] existingNatures = naturesElement.getChildren(ELT_NATURE);
                        for (int j = 0; j < existingNatures.length; ++j) {
                            projectnatures.add(existingNatures[j].getValue());
                        }
                    }
                    if ((buildSpec = dom.getChild(ELT_BUILD_SPEC)) == null) break block20;
                    Xpp3Dom[] existingBuildCommands = buildSpec.getChildren(ELT_BUILD_COMMAND);
                    for (int j = 0; j < existingBuildCommands.length; ++j) {
                        Xpp3Dom buildCommandName = existingBuildCommands[j].getChild(ELT_NAME);
                        if (buildCommandName == null) continue;
                        buildCommands.add(buildCommandName.getValue());
                    }
                }
                catch (XmlPullParserException e) {
                    this.getLog().warn((CharSequence)Messages.getString("EclipsePlugin.cantparseexisting", dotProject.getAbsolutePath()));
                    IOUtil.close((Reader)reader);
                }
                catch (IOException e2) {
                    this.getLog().warn((CharSequence)Messages.getString("EclipsePlugin.cantparseexisting", dotProject.getAbsolutePath()));
                    {
                        catch (Throwable throwable) {
                            IOUtil.close(reader);
                            throw throwable;
                        }
                    }
                    IOUtil.close((Reader)reader);
                }
            }
            IOUtil.close((Reader)reader);
        }
        Iterator iter = addedProjectnatures.iterator();
        while (iter.hasNext()) {
            projectnatures.add((String)iter.next());
        }
        iter = addedBuildCommands.iterator();
        while (iter.hasNext()) {
            buildCommands.add((String)iter.next());
        }
        try {
            w = new FileWriter(dotProject);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.erroropeningfile"), (Exception)ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w);
        writer.startElement("projectDescription");
        writer.startElement(ELT_NAME);
        writer.writeText(this.getProject().getArtifactId());
        writer.endElement();
        writer.startElement("comment");
        if (this.getProject().getDescription() != null) {
            writer.writeText(this.getProject().getDescription());
        }
        writer.endElement();
        writer.startElement("projects");
        if (reactorArtifacts != null && !reactorArtifacts.isEmpty()) {
            it = reactorArtifacts.iterator();
            while (it.hasNext()) {
                writer.startElement("project");
                writer.writeText(((Artifact)it.next()).getArtifactId());
                writer.endElement();
            }
        }
        writer.endElement();
        writer.startElement(ELT_BUILD_SPEC);
        it = buildCommands.iterator();
        while (it.hasNext()) {
            writer.startElement(ELT_BUILD_COMMAND);
            writer.startElement(ELT_NAME);
            writer.writeText((String)it.next());
            writer.endElement();
            writer.startElement("arguments");
            writer.endElement();
            writer.endElement();
        }
        writer.endElement();
        writer.startElement(ELT_NATURES);
        it = projectnatures.iterator();
        while (it.hasNext()) {
            writer.startElement(ELT_NATURE);
            writer.writeText((String)it.next());
            writer.endElement();
        }
        writer.endElement();
        if (!projectBaseDir.equals(this.getEclipseProjectDirectory())) {
            writer.startElement("linkedResources");
            this.addFileLink((XMLWriter)writer, projectBaseDir, this.getEclipseProjectDirectory(), this.getProject().getFile());
            this.addSourceLinks((XMLWriter)writer, projectBaseDir, this.getEclipseProjectDirectory(), executedProject.getCompileSourceRoots());
            this.addResourceLinks((XMLWriter)writer, projectBaseDir, this.getEclipseProjectDirectory(), executedProject.getBuild().getResources());
            this.addSourceLinks((XMLWriter)writer, projectBaseDir, this.getEclipseProjectDirectory(), executedProject.getTestCompileSourceRoots());
            this.addResourceLinks((XMLWriter)writer, projectBaseDir, this.getEclipseProjectDirectory(), executedProject.getBuild().getTestResources());
            writer.endElement();
        }
        writer.endElement();
        IOUtil.close((Writer)w);
    }

    private void addFileLink(XMLWriter writer, File projectBaseDir, File basedir, File file) throws MojoExecutionException {
        if (file.isFile()) {
            writer.startElement("link");
            writer.startElement(ELT_NAME);
            writer.writeText(EclipseUtils.toRelativeAndFixSeparator(projectBaseDir, file, true));
            writer.endElement();
            writer.startElement("type");
            writer.writeText("1");
            writer.endElement();
            writer.startElement("location");
            try {
                writer.writeText(file.getCanonicalPath().replaceAll("\\\\", "/"));
            }
            catch (IOException e) {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantcanonicalize", file.getAbsolutePath()), (Exception)e);
            }
            writer.endElement();
            writer.endElement();
        } else {
            this.getLog().warn((CharSequence)Messages.getString("EclipseProjectWriter.notafile", file));
        }
    }

    private void addSourceLinks(XMLWriter writer, File projectBaseDir, File basedir, List sourceRoots) throws MojoExecutionException {
        Iterator it = sourceRoots.iterator();
        while (it.hasNext()) {
            String sourceRootString = (String)it.next();
            File sourceRoot = new File(sourceRootString);
            if (!sourceRoot.isDirectory()) continue;
            writer.startElement("link");
            writer.startElement(ELT_NAME);
            writer.writeText(EclipseUtils.toRelativeAndFixSeparator(projectBaseDir, sourceRoot, true));
            writer.endElement();
            writer.startElement("type");
            writer.writeText("2");
            writer.endElement();
            writer.startElement("location");
            try {
                writer.writeText(sourceRoot.getCanonicalPath().replaceAll("\\\\", "/"));
            }
            catch (IOException e) {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantcanonicalize", sourceRoot.getAbsolutePath()), (Exception)e);
            }
            writer.endElement();
            writer.endElement();
        }
    }

    private void addResourceLinks(XMLWriter writer, File projectBaseDir, File basedir, List sourceRoots) throws MojoExecutionException {
        Iterator it = sourceRoots.iterator();
        while (it.hasNext()) {
            String resourceDirString = ((Resource)it.next()).getDirectory();
            File resourceDir = new File(resourceDirString);
            if (!resourceDir.isDirectory()) continue;
            writer.startElement("link");
            writer.startElement(ELT_NAME);
            writer.writeText(EclipseUtils.toRelativeAndFixSeparator(projectBaseDir, resourceDir, true));
            writer.endElement();
            writer.startElement("type");
            writer.writeText("2");
            writer.endElement();
            writer.startElement("location");
            try {
                writer.writeText(resourceDir.getCanonicalPath().replaceAll("\\\\", "/"));
            }
            catch (IOException e) {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantcanonicalize", resourceDir.getAbsolutePath()), (Exception)e);
            }
            writer.endElement();
            writer.endElement();
        }
    }
}

