/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class EclipseUtils {
    private EclipseUtils() {
    }

    public static String toRelativeAndFixSeparator(File basedir, File fileToAdd, boolean replaceSlashesWithDashes) throws MojoExecutionException {
        String absolutePath;
        String basedirpath;
        try {
            basedirpath = basedir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantcanonicalize", basedir.getAbsolutePath()), (Exception)e);
        }
        try {
            absolutePath = fileToAdd.getCanonicalPath();
        }
        catch (IOException e) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantcanonicalize", fileToAdd.getAbsolutePath()), (Exception)e);
        }
        String relative = absolutePath.equals(basedirpath) ? "." : (absolutePath.startsWith(basedirpath) ? absolutePath.substring(basedirpath.length() + 1) : absolutePath);
        relative = StringUtils.replace((String)relative, (String)"\\", (String)"/");
        if (replaceSlashesWithDashes) {
            relative = StringUtils.replace((String)relative, (String)"/", (String)"-");
        }
        return relative;
    }

    public static String getPluginSetting(MavenProject project, String artifactId, String optionName, String defaultValue) {
        Iterator it = project.getModel().getBuild().getPlugins().iterator();
        while (it.hasNext()) {
            Xpp3Dom o;
            Plugin plugin = (Plugin)it.next();
            if (!plugin.getArtifactId().equals(artifactId) || (o = (Xpp3Dom)plugin.getConfiguration()) == null || o.getChild(optionName) == null) continue;
            return o.getChild(optionName).getValue();
        }
        return defaultValue;
    }

    public static EclipseSourceDir[] buildDirectoryList(MavenProject project, File basedir, Log log, File buildOutputDirectory) throws MojoExecutionException {
        boolean useFixedOutputDir;
        File projectBaseDir = project.getFile().getParentFile();
        TreeSet directories = new TreeSet();
        EclipseUtils.extractSourceDirs(directories, project.getCompileSourceRoots(), basedir, projectBaseDir, false, null);
        EclipseUtils.extractResourceDirs(directories, project.getBuild().getResources(), project, basedir, projectBaseDir, false, null, log);
        String testOutput = null;
        boolean bl = useFixedOutputDir = !buildOutputDirectory.equals(new File(project.getBuild().getOutputDirectory()));
        if (!useFixedOutputDir) {
            testOutput = EclipseUtils.toRelativeAndFixSeparator(projectBaseDir, new File(project.getBuild().getTestOutputDirectory()), false);
        }
        EclipseUtils.extractSourceDirs(directories, project.getTestCompileSourceRoots(), basedir, projectBaseDir, true, testOutput);
        EclipseUtils.extractResourceDirs(directories, project.getBuild().getTestResources(), project, basedir, projectBaseDir, true, testOutput, log);
        return directories.toArray(new EclipseSourceDir[directories.size()]);
    }

    private static void extractSourceDirs(Set directories, List sourceRoots, File basedir, File projectBaseDir, boolean test, String output) throws MojoExecutionException {
        Iterator it = sourceRoots.iterator();
        while (it.hasNext()) {
            File sourceRootFile = new File((String)it.next());
            if (!sourceRootFile.isDirectory()) continue;
            String sourceRoot = EclipseUtils.toRelativeAndFixSeparator(projectBaseDir, sourceRootFile, !projectBaseDir.equals(basedir));
            directories.add(new EclipseSourceDir(sourceRoot, output, test, null, null));
        }
    }

    private static void extractResourceDirs(Set directories, List resources, MavenProject project, File basedir, File projectBaseDir, boolean test, String output, Log log) throws MojoExecutionException {
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            File resourceDirectory;
            Resource resource = (Resource)it.next();
            String includePattern = null;
            String excludePattern = null;
            if (resource.getIncludes().size() != 0) {
                log.warn((CharSequence)Messages.getString("EclipsePlugin.includenotsupported"));
            }
            if (resource.getExcludes().size() != 0) {
                log.warn((CharSequence)Messages.getString("EclipsePlugin.excludenotsupported"));
            }
            if (!StringUtils.isEmpty((String)resource.getTargetPath())) {
                output = resource.getTargetPath();
            }
            if (!(resourceDirectory = new File(resource.getDirectory())).exists() || !resourceDirectory.isDirectory()) continue;
            String resourceDir = EclipseUtils.toRelativeAndFixSeparator(projectBaseDir, resourceDirectory, !projectBaseDir.equals(basedir));
            if (output != null) {
                File outputFile = new File(projectBaseDir, output);
                outputFile.mkdirs();
                output = EclipseUtils.toRelativeAndFixSeparator(projectBaseDir, outputFile, false);
            }
            directories.add(new EclipseSourceDir(resourceDir, output, test, includePattern, excludePattern));
        }
    }

    public static MavenProject findReactorProject(List reactorProjects, Artifact artifact) {
        if (reactorProjects == null) {
            return null;
        }
        Iterator it = reactorProjects.iterator();
        while (it.hasNext()) {
            MavenProject project = (MavenProject)it.next();
            if (!project.getGroupId().equals(artifact.getGroupId()) || !project.getArtifactId().equals(artifact.getArtifactId()) || !project.getVersion().equals(artifact.getVersion())) continue;
            return project;
        }
        return null;
    }

    public static List resolveReactorArtifacts(MavenProject project, List reactorProjects) {
        ArrayList<Artifact> referencedProjects = new ArrayList<Artifact>();
        Set artifacts = project.getArtifacts();
        Iterator it = artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            MavenProject refProject = EclipseUtils.findReactorProject(reactorProjects, artifact);
            if (refProject == null) continue;
            referencedProjects.add(artifact);
        }
        return referencedProjects;
    }

    public static void fixSystemScopeArtifacts(Collection artifacts, Collection dependencies) {
        Iterator iter = artifacts.iterator();
        block0: while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (!"system".equals(artifact.getScope())) continue;
            String groupid = artifact.getGroupId();
            String artifactId = artifact.getArtifactId();
            Iterator depIt = dependencies.iterator();
            while (depIt.hasNext()) {
                Dependency dep = (Dependency)depIt.next();
                if (!"system".equals(dep.getScope()) || !groupid.equals(dep.getGroupId()) || !artifactId.equals(dep.getArtifactId())) continue;
                artifact.setFile(new File(dep.getSystemPath()));
                continue block0;
            }
        }
    }

    public static void fixMissingOptionalArtifacts(Collection artifacts, Collection depArtifacts, ArtifactRepository localRepository, ArtifactResolver artifactResolver, List remoteArtifactRepositories, Log log) {
        Iterator it = depArtifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            if (!artifact.isOptional() || artifacts.contains(artifact)) continue;
            try {
                artifactResolver.resolve(artifact, remoteArtifactRepositories, localRepository);
            }
            catch (ArtifactResolutionException e) {
                log.error((CharSequence)Messages.getString("EclipsePlugin.errorresolving", new Object[]{artifact.getType(), artifact.getId(), e.getMessage()}));
                continue;
            }
            catch (ArtifactNotFoundException e) {
                log.error((CharSequence)Messages.getString("EclipsePlugin.errorresolving", new Object[]{artifact.getType(), artifact.getId(), e.getMessage()}));
                continue;
            }
            artifacts.add(artifact);
        }
    }

    public static Artifact resolveLocalSourceArtifact(Artifact artifact, ArtifactRepository localRepository, ArtifactResolver artifactResolver, ArtifactFactory artifactFactory) throws MojoExecutionException {
        return EclipseUtils.resolveArtifactWithClassifier(artifact, "sources", localRepository, artifactResolver, artifactFactory, new ArrayList(0));
    }

    public static Artifact resolveLocalJavadocArtifact(Artifact artifact, ArtifactRepository localRepository, ArtifactResolver artifactResolver, ArtifactFactory artifactFactory) throws MojoExecutionException {
        return EclipseUtils.resolveArtifactWithClassifier(artifact, "javadoc", localRepository, artifactResolver, artifactFactory, new ArrayList(0));
    }

    public static Artifact resolveArtifactWithClassifier(Artifact artifact, String classifier, ArtifactRepository localRepository, ArtifactResolver artifactResolver, ArtifactFactory artifactFactory, List remoteRepos) throws MojoExecutionException {
        String type = classifier;
        if ("sources".equals(type)) {
            type = "java-source";
        }
        Artifact resolvedArtifact = artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), type, classifier);
        try {
            artifactResolver.resolve(resolvedArtifact, remoteRepos, localRepository);
        }
        catch (ArtifactNotFoundException e) {
        }
        catch (ArtifactResolutionException e) {
            String message = Messages.getString("EclipsePlugin.errorresolving", new Object[]{classifier, resolvedArtifact.getId(), e.getMessage()});
            throw new MojoExecutionException(message, (Exception)((Object)e));
        }
        return resolvedArtifact;
    }

    public static String getDependencyVersion(String[] artifactNames, Set artifacts, int len) {
        Iterator itr = artifacts.iterator();
        while (itr.hasNext()) {
            Artifact artifact = (Artifact)itr.next();
            for (int j = 0; j < artifactNames.length; ++j) {
                String name = artifactNames[j];
                if (!name.equals(artifact.getArtifactId())) continue;
                return StringUtils.substring((String)artifact.getVersion(), (int)0, (int)len);
            }
        }
        return null;
    }
}

