/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.EclipseUtils;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.EclipseClasspathWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseProjectWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseSettingsWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseWtpComponentWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseWtpFacetsWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseWtpmodulesWriter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class EclipsePlugin
extends AbstractMojo {
    private static final String NATURE_WST_FACET_CORE_NATURE = "org.eclipse.wst.common.project.facet.core.nature";
    private static final String BUILDER_WST_COMPONENT_STRUCTURAL_DEPENDENCY_RESOLVER = "org.eclipse.wst.common.modulecore.ComponentStructuralBuilderDependencyResolver";
    private static final String BUILDER_WST_VALIDATION = "org.eclipse.wst.validation.validationbuilder";
    private static final String BUILDER_JDT_CORE_JAVA = "org.eclipse.jdt.core.javabuilder";
    private static final String BUILDER_WST_COMPONENT_STRUCTURAL = "org.eclipse.wst.common.modulecore.ComponentStructuralBuilder";
    private static final String NATURE_WST_MODULE_CORE_NATURE = "org.eclipse.wst.common.modulecore.ModuleCoreNature";
    private static final String NATURE_JDT_CORE_JAVA = "org.eclipse.jdt.core.javanature";
    private static final String NATURE_JEM_WORKBENCH_JAVA_EMF = "org.eclipse.jem.workbench.JavaEMFNature";
    private static final String COMMON_PATH_JDT_LAUNCHING_JRE_CONTAINER = "org.eclipse.jdt.launching.JRE_CONTAINER";
    public static final String[] WTP_SUPPORTED_VERSIONS = new String[]{"1.0", "R7", "none"};
    private static final String POM_ELT_ARTIFACT_ID = "artifactId";
    private static final String POM_ELT_GROUP_ID = "groupId";
    private MavenProject project;
    private MavenProject executedProject;
    private ArtifactRepository localRepository;
    private List reactorProjects;
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private List remoteArtifactRepositories;
    private List projectnatures;
    private List buildcommands;
    private List classpathContainers;
    private boolean downloadSources;
    private File eclipseProjectDir;
    private boolean useProjectReferences;
    private File buildOutputDirectory;
    private String wtpversion;
    private List missingSourceArtifacts = new ArrayList();
    private boolean wtpR7;
    private boolean wtp10;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (Arrays.binarySearch(WTP_SUPPORTED_VERSIONS, this.wtpversion) < 0) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.unsupportedwtp", new Object[]{this.wtpversion, StringUtils.join((Object[])WTP_SUPPORTED_VERSIONS, (String)" ")}));
        }
        if ("R7".equalsIgnoreCase(this.wtpversion)) {
            this.wtpR7 = true;
        } else if ("1.0".equalsIgnoreCase(this.wtpversion)) {
            this.wtp10 = true;
        }
        if (!"none".equalsIgnoreCase(this.wtpversion)) {
            this.getLog().info((CharSequence)Messages.getString("EclipsePlugin.wtpversion", this.wtpversion));
        }
        if (this.executedProject == null) {
            this.executedProject = this.project;
        }
        String packaging = this.executedProject.getPackaging();
        this.assertNotEmpty(this.executedProject.getGroupId(), POM_ELT_GROUP_ID);
        this.assertNotEmpty(this.executedProject.getArtifactId(), POM_ELT_ARTIFACT_ID);
        if (this.executedProject.getFile() == null || !this.executedProject.getFile().exists()) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.missingpom"));
        }
        if ("pom".equals(packaging) && this.eclipseProjectDir == null) {
            this.getLog().info((CharSequence)Messages.getString("EclipsePlugin.pompackaging"));
            return;
        }
        if (this.eclipseProjectDir == null) {
            this.eclipseProjectDir = this.executedProject.getFile().getParentFile();
        } else if (!this.eclipseProjectDir.equals(this.executedProject.getFile().getParentFile())) {
            if (!this.eclipseProjectDir.isDirectory()) {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.notadir", this.eclipseProjectDir));
            }
            this.eclipseProjectDir = new File(this.eclipseProjectDir, this.executedProject.getArtifactId());
            if (!this.eclipseProjectDir.isDirectory() && !this.eclipseProjectDir.mkdirs()) {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantcreatedir", this.eclipseProjectDir));
            }
        }
        if (this.projectnatures == null) {
            this.fillDefaultNatures(packaging);
        }
        if (this.buildcommands == null) {
            this.fillDefaultBuilders(packaging);
        }
        if (this.classpathContainers == null) {
            this.fillDefaultClasspathContainers(packaging);
        } else if (!this.classpathContainers.contains(COMMON_PATH_JDT_LAUNCHING_JRE_CONTAINER)) {
            this.getLog().warn((CharSequence)Messages.getString("EclipsePlugin.missingjrecontainer"));
            this.classpathContainers.add(0, COMMON_PATH_JDT_LAUNCHING_JRE_CONTAINER);
        }
        this.write();
    }

    public void write() throws MojoExecutionException {
        File projectBaseDir = this.executedProject.getFile().getParentFile();
        List reactorArtifacts = this.useProjectReferences ? EclipseUtils.resolveReactorArtifacts(this.project, this.reactorProjects) : Collections.EMPTY_LIST;
        EclipseSourceDir[] sourceDirs = EclipseUtils.buildDirectoryList(this.executedProject, this.eclipseProjectDir, this.getLog(), this.buildOutputDirectory);
        Collection artifacts = this.prepareArtifacts();
        this.downloadSourceArtifacts(artifacts, reactorArtifacts);
        if (this.wtpR7) {
            new EclipseWtpmodulesWriter(this.getLog(), this.eclipseProjectDir, this.project, artifacts).write(reactorArtifacts, sourceDirs, this.localRepository, this.buildOutputDirectory);
        } else if (this.wtp10) {
            new EclipseWtpFacetsWriter(this.getLog(), this.eclipseProjectDir, this.project, artifacts).write(reactorArtifacts, sourceDirs, this.localRepository, this.buildOutputDirectory);
            new EclipseWtpComponentWriter(this.getLog(), this.eclipseProjectDir, this.project, artifacts).write(reactorArtifacts, sourceDirs, this.localRepository, this.buildOutputDirectory);
        }
        new EclipseProjectWriter(this.getLog(), this.eclipseProjectDir, this.project).write(projectBaseDir, this.executedProject, reactorArtifacts, this.projectnatures, this.buildcommands);
        new EclipseSettingsWriter(this.getLog(), this.eclipseProjectDir, this.project).write();
        new EclipseClasspathWriter(this.getLog(), this.eclipseProjectDir, this.project, artifacts).write(projectBaseDir, reactorArtifacts, sourceDirs, this.classpathContainers, this.localRepository, this.artifactResolver, this.artifactFactory, this.buildOutputDirectory);
        this.reportMissingSources();
        this.getLog().info((CharSequence)Messages.getString("EclipsePlugin.wrote", new Object[]{this.project.getArtifactId(), this.eclipseProjectDir.getAbsolutePath()}));
    }

    private Collection prepareArtifacts() {
        List artifacts = this.project.getTestArtifacts();
        EclipseUtils.fixMissingOptionalArtifacts(artifacts, this.project.getDependencyArtifacts(), this.localRepository, this.artifactResolver, this.remoteArtifactRepositories, this.getLog());
        EclipseUtils.fixSystemScopeArtifacts(artifacts, this.project.getDependencies());
        return artifacts;
    }

    private void assertNotEmpty(String string, String elementName) throws MojoFailureException {
        if (string == null) {
            throw new MojoFailureException(Messages.getString("EclipsePlugin.missingelement", elementName));
        }
    }

    private void fillDefaultNatures(String packaging) {
        this.projectnatures = new ArrayList();
        if (this.wtp10) {
            this.projectnatures.add(NATURE_WST_FACET_CORE_NATURE);
        }
        this.projectnatures.add(NATURE_JDT_CORE_JAVA);
        if (this.wtpR7 || this.wtp10) {
            this.projectnatures.add(NATURE_WST_MODULE_CORE_NATURE);
            this.projectnatures.add(NATURE_JEM_WORKBENCH_JAVA_EMF);
        }
    }

    private void fillDefaultClasspathContainers(String packaging) {
        this.classpathContainers = new ArrayList();
        this.classpathContainers.add(COMMON_PATH_JDT_LAUNCHING_JRE_CONTAINER);
    }

    private void fillDefaultBuilders(String packaging) {
        this.buildcommands = new ArrayList();
        if (this.wtpR7) {
            this.buildcommands.add(BUILDER_WST_COMPONENT_STRUCTURAL);
        }
        this.buildcommands.add(BUILDER_JDT_CORE_JAVA);
        if (this.wtpR7 || this.wtp10) {
            this.buildcommands.add(BUILDER_WST_VALIDATION);
        }
        if (this.wtpR7) {
            this.buildcommands.add(BUILDER_WST_COMPONENT_STRUCTURAL_DEPENDENCY_RESOLVER);
        }
    }

    private void downloadSourceArtifacts(Collection artifacts, Collection reactorArtifacts) throws MojoExecutionException {
        List remoteRepos = this.downloadSources ? this.remoteArtifactRepositories : new ArrayList(0);
        Iterator it = artifacts.iterator();
        while (it.hasNext()) {
            Artifact sourceArtifact;
            Artifact artifact = (Artifact)it.next();
            if (reactorArtifacts.contains(artifact) || (sourceArtifact = EclipseUtils.resolveArtifactWithClassifier(artifact, "sources", this.localRepository, this.artifactResolver, this.artifactFactory, remoteRepos)).isResolved()) continue;
            EclipseUtils.resolveArtifactWithClassifier(artifact, "javadoc", this.localRepository, this.artifactResolver, this.artifactFactory, remoteRepos);
            this.missingSourceArtifacts.add(artifact);
        }
    }

    private void reportMissingSources() {
        if (this.missingSourceArtifacts.isEmpty()) {
            return;
        }
        StringBuffer msg = new StringBuffer();
        if (this.downloadSources) {
            msg.append(Messages.getString("EclipseClasspathWriter.sourcesnotavailable"));
        } else {
            msg.append(Messages.getString("EclipseClasspathWriter.sourcesnotdownloaded"));
        }
        Iterator it = this.missingSourceArtifacts.iterator();
        while (it.hasNext()) {
            Artifact art = (Artifact)it.next();
            msg.append(Messages.getString("EclipseClasspathWriter.sourcesmissingitem", art.getId()));
        }
        msg.append("\n");
        this.getLog().info((CharSequence)msg);
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public void setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }

    public List getBuildcommands() {
        return this.buildcommands;
    }

    public void setBuildcommands(List buildcommands) {
        this.buildcommands = buildcommands;
    }

    public File getBuildOutputDirectory() {
        return this.buildOutputDirectory;
    }

    public void setBuildOutputDirectory(File buildOutputDirectory) {
        this.buildOutputDirectory = buildOutputDirectory;
    }

    public List getClasspathContainers() {
        return this.classpathContainers;
    }

    public void setClasspathContainers(List classpathContainers) {
        this.classpathContainers = classpathContainers;
    }

    public boolean isDownloadSources() {
        return this.downloadSources;
    }

    public void setDownloadSources(boolean downloadSources) {
        this.downloadSources = downloadSources;
    }

    public File getEclipseProjectDir() {
        return this.eclipseProjectDir;
    }

    public void setEclipseProjectDir(File eclipseProjectDir) {
        this.eclipseProjectDir = eclipseProjectDir;
    }

    public MavenProject getExecutedProject() {
        return this.executedProject;
    }

    public void setExecutedProject(MavenProject executedProject) {
        this.executedProject = executedProject;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public List getMissingSourceArtifacts() {
        return this.missingSourceArtifacts;
    }

    public void setMissingSourceArtifacts(List missingSourceArtifacts) {
        this.missingSourceArtifacts = missingSourceArtifacts;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public List getProjectnatures() {
        return this.projectnatures;
    }

    public void setProjectnatures(List projectnatures) {
        this.projectnatures = projectnatures;
    }

    public List getReactorProjects() {
        return this.reactorProjects;
    }

    public void setReactorProjects(List reactorProjects) {
        this.reactorProjects = reactorProjects;
    }

    public List getRemoteArtifactRepositories() {
        return this.remoteArtifactRepositories;
    }

    public void setRemoteArtifactRepositories(List remoteArtifactRepositories) {
        this.remoteArtifactRepositories = remoteArtifactRepositories;
    }

    public boolean isUseProjectReferences() {
        return this.useProjectReferences;
    }

    public void setUseProjectReferences(boolean useProjectReferences) {
        this.useProjectReferences = useProjectReferences;
    }

    public String getWtpversion() {
        return this.wtpversion;
    }

    public void setWtpversion(String wtpversion) {
        this.wtpversion = wtpversion;
    }
}

