/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.utils.translators;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.dependency.utils.translators.ArtifactTranslator;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.util.artifact.SubArtifact;

public class ClassifierTypeTranslator
implements ArtifactTranslator {
    private final ArtifactHandlerManager artifactHandlerManager;
    private String classifier;
    private String type;

    public ClassifierTypeTranslator(ArtifactHandlerManager artifactHandlerManager, String theClassifier, String theType) {
        this.artifactHandlerManager = artifactHandlerManager;
        this.classifier = theClassifier;
        this.type = theType;
    }

    @Override
    public Set<Artifact> translate(Set<org.apache.maven.artifact.Artifact> artifacts, Log log) {
        log.debug((CharSequence)("Translating Artifacts using Classifier: " + this.classifier + " and Type: " + this.type));
        LinkedHashSet<Artifact> results = new LinkedHashSet<Artifact>();
        for (org.apache.maven.artifact.Artifact artifact : artifacts) {
            String useType = this.type != null && !this.type.isEmpty() ? this.type : artifact.getType();
            ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(useType);
            String extension = artifactHandler != null ? artifactHandler.getExtension() : this.type;
            String useClassifier = this.classifier != null && !this.classifier.isEmpty() ? this.classifier : artifact.getClassifier();
            results.add((Artifact)new SubArtifact(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)artifact), useClassifier, extension));
        }
        return results;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String theType) {
        this.type = theType;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String theClassifier) {
        this.classifier = theClassifier;
    }
}

