/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.apache.maven.api.JavaPathType;
import org.apache.maven.api.PathType;

final class ForkedToolSources
implements StandardJavaFileManager {
    private final Map<PathType, Collection<? extends Path>> locations;
    final Charset encoding;

    ForkedToolSources(Charset encoding) {
        if (encoding == null) {
            encoding = Charset.defaultCharset();
        }
        this.encoding = encoding;
        this.locations = new HashMap<PathType, Collection<? extends Path>>();
    }

    @Override
    public int isSupportedOption(String option) {
        return -1;
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        return false;
    }

    @Override
    public Path asPath(FileObject file) {
        return file instanceof Item ? ((Item)file).path : Path.of(file.toUri());
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return this.asPath(a).equals(this.asPath(b));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... names) {
        return this.fromNames(Arrays.stream(names));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... files) {
        return this.fromFiles(Arrays.stream(files));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> names) {
        return this.fromNames(StreamSupport.stream(names.spliterator(), false));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
        return this.fromFiles(StreamSupport.stream(files.spliterator(), false));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromPaths(Collection<? extends Path> paths) {
        return paths.stream().map(x$0 -> new Item((Path)x$0)).toList();
    }

    private Iterable<? extends JavaFileObject> fromFiles(Stream<? extends File> files) {
        return files.map(file -> new Item(file.toPath())).toList();
    }

    private Iterable<? extends JavaFileObject> fromNames(Stream<? extends String> names) {
        return names.map(name -> new Item(Path.of(name, new String[0]))).toList();
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends File> files) {
        List<Path> paths = null;
        if (files != null) {
            paths = StreamSupport.stream(files.spliterator(), false).map(File::toPath).toList();
        }
        this.setLocationFromPaths(location, paths);
    }

    @Override
    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        Iterable paths = this.getLocationAsPaths(location);
        if (paths != null) {
            return paths.stream().map(Path::toFile).toList();
        }
        return null;
    }

    @Override
    public void setLocationFromPaths(JavaFileManager.Location location, Collection<? extends Path> paths) {
        PathType type = JavaPathType.valueOf((JavaFileManager.Location)location).orElse(null);
        if (type == null) {
            if (location == StandardLocation.SOURCE_OUTPUT) {
                type = OtherPathType.GENERATED_SOURCES;
            } else if (location == StandardLocation.SOURCE_PATH) {
                type = OtherPathType.SOURCES;
            } else if (location == StandardLocation.CLASS_OUTPUT) {
                type = OtherPathType.OUTPUT;
            } else {
                throw new IllegalArgumentException("Unsupported location: " + String.valueOf(location));
            }
        }
        if (paths == null || paths.isEmpty()) {
            this.locations.remove(type);
        } else {
            this.locations.put(type, paths);
        }
    }

    @Override
    public void setLocationForModule(JavaFileManager.Location location, String moduleName, Collection<? extends Path> paths) throws IOException {
        Object type;
        if (location == StandardLocation.PATCH_MODULE_PATH) {
            type = JavaPathType.patchModule((String)moduleName);
        } else if (location == StandardLocation.MODULE_SOURCE_PATH) {
            type = new OtherPathType("MODULE_SOURCE_PATH", "--module-source-path", moduleName);
        } else {
            throw new IllegalArgumentException("Unsupported location: " + String.valueOf(location));
        }
        if (paths == null || paths.isEmpty()) {
            this.locations.remove(type);
        } else {
            this.locations.put((PathType)type, paths);
        }
    }

    public Collection<? extends Path> getLocationAsPaths(JavaFileManager.Location location) {
        return this.locations.get(JavaPathType.valueOf((JavaFileManager.Location)location).orElse(null));
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.getLocationAsPaths(location) != null;
    }

    void addAllLocations(List<String> command) {
        for (Map.Entry<PathType, Collection<? extends Path>> entry : this.locations.entrySet()) {
            command.addAll(Arrays.asList(entry.getKey().option((Iterable)entry.getValue())));
        }
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return null;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.locations.clear();
    }

    private final class Item
    implements JavaFileObject {
        final Path path;

        Item(Path path) {
            this.path = path;
        }

        @Override
        public String getName() {
            return this.path.toString();
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public URI toUri() {
            return this.path.toUri();
        }

        @Override
        public JavaFileObject.Kind getKind() {
            String filename = this.path.getFileName().toString();
            for (JavaFileObject.Kind k : JavaFileObject.Kind.values()) {
                if (!filename.endsWith(k.extension)) continue;
                return k;
            }
            return JavaFileObject.Kind.OTHER;
        }

        @Override
        public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
            return this.path.getFileName().toString().equals(simpleName.concat(kind.extension));
        }

        @Override
        public NestingKind getNestingKind() {
            return null;
        }

        @Override
        public Modifier getAccessLevel() {
            return null;
        }

        @Override
        public long getLastModified() {
            try {
                return Files.getLastModifiedTime(this.path, new LinkOption[0]).toMillis();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public boolean delete() {
            try {
                return Files.deleteIfExists(this.path);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return Files.newInputStream(this.path, new OpenOption[0]);
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return Files.newOutputStream(this.path, new OpenOption[0]);
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            return Files.newBufferedReader(this.path, ForkedToolSources.this.encoding);
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return Files.readString(this.path, ForkedToolSources.this.encoding);
        }

        @Override
        public Writer openWriter() throws IOException {
            return Files.newBufferedWriter(this.path, ForkedToolSources.this.encoding, new OpenOption[0]);
        }
    }

    private record OtherPathType(String name, String optionString, String moduleName) implements PathType
    {
        static final OtherPathType SOURCES = new OtherPathType("SOURCES", "--source-path", null);
        static final OtherPathType GENERATED_SOURCES = new OtherPathType("GENERATED_SOURCES", "-s", null);
        static final OtherPathType OUTPUT = new OtherPathType("OUTPUT", "-d", null);

        public String id() {
            return this.name;
        }

        public Optional<String> option() {
            return Optional.of(this.optionString);
        }

        public String[] option(Iterable<? extends Path> paths) {
            String prefix = this.moduleName == null ? "" : this.moduleName + "=";
            StringJoiner builder = new StringJoiner(File.pathSeparator, prefix, "");
            paths.forEach(path -> builder.add(path.toString()));
            return new String[]{this.optionString, builder.toString()};
        }
    }
}

