/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.antrun;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.antrun.AntrunXmlPlexusConfigurationWriter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.taskdefs.Typedef;
import org.apache.tools.ant.types.Path;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class AntRunMojo
extends AbstractMojo {
    public static final String DEFAULT_MAVEN_PROJECT_REFID = "maven.project";
    public static final String DEFAULT_MAVEN_PROJECT_HELPER_REFID = "maven.project.helper";
    public static final String DEFAULT_ANT_TARGET_NAME = "main";
    public static final String UTF_8 = "UTF-8";
    private String antTargetName;
    public static final String ANTLIB = "org/apache/maven/ant/tasks/antlib.xml";
    public static final String TASK_URI = "antlib:org.apache.maven.ant.tasks";
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private List pluginArtifacts;
    protected ArtifactRepository localRepository;
    private String propertyPrefix;
    private String customTaskPrefix = "";
    private String versionsPropertyName;
    private PlexusConfiguration tasks;
    private PlexusConfiguration target;
    private File sourceRoot;
    private File testSourceRoot;
    public static final String DEPENDENCY_PREFIX = "maven.dependency.";

    public void execute() throws MojoExecutionException {
        MavenProject mavenProject = this.getMavenProject();
        if (this.tasks != null) {
            this.getLog().warn((CharSequence)"Parameter tasks is deprecated, use target instead");
            this.target = this.tasks;
        }
        if (this.target == null) {
            this.getLog().info((CharSequence)"No ant target defined - SKIPPED");
            return;
        }
        if (this.propertyPrefix == null) {
            this.propertyPrefix = "";
        }
        try {
            Project antProject = new Project();
            File antBuildFile = this.writeTargetToProjectFile();
            ProjectHelper.configureProject((Project)antProject, (File)antBuildFile);
            antProject.init();
            DefaultLogger antLogger = new DefaultLogger();
            antLogger.setOutputPrintStream(System.out);
            antLogger.setErrorPrintStream(System.err);
            antLogger.setMessageOutputLevel(this.getLog().isDebugEnabled() ? 4 : 2);
            antProject.addBuildListener((BuildListener)antLogger);
            antProject.setBaseDir(mavenProject.getBasedir());
            Path p = new Path(antProject);
            p.setPath(StringUtils.join(mavenProject.getCompileClasspathElements().iterator(), (String)File.pathSeparator));
            antProject.addReference("maven.dependency.classpath", (Object)p);
            antProject.addReference("maven.compile.classpath", (Object)p);
            p = new Path(antProject);
            p.setPath(StringUtils.join(mavenProject.getRuntimeClasspathElements().iterator(), (String)File.pathSeparator));
            antProject.addReference("maven.runtime.classpath", (Object)p);
            p = new Path(antProject);
            p.setPath(StringUtils.join(mavenProject.getTestClasspathElements().iterator(), (String)File.pathSeparator));
            antProject.addReference("maven.test.classpath", (Object)p);
            antProject.addReference("maven.plugin.classpath", (Object)this.getPathFromArtifacts(this.pluginArtifacts, antProject));
            antProject.addReference(DEFAULT_MAVEN_PROJECT_REFID, (Object)this.getMavenProject());
            antProject.addReference(DEFAULT_MAVEN_PROJECT_HELPER_REFID, (Object)this.projectHelper);
            antProject.addReference("maven.local.repository", (Object)this.localRepository);
            this.initMavenTasks(antProject);
            this.copyProperties(mavenProject, antProject);
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)"Executing tasks");
            }
            antProject.executeTarget(this.antTargetName);
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)"Executed tasks");
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("DependencyResolutionRequiredException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (BuildException e) {
            throw new MojoExecutionException("An Ant BuildException has occured: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error executing ant tasks: " + e.getMessage(), e);
        }
        if (this.sourceRoot != null) {
            this.getLog().info((CharSequence)("Registering compile source root " + this.sourceRoot));
            this.getMavenProject().addCompileSourceRoot(this.sourceRoot.toString());
        }
        if (this.testSourceRoot != null) {
            this.getLog().info((CharSequence)("Registering compile test source root " + this.testSourceRoot));
            this.getMavenProject().addTestCompileSourceRoot(this.testSourceRoot.toString());
        }
    }

    public Path getPathFromArtifacts(Collection artifacts, Project antProject) throws DependencyResolutionRequiredException {
        if (artifacts == null) {
            return new Path(antProject);
        }
        ArrayList<String> list = new ArrayList<String>(artifacts.size());
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact a = (Artifact)i.next();
            File file = a.getFile();
            if (file == null) {
                throw new DependencyResolutionRequiredException(a);
            }
            list.add(file.getPath());
        }
        Path p = new Path(antProject);
        p.setPath(StringUtils.join(list.iterator(), (String)File.pathSeparator));
        return p;
    }

    public void copyProperties(MavenProject mavenProject, Project antProject) {
        Artifact artifact;
        Properties mavenProps = mavenProject.getProperties();
        Iterator<Object> iter = mavenProps.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            antProject.setProperty(key, mavenProps.getProperty(key));
        }
        antProject.setProperty("ant.file", mavenProject.getFile().getAbsolutePath());
        this.getLog().debug((CharSequence)("Setting properties with prefix: " + this.propertyPrefix));
        antProject.setProperty(this.propertyPrefix + "project.groupId", mavenProject.getGroupId());
        antProject.setProperty(this.propertyPrefix + "project.artifactId", mavenProject.getArtifactId());
        antProject.setProperty(this.propertyPrefix + "project.name", mavenProject.getName());
        antProject.setProperty(this.propertyPrefix + "project.description", mavenProject.getDescription());
        antProject.setProperty(this.propertyPrefix + "project.version", mavenProject.getVersion());
        antProject.setProperty(this.propertyPrefix + "project.packaging", mavenProject.getPackaging());
        antProject.setProperty(this.propertyPrefix + "project.build.directory", mavenProject.getBuild().getDirectory());
        antProject.setProperty(this.propertyPrefix + "project.build.outputDirectory", mavenProject.getBuild().getOutputDirectory());
        antProject.setProperty(this.propertyPrefix + "project.build.testOutputDirectory", mavenProject.getBuild().getTestOutputDirectory());
        antProject.setProperty(this.propertyPrefix + "project.build.sourceDirectory", mavenProject.getBuild().getSourceDirectory());
        antProject.setProperty(this.propertyPrefix + "project.build.testSourceDirectory", mavenProject.getBuild().getTestSourceDirectory());
        antProject.setProperty(this.propertyPrefix + "localRepository", this.localRepository.toString());
        antProject.setProperty(this.propertyPrefix + "settings.localRepository", this.localRepository.getBasedir());
        Set depArtifacts = mavenProject.getArtifacts();
        Iterator it = depArtifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact2 = (Artifact)it.next();
            String propName = artifact2.getDependencyConflictId();
            antProject.setProperty(this.propertyPrefix + propName, artifact2.getFile().getPath());
        }
        StringBuffer versionsBuffer = new StringBuffer();
        Iterator it2 = depArtifacts.iterator();
        while (it2.hasNext()) {
            artifact = (Artifact)it2.next();
            versionsBuffer.append(artifact.getVersion() + File.pathSeparator);
        }
        antProject.setProperty(this.versionsPropertyName, versionsBuffer.toString());
        it2 = depArtifacts.iterator();
        while (it2.hasNext()) {
            artifact = (Artifact)it2.next();
            String propName = AntRunMojo.getDependencyArtifactPropertyName(artifact);
            antProject.setProperty(propName, artifact.getFile().getPath());
        }
    }

    public static String getDependencyArtifactPropertyName(Artifact artifact) {
        String key = DEPENDENCY_PREFIX + artifact.getGroupId() + "." + artifact.getArtifactId() + (artifact.getClassifier() != null ? "." + artifact.getClassifier() : "") + (artifact.getType() != null ? "." + artifact.getType() : "") + ".path";
        return key;
    }

    public MavenProject getMavenProject() {
        return this.project;
    }

    public void initMavenTasks(Project antProject) {
        this.getLog().debug((CharSequence)"Initialize Maven Ant Tasks");
        Typedef typedef = new Typedef();
        typedef.setProject(antProject);
        typedef.setResource(ANTLIB);
        if (!this.customTaskPrefix.equals("")) {
            typedef.setURI(TASK_URI);
        }
        typedef.execute();
    }

    private File writeTargetToProjectFile() throws IOException, PlexusConfigurationException {
        StringWriter writer = new StringWriter();
        AntrunXmlPlexusConfigurationWriter xmlWriter = new AntrunXmlPlexusConfigurationWriter();
        xmlWriter.write(this.target, writer);
        StringBuffer antProjectConfig = writer.getBuffer();
        this.stringReplace(antProjectConfig, "<tasks", "<target");
        this.stringReplace(antProjectConfig, "</tasks", "</target");
        this.antTargetName = this.target.getAttribute("name");
        if (this.antTargetName == null) {
            this.antTargetName = DEFAULT_ANT_TARGET_NAME;
            this.stringReplace(antProjectConfig, "<target", "<target name=\"" + this.antTargetName + "\"");
        }
        String xmlns = "";
        if (!this.customTaskPrefix.trim().equals("")) {
            xmlns = "xmlns:" + this.customTaskPrefix + "=\"" + TASK_URI + "\"";
        }
        String xmlHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
        antProjectConfig.insert(0, "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        String projectOpen = "<project name=\"maven-antrun-\" default=\"" + this.antTargetName + "\" " + xmlns + " >\n";
        int index = antProjectConfig.indexOf("<target");
        antProjectConfig.insert(index, projectOpen);
        String projectClose = "\n</project>";
        antProjectConfig.append("\n</project>");
        String fileName = "build-" + this.antTargetName + ".xml";
        File buildFile = new File(this.project.getBuild().getDirectory(), "/antrun/" + fileName);
        buildFile.getParentFile().mkdirs();
        FileUtils.fileWrite((String)buildFile.getAbsolutePath(), (String)UTF_8, (String)antProjectConfig.toString());
        return buildFile;
    }

    public void stringReplace(StringBuffer text, String match, String with) {
        int index = text.indexOf(match);
        if (index != -1) {
            text.replace(index, index + match.length(), with);
        }
    }

    public String checkTargetName(PlexusConfiguration antTargetConfig) throws PlexusConfigurationException {
        String targetName = antTargetConfig.getAttribute("name");
        if (targetName == null) {
            targetName = DEFAULT_ANT_TARGET_NAME;
        }
        return targetName;
    }
}

