/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.Menu;
import org.apache.maven.doxia.site.decoration.MenuItem;
import org.apache.maven.doxia.site.decoration.Skin;
import org.apache.maven.doxia.site.decoration.inheritance.DecorationModelInheritanceAssembler;
import org.apache.maven.doxia.site.decoration.io.xpp3.DecorationXpp3Reader;
import org.apache.maven.doxia.site.decoration.io.xpp3.DecorationXpp3Writer;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Site;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.reporting.MavenReport;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PrefixedPropertiesValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultSiteTool
implements SiteTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSiteTool.class);
    @Inject
    private ArtifactResolver artifactResolver;
    @Inject
    private ArtifactFactory artifactFactory;
    @Inject
    protected I18N i18n;
    @Inject
    protected DecorationModelInheritanceAssembler assembler;
    @Inject
    protected ProjectBuilder projectBuilder;

    @Override
    public Artifact getSkinArtifactFromRepository(ArtifactRepository localRepository, List<ArtifactRepository> remoteArtifactRepositories, DecorationModel decoration) throws SiteToolException {
        Artifact artifact;
        Objects.requireNonNull(localRepository, "localRepository cannot be null");
        Objects.requireNonNull(remoteArtifactRepositories, "remoteArtifactRepositories cannot be null");
        Objects.requireNonNull(decoration, "decoration cannot be null");
        Skin skin = Objects.requireNonNull(decoration.getSkin(), "decoration.skin cannot be null");
        String version = skin.getVersion();
        try {
            if (version == null) {
                version = "RELEASE";
            }
            VersionRange versionSpec = VersionRange.createFromVersionSpec((String)version);
            artifact = this.artifactFactory.createDependencyArtifact(skin.getGroupId(), skin.getArtifactId(), versionSpec, "jar", null, null);
            this.artifactResolver.resolve(artifact, remoteArtifactRepositories, localRepository);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new SiteToolException("The skin version '" + version + "' is not valid", (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new SiteToolException("Unable to find skin", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new SiteToolException("The skin does not exist", (Exception)((Object)e));
        }
        return artifact;
    }

    @Override
    public Artifact getDefaultSkinArtifact(ArtifactRepository localRepository, List<ArtifactRepository> remoteArtifactRepositories) throws SiteToolException {
        DecorationModel decorationModel = this.getDefaultDecorationModel();
        return this.getSkinArtifactFromRepository(localRepository, remoteArtifactRepositories, decorationModel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Deprecated
    public String getRelativePath(String to, String from) {
        String fromScheme;
        String toScheme;
        Objects.requireNonNull(to, "to cannot be null");
        Objects.requireNonNull(from, "from cannot be null");
        if (to.contains(":") && from.contains(":") && !(toScheme = to.substring(0, to.lastIndexOf(58))).equals(fromScheme = from.substring(0, from.lastIndexOf(58)))) {
            return to;
        }
        URL toUrl = null;
        URL fromUrl = null;
        String toPath = to;
        String fromPath = from;
        try {
            toUrl = new URL(to);
        }
        catch (MalformedURLException e) {
            try {
                toUrl = new File(DefaultSiteTool.getNormalizedPath(to)).toURI().toURL();
            }
            catch (MalformedURLException e1) {
                LOGGER.warn("Unable to load a URL for '" + to + "'", (Throwable)e);
                return to;
            }
        }
        try {
            fromUrl = new URL(from);
        }
        catch (MalformedURLException e) {
            try {
                fromUrl = new File(DefaultSiteTool.getNormalizedPath(from)).toURI().toURL();
            }
            catch (MalformedURLException e1) {
                LOGGER.warn("Unable to load a URL for '" + from + "'", (Throwable)e);
                return to;
            }
        }
        if (toUrl != null && fromUrl != null) {
            if (!toUrl.getProtocol().equalsIgnoreCase(fromUrl.getProtocol()) || !toUrl.getHost().equalsIgnoreCase(fromUrl.getHost()) || toUrl.getPort() != fromUrl.getPort()) return to;
            toPath = toUrl.getFile();
            fromPath = fromUrl.getFile();
        } else if (toUrl != null && fromUrl == null || toUrl == null && fromUrl != null) {
            return to;
        }
        String relativePath = DefaultSiteTool.getRelativeFilePath(fromPath, toPath);
        if (relativePath == null) {
            relativePath = to;
        }
        if (!LOGGER.isDebugEnabled() || relativePath.toString().equals(to)) return relativePath;
        LOGGER.debug("Mapped url: " + to + " to relative path: " + relativePath);
        return relativePath;
    }

    private static String getRelativeFilePath(String oldPath, String newPath) {
        String fromPath = new File(oldPath).getPath();
        String toPath = new File(newPath).getPath();
        if (toPath.matches("^\\[a-zA-Z]:")) {
            toPath = toPath.substring(1);
        }
        if (fromPath.matches("^\\[a-zA-Z]:")) {
            fromPath = fromPath.substring(1);
        }
        if (fromPath.startsWith(":", 1)) {
            fromPath = Character.toLowerCase(fromPath.charAt(0)) + fromPath.substring(1);
        }
        if (toPath.startsWith(":", 1)) {
            toPath = Character.toLowerCase(toPath.charAt(0)) + toPath.substring(1);
        }
        if (toPath.startsWith(":", 1) && fromPath.startsWith(":", 1) && !toPath.substring(0, 1).equals(fromPath.substring(0, 1))) {
            return null;
        }
        if (toPath.startsWith(":", 1) && !fromPath.startsWith(":", 1) || !toPath.startsWith(":", 1) && fromPath.startsWith(":", 1)) {
            return null;
        }
        String relativePath = DefaultSiteTool.buildRelativePath(toPath, fromPath, File.separatorChar);
        return relativePath.toString();
    }

    @Override
    public File getSiteDescriptor(File siteDirectory, Locale locale) {
        Objects.requireNonNull(siteDirectory, "siteDirectory cannot be null");
        Locale llocale = locale == null ? new Locale("") : locale;
        File siteDescriptor = new File(siteDirectory, "site_" + llocale.getLanguage() + ".xml");
        if (!siteDescriptor.isFile()) {
            siteDescriptor = new File(siteDirectory, "site.xml");
        }
        return siteDescriptor;
    }

    File getSiteDescriptorFromRepository(MavenProject project, ArtifactRepository localRepository, List<ArtifactRepository> repositories, Locale locale) throws SiteToolException {
        Objects.requireNonNull(project, "project cannot be null");
        Objects.requireNonNull(localRepository, "localRepository cannot be null");
        Objects.requireNonNull(repositories, "repositories cannot be null");
        Locale llocale = locale == null ? new Locale("") : locale;
        try {
            return this.resolveSiteDescriptor(project, localRepository, repositories, llocale);
        }
        catch (ArtifactNotFoundException e) {
            LOGGER.debug("Unable to locate site descriptor", (Throwable)e);
            return null;
        }
        catch (ArtifactResolutionException e) {
            throw new SiteToolException("Unable to locate site descriptor", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SiteToolException("Unable to locate site descriptor", e);
        }
    }

    @Override
    public DecorationModel getDecorationModel(File siteDirectory, Locale locale, MavenProject project, List<MavenProject> reactorProjects, ArtifactRepository localRepository, List<ArtifactRepository> repositories) throws SiteToolException {
        Objects.requireNonNull(project, "project cannot be null");
        Objects.requireNonNull(reactorProjects, "reactorProjects cannot be null");
        Objects.requireNonNull(localRepository, "localRepository cannot be null");
        Objects.requireNonNull(repositories, "repositories cannot be null");
        Locale llocale = locale == null ? Locale.getDefault() : locale;
        LOGGER.debug("Computing decoration model of " + project.getId() + " for locale " + llocale);
        Map.Entry<DecorationModel, MavenProject> result = this.getDecorationModel(0, siteDirectory, llocale, project, reactorProjects, localRepository, repositories);
        DecorationModel decorationModel = result.getKey();
        MavenProject parentProject = result.getValue();
        if (decorationModel == null) {
            LOGGER.debug("Using default site descriptor");
            decorationModel = this.getDefaultDecorationModel();
        }
        String siteDescriptorContent = this.decorationModelToString(decorationModel);
        siteDescriptorContent = this.getInterpolatedSiteDescriptorContent(project, siteDescriptorContent, false);
        decorationModel = this.readDecorationModel(siteDescriptorContent);
        if (parentProject != null) {
            this.populateParentMenu(decorationModel, llocale, project, parentProject, true);
        }
        try {
            this.populateModulesMenu(decorationModel, llocale, project, reactorProjects, localRepository, true);
        }
        catch (IOException e) {
            throw new SiteToolException("Error while populating modules menu", e);
        }
        return decorationModel;
    }

    @Override
    public String getInterpolatedSiteDescriptorContent(Map<String, String> props, MavenProject aProject, String siteDescriptorContent) throws SiteToolException {
        Objects.requireNonNull(props, "props cannot be null");
        return this.getInterpolatedSiteDescriptorContent(aProject, siteDescriptorContent, false);
    }

    private String getInterpolatedSiteDescriptorContent(MavenProject aProject, String siteDescriptorContent, boolean isEarly) throws SiteToolException {
        Objects.requireNonNull(aProject, "aProject cannot be null");
        Objects.requireNonNull(siteDescriptorContent, "siteDescriptorContent cannot be null");
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        if (isEarly) {
            interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("this.", (Object)aProject));
            interpolator.addValueSource((ValueSource)new PrefixedPropertiesValueSource("this.", aProject.getProperties()));
        } else {
            interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("project.", (Object)aProject));
            interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)aProject.getProperties()));
            try {
                interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
            }
            catch (IOException e) {
                throw new SiteToolException("Cannot interpolate environment properties", e);
            }
        }
        try {
            return interpolator.interpolate(siteDescriptorContent);
        }
        catch (InterpolationException e) {
            throw new SiteToolException("Cannot interpolate site descriptor", (Exception)((Object)e));
        }
    }

    @Override
    public MavenProject getParentProject(MavenProject aProject, List<MavenProject> reactorProjects, ArtifactRepository localRepository) {
        Objects.requireNonNull(aProject, "aProject cannot be null");
        Objects.requireNonNull(reactorProjects, "reactorProjects cannot be null");
        Objects.requireNonNull(localRepository, "localRepository cannot be null");
        return aProject.getParent();
    }

    private void populateParentMenu(DecorationModel decorationModel, Locale locale, MavenProject project, MavenProject parentProject, boolean keepInheritedRefs) {
        Objects.requireNonNull(decorationModel, "decorationModel cannot be null");
        Objects.requireNonNull(project, "project cannot be null");
        Objects.requireNonNull(parentProject, "parentProject cannot be null");
        Menu menu = decorationModel.getMenuRef("parent");
        if (menu == null) {
            return;
        }
        if (keepInheritedRefs && menu.isInheritAsRef()) {
            return;
        }
        Locale llocale = locale == null ? Locale.getDefault() : locale;
        String parentUrl = DefaultSiteTool.getDistMgmntSiteUrl(parentProject);
        if (parentUrl != null) {
            parentUrl = parentUrl.endsWith("/") ? parentUrl + "index.html" : parentUrl + "/index.html";
            parentUrl = this.getRelativePath(parentUrl, DefaultSiteTool.getDistMgmntSiteUrl(project));
        } else {
            File parentBasedir = parentProject.getBasedir();
            if (parentBasedir != null) {
                String parentPath = parentBasedir.getAbsolutePath();
                String projectPath = project.getBasedir().getAbsolutePath();
                parentUrl = this.getRelativePath(parentPath, projectPath) + "/index.html";
            }
        }
        if (parentUrl == null) {
            LOGGER.warn("Unable to find a URL to the parent project. The parent menu will NOT be added.");
        } else {
            if (menu.getName() == null) {
                menu.setName(this.i18n.getString("site-tool", llocale, "decorationModel.menu.parentproject"));
            }
            MenuItem item = new MenuItem();
            item.setName(parentProject.getName());
            item.setHref(parentUrl);
            menu.addItem(item);
        }
    }

    private void populateModulesMenu(DecorationModel decorationModel, Locale locale, MavenProject project, List<MavenProject> reactorProjects, ArtifactRepository localRepository, boolean keepInheritedRefs) throws SiteToolException, IOException {
        Locale llocale;
        Objects.requireNonNull(project, "project cannot be null");
        Objects.requireNonNull(reactorProjects, "reactorProjects cannot be null");
        Objects.requireNonNull(localRepository, "localRepository cannot be null");
        Objects.requireNonNull(decorationModel, "decorationModel cannot be null");
        Menu menu = decorationModel.getMenuRef("modules");
        if (menu == null) {
            return;
        }
        if (keepInheritedRefs && menu.isInheritAsRef()) {
            return;
        }
        Locale locale2 = llocale = locale == null ? Locale.getDefault() : locale;
        if (project.getModules().size() > 0) {
            if (menu.getName() == null) {
                menu.setName(this.i18n.getString("site-tool", llocale, "decorationModel.menu.projectmodules"));
            }
            for (String module : project.getModules()) {
                MavenProject moduleProject = DefaultSiteTool.getModuleFromReactor(project, reactorProjects, module);
                if (moduleProject == null) {
                    LOGGER.warn("Module " + module + " not found in reactor: loading locally");
                    File f = new File(project.getBasedir(), module + "/pom.xml");
                    if (f.exists()) {
                        try {
                            DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest();
                            request.setLocalRepository(localRepository);
                            ProjectBuildingResult result = this.projectBuilder.build(f, (ProjectBuildingRequest)request);
                            moduleProject = result.getProject();
                        }
                        catch (ProjectBuildingException e) {
                            throw new SiteToolException("Unable to read local module POM", (Exception)((Object)e));
                        }
                    } else {
                        LOGGER.warn("No filesystem module POM available");
                        moduleProject = new MavenProject();
                        moduleProject.setName(module);
                        moduleProject.setDistributionManagement(new DistributionManagement());
                        moduleProject.getDistributionManagement().setSite(new Site());
                        moduleProject.getDistributionManagement().getSite().setUrl(module);
                    }
                }
                String siteUrl = DefaultSiteTool.getDistMgmntSiteUrl(moduleProject);
                String itemName = moduleProject.getName() == null ? moduleProject.getArtifactId() : moduleProject.getName();
                this.appendMenuItem(project, menu, itemName, siteUrl, moduleProject.getArtifactId());
            }
        } else if (decorationModel.getMenuRef("modules").getInherit() == null) {
            decorationModel.removeMenuRef("modules");
        }
    }

    private static MavenProject getModuleFromReactor(MavenProject project, List<MavenProject> reactorProjects, String module) throws IOException {
        File moduleBasedir = new File(project.getBasedir(), module).getCanonicalFile();
        for (MavenProject reactorProject : reactorProjects) {
            if (!moduleBasedir.equals(reactorProject.getBasedir())) continue;
            return reactorProject;
        }
        return null;
    }

    @Override
    public void populateReportsMenu(DecorationModel decorationModel, Locale locale, Map<String, List<MavenReport>> categories) {
        Locale llocale;
        Objects.requireNonNull(decorationModel, "decorationModel cannot be null");
        Objects.requireNonNull(categories, "categories cannot be null");
        Menu menu = decorationModel.getMenuRef("reports");
        if (menu == null) {
            return;
        }
        Locale locale2 = llocale = locale == null ? Locale.getDefault() : locale;
        if (menu.getName() == null) {
            menu.setName(this.i18n.getString("site-tool", llocale, "decorationModel.menu.projectdocumentation"));
        }
        boolean found = false;
        if (menu.getItems().isEmpty()) {
            MenuItem item;
            List<MavenReport> categoryReports = categories.get("Project Info");
            if (!DefaultSiteTool.isEmptyList(categoryReports)) {
                item = this.createCategoryMenu(this.i18n.getString("site-tool", llocale, "decorationModel.menu.projectinformation"), "/project-info.html", categoryReports, llocale);
                menu.getItems().add(item);
                found = true;
            }
            if (!DefaultSiteTool.isEmptyList(categoryReports = categories.get("Project Reports"))) {
                item = this.createCategoryMenu(this.i18n.getString("site-tool", llocale, "decorationModel.menu.projectreports"), "/project-reports.html", categoryReports, llocale);
                menu.getItems().add(item);
                found = true;
            }
        }
        if (!found) {
            decorationModel.removeMenuRef("reports");
        }
    }

    @Override
    public List<Locale> getSiteLocales(String locales) {
        if (locales == null) {
            return Collections.singletonList(DEFAULT_LOCALE);
        }
        String[] localesArray = StringUtils.split((String)locales, (String)",");
        List<Locale> localesList = new ArrayList<Locale>(localesArray.length);
        for (String localeString : localesArray) {
            Locale locale = this.codeToLocale(localeString);
            if (locale == null) continue;
            if (!Arrays.asList(Locale.getAvailableLocales()).contains(locale)) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn("The locale defined by '" + locale + "' is not available in this Java Virtual Machine (" + System.getProperty("java.version") + " from " + System.getProperty("java.vendor") + ") - IGNORING");
                continue;
            }
            if (!locale.getLanguage().equals(DEFAULT_LOCALE.getLanguage()) && !this.i18n.getBundle("site-tool", locale).getLocale().getLanguage().equals(locale.getLanguage())) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn("The locale '" + locale + "' (" + locale.getDisplayName(Locale.ENGLISH) + ") is not currently supported by Maven Site - IGNORING.\nContributions are welcome and greatly appreciated!\nIf you want to contribute a new translation, please visit http://maven.apache.org/plugins/localization.html for detailed instructions.");
                continue;
            }
            localesList.add(locale);
        }
        if (localesList.isEmpty()) {
            localesList = Collections.singletonList(DEFAULT_LOCALE);
        }
        return localesList;
    }

    private Locale codeToLocale(String localeCode) {
        if (localeCode == null) {
            return null;
        }
        if ("default".equalsIgnoreCase(localeCode)) {
            return Locale.getDefault();
        }
        String language = "";
        String country = "";
        String variant = "";
        StringTokenizer tokenizer = new StringTokenizer(localeCode, "_");
        int maxTokens = 3;
        if (tokenizer.countTokens() > 3) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Invalid java.util.Locale format for '" + localeCode + "' entry - IGNORING");
            }
            return null;
        }
        if (tokenizer.hasMoreTokens()) {
            language = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                country = tokenizer.nextToken();
                if (tokenizer.hasMoreTokens()) {
                    variant = tokenizer.nextToken();
                }
            }
        }
        return new Locale(language, country, variant);
    }

    protected static String getNormalizedPath(String path) {
        String normalized = FilenameUtils.normalize((String)path);
        if (normalized == null) {
            normalized = path;
        }
        return normalized == null ? null : normalized.replace('\\', '/');
    }

    private File resolveSiteDescriptor(MavenProject project, ArtifactRepository localRepository, List<ArtifactRepository> repositories, Locale locale) throws IOException, ArtifactResolutionException, ArtifactNotFoundException {
        File result;
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(project.getGroupId(), project.getArtifactId(), project.getVersion(), "xml", "site_" + locale.getLanguage());
        boolean found = false;
        try {
            this.artifactResolver.resolve(artifact, repositories, localRepository);
            result = artifact.getFile();
            if (result.length() > 0L) {
                found = true;
            } else {
                LOGGER.debug("No site descriptor found for " + project.getId() + " for locale " + locale.getLanguage() + ", trying without locale...");
            }
        }
        catch (ArtifactNotFoundException e) {
            LOGGER.debug("Unable to locate site descriptor for locale " + locale.getLanguage(), (Throwable)e);
            result = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
            result.getParentFile().mkdirs();
            result.createNewFile();
        }
        if (!found) {
            artifact = this.artifactFactory.createArtifactWithClassifier(project.getGroupId(), project.getArtifactId(), project.getVersion(), "xml", "site");
            try {
                this.artifactResolver.resolve(artifact, repositories, localRepository);
            }
            catch (ArtifactNotFoundException e) {
                result = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
                result.getParentFile().mkdirs();
                result.createNewFile();
                throw e;
            }
            result = artifact.getFile();
            if (result.length() == 0L) {
                LOGGER.debug("No site descriptor found for " + project.getId() + " without locale.");
                result = null;
            }
        }
        return result;
    }

    private Map.Entry<DecorationModel, MavenProject> getDecorationModel(int depth, File siteDirectory, Locale locale, MavenProject project, List<MavenProject> reactorProjects, ArtifactRepository localRepository, List<ArtifactRepository> repositories) throws SiteToolException {
        File siteDescriptor;
        if (project.getBasedir() == null) {
            try {
                siteDescriptor = this.getSiteDescriptorFromRepository(project, localRepository, repositories, locale);
            }
            catch (SiteToolException e) {
                throw new SiteToolException("The site descriptor cannot be resolved from the repository", e);
            }
        } else {
            siteDescriptor = this.getSiteDescriptor(siteDirectory, locale);
        }
        DecorationModel decorationModel = null;
        XmlStreamReader siteDescriptorReader = null;
        try {
            if (siteDescriptor != null && siteDescriptor.exists()) {
                LOGGER.debug("Reading" + (depth == 0 ? "" : " parent level " + depth) + " site descriptor from " + siteDescriptor);
                siteDescriptorReader = ReaderFactory.newXmlReader((File)siteDescriptor);
                String siteDescriptorContent = IOUtil.toString((Reader)siteDescriptorReader);
                siteDescriptorContent = this.getInterpolatedSiteDescriptorContent(project, siteDescriptorContent, true);
                decorationModel = this.readDecorationModel(siteDescriptorContent);
                decorationModel.setLastModified(siteDescriptor.lastModified());
            } else {
                LOGGER.debug("No" + (depth == 0 ? "" : " parent level " + depth) + " site descriptor.");
            }
        }
        catch (IOException e) {
            throw new SiteToolException("The site descriptor for " + project.getId() + " cannot be read from " + siteDescriptor, e);
        }
        finally {
            IOUtil.close(siteDescriptorReader);
        }
        MavenProject parentProject = this.getParentProject(project, reactorProjects, localRepository);
        if (parentProject != null && (decorationModel == null || decorationModel.isMergeParent())) {
            LOGGER.debug("Looking for site descriptor of level " + ++depth + " parent project: " + parentProject.getId());
            File parentSiteDirectory = null;
            if (parentProject.getBasedir() != null) {
                String siteRelativePath = DefaultSiteTool.getRelativeFilePath(project.getBasedir().getAbsolutePath(), siteDescriptor.getParentFile().getAbsolutePath());
                parentSiteDirectory = new File(parentProject.getBasedir(), siteRelativePath);
            }
            DecorationModel parentDecorationModel = this.getDecorationModel(depth, parentSiteDirectory, locale, parentProject, reactorProjects, localRepository, repositories).getKey();
            if (decorationModel == null && parentDecorationModel != null) {
                decorationModel = new DecorationModel();
            }
            String name = project.getName();
            if (decorationModel != null && StringUtils.isNotEmpty((String)decorationModel.getName())) {
                name = decorationModel.getName();
            }
            String projectDistMgmnt = DefaultSiteTool.getDistMgmntSiteUrl(project);
            String parentDistMgmnt = DefaultSiteTool.getDistMgmntSiteUrl(parentProject);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Site decoration model inheritance: assembling child with level " + depth + " parent: distributionManagement.site.url child = " + projectDistMgmnt + " and parent = " + parentDistMgmnt);
            }
            this.assembler.assembleModelInheritance(name, decorationModel, parentDecorationModel, projectDistMgmnt, parentDistMgmnt == null ? projectDistMgmnt : parentDistMgmnt);
        }
        return new AbstractMap.SimpleEntry<Object, MavenProject>(decorationModel, parentProject);
    }

    private DecorationModel readDecorationModel(String siteDescriptorContent) throws SiteToolException {
        try {
            return new DecorationXpp3Reader().read((Reader)new StringReader(siteDescriptorContent));
        }
        catch (XmlPullParserException e) {
            throw new SiteToolException("Error parsing site descriptor", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SiteToolException("Error reading site descriptor", e);
        }
    }

    private DecorationModel getDefaultDecorationModel() throws SiteToolException {
        String siteDescriptorContent;
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((InputStream)this.getClass().getResourceAsStream("/default-site.xml"));
            siteDescriptorContent = IOUtil.toString((Reader)reader);
        }
        catch (IOException e) {
            try {
                throw new SiteToolException("Error reading default site descriptor", e);
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        return this.readDecorationModel(siteDescriptorContent);
    }

    private String decorationModelToString(DecorationModel decoration) throws SiteToolException {
        StringWriter writer = new StringWriter();
        try {
            new DecorationXpp3Writer().write((Writer)writer, decoration);
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            throw new SiteToolException("Error reading site descriptor", e);
        }
        finally {
            IOUtil.close((Writer)writer);
        }
    }

    private static String buildRelativePath(String toPath, String fromPath, char separatorChar) {
        StringTokenizer toTokeniser = new StringTokenizer(toPath, String.valueOf(separatorChar));
        StringTokenizer fromTokeniser = new StringTokenizer(fromPath, String.valueOf(separatorChar));
        int count = 0;
        while (toTokeniser.hasMoreTokens() && fromTokeniser.hasMoreTokens() && !(separatorChar == '\\' ? !fromTokeniser.nextToken().equalsIgnoreCase(toTokeniser.nextToken()) : !fromTokeniser.nextToken().equals(toTokeniser.nextToken()))) {
            ++count;
        }
        toTokeniser = new StringTokenizer(toPath, String.valueOf(separatorChar));
        fromTokeniser = new StringTokenizer(fromPath, String.valueOf(separatorChar));
        while (count-- > 0) {
            fromTokeniser.nextToken();
            toTokeniser.nextToken();
        }
        StringBuilder relativePath = new StringBuilder();
        while (fromTokeniser.hasMoreTokens()) {
            fromTokeniser.nextToken();
            relativePath.append("..");
            if (!fromTokeniser.hasMoreTokens()) continue;
            relativePath.append(separatorChar);
        }
        if (relativePath.length() != 0 && toTokeniser.hasMoreTokens()) {
            relativePath.append(separatorChar);
        }
        while (toTokeniser.hasMoreTokens()) {
            relativePath.append(toTokeniser.nextToken());
            if (!toTokeniser.hasMoreTokens()) continue;
            relativePath.append(separatorChar);
        }
        return relativePath.toString();
    }

    private void appendMenuItem(MavenProject project, Menu menu, String name, String href, String defaultHref) {
        String selectedHref = href;
        if (selectedHref == null) {
            selectedHref = defaultHref;
        }
        MenuItem item = new MenuItem();
        item.setName(name);
        String baseUrl = DefaultSiteTool.getDistMgmntSiteUrl(project);
        if (baseUrl != null) {
            selectedHref = this.getRelativePath(selectedHref, baseUrl);
        }
        if (selectedHref.endsWith("/")) {
            item.setHref(selectedHref + "index.html");
        } else {
            item.setHref(selectedHref + "/index.html");
        }
        menu.addItem(item);
    }

    private MenuItem createCategoryMenu(String name, String href, List<MavenReport> categoryReports, Locale locale) {
        MenuItem item = new MenuItem();
        item.setName(name);
        item.setCollapse(true);
        item.setHref(href);
        for (MavenReport report : categoryReports) {
            MenuItem subitem = new MenuItem();
            subitem.setName(report.getName(locale));
            subitem.setHref(report.getOutputName() + ".html");
            item.getItems().add(subitem);
        }
        return item;
    }

    private static boolean isEmptyList(List<?> list) {
        return list == null || list.isEmpty();
    }

    private static String getDistMgmntSiteUrl(MavenProject project) {
        return DefaultSiteTool.getDistMgmntSiteUrl(project.getDistributionManagement());
    }

    private static String getDistMgmntSiteUrl(DistributionManagement distMgmnt) {
        if (distMgmnt != null && distMgmnt.getSite() != null && distMgmnt.getSite().getUrl() != null) {
            return DefaultSiteTool.urlEncode(distMgmnt.getSite().getUrl());
        }
        return null;
    }

    private static String urlEncode(String url) {
        if (url == null) {
            return null;
        }
        try {
            return new File(url).toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException ex) {
            return url;
        }
    }
}

