/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.utils;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.utils.CloseableUtils;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSet;
import org.apache.linkis.common.io.resultset.ResultSetReader;
import org.apache.linkis.common.io.resultset.ResultSetWriter;
import org.apache.linkis.common.utils.Utils;
import org.apache.linkis.hadoop.common.conf.HadoopConf;
import org.apache.linkis.storage.LineMetaData;
import org.apache.linkis.storage.LineRecord;
import org.apache.linkis.storage.errorcode.LinkisStorageErrorCodeSummary;
import org.apache.linkis.storage.exception.StorageWarnException;
import org.apache.linkis.storage.resultset.ResultSetFactory;
import org.apache.linkis.storage.resultset.ResultSetReaderFactory;
import org.apache.linkis.storage.resultset.ResultSetWriterFactory;
import org.apache.linkis.storage.utils.StorageConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageUtils {
    private static final Logger logger = LoggerFactory.getLogger(StorageUtils.class);
    public static final String HDFS = "hdfs";
    public static final String FILE = "file";
    public static final String OSS = "oss";
    public static final String S3 = "s3";
    public static final String FILE_SCHEMA = "file://";
    public static final String HDFS_SCHEMA = "hdfs://";
    public static final String OSS_SCHEMA = "oss://";
    public static final String S3_SCHEMA = "s3://";
    private static final NumberFormat nf = NumberFormat.getInstance();

    public static String doubleToString(double value) {
        return nf.format(value);
    }

    public static <T> Map<String, T> loadClass(String classStr, Function<T, String> op) {
        String[] _classes = classStr.split(",");
        LinkedHashMap<String, Object> classes = new LinkedHashMap<String, Object>();
        for (String clazz : _classes) {
            try {
                Object obj = Utils.getClassInstance((String)clazz.trim());
                classes.put(op.apply(obj), obj);
            }
            catch (Exception e) {
                logger.warn("StorageUtils loadClass failed", (Throwable)e);
            }
        }
        return classes;
    }

    public static <T> Map<String, Class<T>> loadClasses(String classStr, String pge, Function<Class<T>, String> op) {
        String[] _classes = StringUtils.isEmpty((CharSequence)pge) ? classStr.split(",") : (String[])Stream.of(StringUtils.split((String)classStr, (char)',')).map(value -> pge + "." + value).toArray(String[]::new);
        LinkedHashMap<String, Class<T>> classes = new LinkedHashMap<String, Class<T>>();
        for (String clazz : _classes) {
            try {
                Class<?> _class = Thread.currentThread().getContextClassLoader().loadClass(clazz.trim());
                classes.put(op.apply(_class), _class);
            }
            catch (Exception e) {
                logger.warn("StorageUtils loadClasses failed", (Throwable)e);
            }
        }
        return classes;
    }

    public static String pathToSuffix(String path) {
        int dot;
        String fileName = new File(path).getName();
        if (fileName.length() > 0 && (dot = fileName.lastIndexOf(46)) > -1 && dot < fileName.length() - 1) {
            return fileName.substring(dot + 1);
        }
        return fileName;
    }

    public static Object invoke(Object obj, Method method, Object[] args) throws Exception {
        return method.invoke(obj, args);
    }

    public static String serializerStringToResult(String value) throws IOException {
        ResultSet<? extends MetaData, ? extends Record> resultSet = ResultSetFactory.getInstance().getResultSetByType("1");
        ResultSetWriter<? extends MetaData, ? extends Record> writer = ResultSetWriterFactory.getResultSetWriter(resultSet, Long.MAX_VALUE, null);
        LineMetaData metaData = new LineMetaData(null);
        LineRecord record = new LineRecord(value);
        writer.addMetaData((MetaData)metaData);
        writer.addRecord((Record)record);
        String res = writer.toString();
        IOUtils.closeQuietly(writer);
        return res;
    }

    public static String deserializerResultToString(String result) throws IOException {
        ResultSet<? extends MetaData, ? extends Record> resultSet = ResultSetFactory.getInstance().getResultSetByType("1");
        ResultSetReader reader = ResultSetReaderFactory.getResultSetReader(resultSet, result);
        StringBuilder sb = new StringBuilder();
        while (reader.hasNext()) {
            LineRecord record = (LineRecord)reader.getRecord();
            sb.append(record.getLine());
        }
        reader.close();
        return sb.toString();
    }

    public static void close(OutputStream outputStream) {
        StorageUtils.close(outputStream, null, null);
    }

    public static void close(InputStream inputStream) {
        StorageUtils.close(null, inputStream, null);
    }

    public static void close(Fs fs) {
        StorageUtils.close(null, null, fs);
    }

    public static void close(OutputStream outputStream, InputStream inputStream, Fs fs) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (fs != null) {
                fs.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(Closeable closeable) {
        CloseableUtils.closeQuietly((Closeable)closeable);
    }

    public static String getJvmUser() {
        return System.getProperty("user.name");
    }

    public static boolean isHDFSNode() {
        File confPath = new File(HadoopConf.hadoopConfDir());
        if (!confPath.exists() || confPath.isFile()) {
            throw new StorageWarnException(LinkisStorageErrorCodeSummary.CONFIGURATION_NOT_READ.getErrorCode(), LinkisStorageErrorCodeSummary.CONFIGURATION_NOT_READ.getErrorDesc());
        }
        return true;
    }

    public static FsPath getFsPath(String path) {
        if (path.startsWith(FILE_SCHEMA) || path.startsWith(HDFS_SCHEMA)) {
            return new FsPath(path);
        }
        return new FsPath(FILE_SCHEMA + path);
    }

    public static int readBytes(InputStream inputStream, byte[] bytes, int len) {
        int readLen;
        try {
            int count = 0;
            for (readLen = 0; readLen < len && readLen >= 0; readLen += count) {
                count = inputStream.read(bytes, readLen, len - readLen);
                if (count != -1 || inputStream.available() >= 1) continue;
                return readLen;
            }
        }
        catch (IOException e) {
            logger.warn("FileSystemUtils readBytes failed", (Throwable)e);
        }
        return readLen;
    }

    public static String colToString(Object col, String nullValue) {
        if (col == null) {
            return nullValue;
        }
        if (col instanceof Double) {
            return StorageUtils.doubleToString((Double)col);
        }
        if ("NULL".equals(col) || "".equals(col)) {
            return nullValue;
        }
        return col.toString();
    }

    public static String colToString(Object col) {
        return StorageUtils.colToString(col, "NULL");
    }

    public static boolean isIOProxy() {
        return (Boolean)StorageConfiguration.ENABLE_IO_PROXY.getValue();
    }

    public static byte[] mergeByteArrays(byte[] arr1, byte[] arr2) {
        byte[] mergedArray = new byte[arr1.length + arr2.length];
        System.arraycopy(arr1, 0, mergedArray, 0, arr1.length);
        System.arraycopy(arr2, 0, mergedArray, arr1.length, arr2.length);
        return mergedArray;
    }

    static {
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits((Integer)StorageConfiguration.DOUBLE_FRACTION_LEN.getValue());
    }
}

