/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.utils;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSet;
import org.apache.linkis.common.io.resultset.ResultSetReader;
import org.apache.linkis.storage.FSFactory;
import org.apache.linkis.storage.resultset.ResultSetFactory;
import org.apache.linkis.storage.resultset.ResultSetReaderFactory;
import org.apache.linkis.storage.resultset.table.TableMetaData;
import org.apache.linkis.storage.resultset.table.TableRecord;
import org.apache.linkis.storage.utils.FileSystemUtils;
import org.apache.linkis.storage.utils.StorageUtils;

public class StorageHelper {
    private static final Log logger = LogFactory.getLog(StorageHelper.class);

    public static void main(String[] args) {
        if (args.length < 2) {
            logger.info((Object)"Usage method params eg:getTableResLines path");
        }
        String method = args[0];
        String[] params = Arrays.copyOfRange(args, 1, args.length);
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        switch (method) {
            case "getTableResLines": {
                StorageHelper.getTableResLines(params);
                break;
            }
            case "getTableRes": {
                StorageHelper.getTableRes(params);
                break;
            }
            case "createNewFile": {
                StorageHelper.createNewFile(params);
                break;
            }
            default: {
                logger.info((Object)"There is no such method");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getTableResLines(String[] args) {
        ResultSetReader resultSetReader = null;
        try {
            FsPath resPath = StorageUtils.getFsPath(args[0]);
            ResultSetFactory resultSetFactory = ResultSetFactory.getInstance();
            ResultSet<? extends MetaData, ? extends Record> resultSet = resultSetFactory.getResultSetByType("2");
            Fs fs = FSFactory.getFs(resPath);
            fs.init(null);
            resultSetReader = ResultSetReaderFactory.getResultSetReader(resultSet, fs.read(resPath));
            TableMetaData metaData = (TableMetaData)resultSetReader.getMetaData();
            Arrays.stream(metaData.getColumns()).forEach(column -> logger.info((Object)column.toString()));
            int num = 0;
            Thread.sleep(10000L);
            while (resultSetReader.hasNext()) {
                resultSetReader.getRecord();
                ++num;
            }
            logger.info((Object)Integer.toString(num));
        }
        catch (Exception e) {
            logger.error((Object)"getTableResLines error:", (Throwable)e);
        }
        finally {
            if (resultSetReader != null) {
                try {
                    resultSetReader.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Failed to close ResultSetReader", (Throwable)e);
                }
            }
        }
    }

    public static void getTableRes(String[] args) {
        try {
            int len = Integer.parseInt(args[1]);
            int max = len + 10;
            FsPath resPath = StorageUtils.getFsPath(args[0]);
            ResultSetFactory resultSetFactory = ResultSetFactory.getInstance();
            ResultSet<? extends MetaData, ? extends Record> resultSet = resultSetFactory.getResultSetByType("2");
            Fs fs = FSFactory.getFs(resPath);
            fs.init(null);
            ResultSetReader reader = ResultSetReaderFactory.getResultSetReader(resultSet, fs.read(resPath));
            MetaData rmetaData = reader.getMetaData();
            Arrays.stream(((TableMetaData)rmetaData).getColumns()).forEach(column -> logger.info((Object)column.toString()));
            Arrays.stream(((TableMetaData)rmetaData).getColumns()).map(column -> column.getColumnName() + ",").forEach(column -> logger.info(column));
            int num = 0;
            while (reader.hasNext()) {
                if (++num > max) {
                    return;
                }
                if (num <= len) continue;
                Record record = reader.getRecord();
                Arrays.stream(((TableRecord)record).row).forEach(value -> {
                    logger.info((Object)value.toString());
                    logger.info((Object)",");
                });
                logger.info((Object)"\n");
            }
        }
        catch (IOException e) {
            logger.warn((Object)"StorageHelper getTableRes failed", (Throwable)e);
        }
    }

    public static void createNewFile(String[] args) {
        FsPath resPath = StorageUtils.getFsPath(args[0]);
        String proxyUser = StorageUtils.getJvmUser();
        try {
            FileSystemUtils.createNewFile(resPath, proxyUser, true);
        }
        catch (Exception e) {
            logger.warn((Object)"StorageHelper createNewFile failed", (Throwable)e);
        }
        logger.info((Object)"success");
    }
}

