/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.utils;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.Stack;
import org.apache.commons.io.IOUtils;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.storage.FSFactory;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.fs.impl.LocalFileSystem;
import org.apache.linkis.storage.utils.StorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(FsPath filePath, FsPath origin, String user) throws Exception {
        FileSystem fileSystem = (FileSystem)FSFactory.getFsByProxyUser(filePath, user);
        try {
            fileSystem.init(null);
            if (!fileSystem.exists(filePath)) {
                if (!fileSystem.exists(filePath.getParent())) {
                    fileSystem.mkdirs(filePath.getParent());
                }
                fileSystem.createNewFile(filePath);
            }
            fileSystem.copyFile(origin, filePath);
        }
        finally {
            IOUtils.closeQuietly((Closeable)((Object)fileSystem));
        }
    }

    public static void createNewFile(FsPath filePath, boolean createParentWhenNotExists) throws Exception {
        FileSystemUtils.createNewFile(filePath, StorageUtils.getJvmUser(), createParentWhenNotExists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createNewFile(FsPath filePath, String user, boolean createParentWhenNotExists) {
        FileSystem fileSystem = (FileSystem)FSFactory.getFsByProxyUser(filePath, user);
        try {
            fileSystem.init(null);
            FileSystemUtils.createNewFileWithFileSystem(fileSystem, filePath, user, createParentWhenNotExists);
        }
        catch (IOException e) {
            logger.warn("FileSystemUtils createNewFile failed", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn("FileSystemUtils createNewFile failed", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)((Object)fileSystem));
        }
    }

    public static void createNewFileWithFileSystem(FileSystem fileSystem, FsPath filePath, String user, boolean createParentWhenNotExists) throws Exception {
        if (!fileSystem.exists(filePath)) {
            if (!fileSystem.exists(filePath.getParent())) {
                if (!createParentWhenNotExists) {
                    throw new IOException("parent dir " + filePath.getParent().getPath() + " dose not exists.");
                }
                FileSystemUtils.mkdirs(fileSystem, filePath.getParent(), user);
            }
            fileSystem.createNewFile(filePath);
            if (fileSystem instanceof LocalFileSystem) {
                fileSystem.setOwner(filePath, user);
            } else {
                logger.info("doesn't need to call setOwner");
            }
        }
    }

    public static boolean mkdirs(FileSystem fileSystem, FsPath dest, String user) throws IOException {
        FsPath parentPath = dest.getParent();
        Stack<FsPath> dirsToMake = new Stack<FsPath>();
        dirsToMake.push(dest);
        while (!fileSystem.exists(parentPath)) {
            dirsToMake.push(parentPath);
            if (Objects.isNull(parentPath.getParent())) break;
            parentPath = parentPath.getParent();
        }
        if (!fileSystem.canExecute(parentPath)) {
            throw new IOException("You have not permission to access path " + dest.getPath());
        }
        while (!dirsToMake.empty()) {
            FsPath path = (FsPath)dirsToMake.pop();
            fileSystem.mkdir(path);
            if (fileSystem instanceof LocalFileSystem) {
                fileSystem.setOwner(path, user);
                continue;
            }
            logger.info("doesn't need to call setOwner");
        }
        return true;
    }
}

