/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.math3.util.Pair;
import org.apache.linkis.storage.LineRecord;
import org.apache.linkis.storage.script.ScriptRecord;
import org.apache.linkis.storage.source.AbstractFileSource;
import org.apache.linkis.storage.source.FileSplit;

class TextFileSource
extends AbstractFileSource {
    public static final String[] LINE_BREAKER = new String[]{"\n"};

    public TextFileSource(FileSplit[] fileSplits) {
        super(fileSplits);
        this.shuffle(record -> {
            if (record instanceof ScriptRecord && "".equals(((ScriptRecord)record).getLine())) {
                return new LineRecord("\n");
            }
            return record;
        });
    }

    @Override
    public Pair<Object, List<String[]>>[] collect() {
        Pair<Object, List<String[]>>[] collects = super.collect();
        if (!this.getParams().getOrDefault("ifMerge", "true").equals("true")) {
            return collects;
        }
        ArrayList snds = Arrays.stream(collects).map(Pair::getSecond).collect(Collectors.toCollection(ArrayList::new));
        snds.forEach(snd -> {
            StringBuilder str = new StringBuilder();
            snd.forEach(arr -> {
                if (Arrays.equals(arr, LINE_BREAKER)) {
                    str.append("\n");
                } else {
                    str.append(arr[0]).append("\n");
                }
            });
            snd.clear();
            snd.add(new String[]{str.toString()});
        });
        return collects;
    }
}

