/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.source;

import java.util.Arrays;
import org.apache.linkis.storage.resultset.table.TableRecord;
import org.apache.linkis.storage.source.AbstractFileSource;
import org.apache.linkis.storage.source.FileSplit;
import org.apache.linkis.storage.utils.StorageUtils;

public class ResultsetFileSource
extends AbstractFileSource {
    public ResultsetFileSource(FileSplit[] fileSplits) {
        super(fileSplits);
        this.shuffle(record -> {
            if (record instanceof TableRecord) {
                TableRecord tableRecord = (TableRecord)record;
                String nullValue = this.getParams().getOrDefault("nullValue", "NULL");
                return new TableRecord(Arrays.stream(tableRecord.row).map(r -> {
                    if (r == null || r.equals("NULL")) {
                        return nullValue;
                    }
                    if (r.equals("")) {
                        return this.getParams().getOrDefault("nullValue", "");
                    }
                    if (r instanceof Double) {
                        return StorageUtils.doubleToString((Double)r);
                    }
                    return r;
                }).toArray());
            }
            return record;
        });
    }
}

