/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.source;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.math3.util.Pair;
import org.apache.linkis.common.io.FsReader;
import org.apache.linkis.common.io.FsWriter;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.storage.LineMetaData;
import org.apache.linkis.storage.LineRecord;
import org.apache.linkis.storage.domain.Column;
import org.apache.linkis.storage.domain.DataType;
import org.apache.linkis.storage.errorcode.LinkisStorageErrorCodeSummary;
import org.apache.linkis.storage.exception.StorageWarnException;
import org.apache.linkis.storage.resultset.table.TableMetaData;
import org.apache.linkis.storage.resultset.table.TableRecord;
import org.apache.linkis.storage.script.Parser;
import org.apache.linkis.storage.script.ScriptMetaData;
import org.apache.linkis.storage.script.Variable;
import org.apache.linkis.storage.script.VariableParser;
import org.apache.linkis.storage.script.reader.StorageScriptFsReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSplit
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(FileSplit.class);
    private FsReader<? extends MetaData, ? extends Record> fsReader;
    protected String type = "script/text";
    private int start = 0;
    private int end = -1;
    private int count = 0;
    private int totalLine = 0;
    protected Function<Record, Record> shuffler;
    private boolean pageTrigger = false;
    protected Map<String, String> params = new HashMap<String, String>();

    public FileSplit(FsReader<? extends MetaData, ? extends Record> fsReader) {
        this.fsReader = fsReader;
    }

    public FileSplit(FsReader<? extends MetaData, ? extends Record> fsReader, String type) {
        this.fsReader = fsReader;
        this.type = type;
    }

    public void page(int page, int pageSize) {
        if (!this.pageTrigger) {
            this.start = (page - 1) * pageSize;
            this.end = pageSize * page - 1;
            this.pageTrigger = true;
        }
    }

    public String getType() {
        return this.type;
    }

    public void addParams(Map<String, String> params) {
        this.params.putAll(params);
    }

    public void addParams(String key, String value) {
        this.params.put(key, value);
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public int getTotalLine() {
        return this.totalLine;
    }

    public <M> M whileLoop(Function<MetaData, M> metaDataFunction, Consumer<Record> recordConsumer) {
        M m = null;
        try {
            MetaData metaData = this.fsReader.getMetaData();
            m = metaDataFunction.apply(metaData);
            if (this.pageTrigger) {
                this.fsReader.skip(this.start);
            }
            this.count = this.start;
            boolean hasRemovedFlag = false;
            while (this.fsReader.hasNext() && this.ifContinueRead()) {
                Record record = this.fsReader.getRecord();
                boolean needRemoveFlag = false;
                if (!hasRemovedFlag && this.fsReader instanceof StorageScriptFsReader) {
                    Parser parser = ((StorageScriptFsReader)this.fsReader).getScriptParser();
                    Variable[] meta = ((ScriptMetaData)metaData).getMetaData();
                    if (meta != null && meta.length > 0 && parser != null && parser.getAnnotationSymbol().equals(record.toString())) {
                        needRemoveFlag = true;
                        hasRemovedFlag = true;
                    }
                }
                if (needRemoveFlag) continue;
                recordConsumer.accept(this.shuffler.apply(record));
                ++this.totalLine;
                ++this.count;
            }
        }
        catch (IOException e) {
            logger.warn("FileSplit forEach failed", (Throwable)e);
            throw new StorageWarnException(LinkisStorageErrorCodeSummary.UNSUPPORTED_OPEN_FILE_TYPE.getErrorCode(), LinkisStorageErrorCodeSummary.UNSUPPORTED_OPEN_FILE_TYPE.getErrorMessage());
        }
        return m;
    }

    public void biConsumerWhileLoop(Consumer<MetaData> metaDataFunction, Consumer<Record> recordConsumer) {
        try {
            MetaData metaData = this.fsReader.getMetaData();
            metaDataFunction.accept(metaData);
            if (this.pageTrigger) {
                this.fsReader.skip(this.start);
            }
            this.count = this.start;
            boolean hasRemovedFlag = false;
            while (this.fsReader.hasNext() && this.ifContinueRead()) {
                Record record = this.fsReader.getRecord();
                boolean needRemoveFlag = false;
                if (!hasRemovedFlag && this.fsReader instanceof StorageScriptFsReader) {
                    Parser parser = ((StorageScriptFsReader)this.fsReader).getScriptParser();
                    Variable[] meta = ((ScriptMetaData)metaData).getMetaData();
                    if (meta != null && meta.length > 0 && parser != null && parser.getAnnotationSymbol().equals(record.toString())) {
                        needRemoveFlag = true;
                        hasRemovedFlag = true;
                    }
                }
                if (needRemoveFlag) continue;
                recordConsumer.accept(this.shuffler.apply(record));
                ++this.totalLine;
                ++this.count;
            }
        }
        catch (IOException e) {
            logger.warn("FileSplit forEach failed", (Throwable)e);
            throw new StorageWarnException(LinkisStorageErrorCodeSummary.UNSUPPORTED_OPEN_FILE_TYPE.getErrorCode(), LinkisStorageErrorCodeSummary.UNSUPPORTED_OPEN_FILE_TYPE.getErrorMessage());
        }
    }

    public Pair<Integer, Integer> getFileInfo(int needToCountRowNumber) {
        int colNumber = 0;
        int rowNumber = 0;
        MetaData metaData = null;
        try {
            metaData = this.fsReader.getMetaData();
            colNumber = metaData instanceof TableMetaData ? ((TableMetaData)metaData).getColumns().length : 1;
            rowNumber = needToCountRowNumber == -1 ? this.fsReader.skip(Integer.MAX_VALUE) : this.fsReader.skip(needToCountRowNumber);
        }
        catch (IOException e) {
            logger.warn("FileSplit getFileInfo failed", (Throwable)e);
            throw new StorageWarnException(LinkisStorageErrorCodeSummary.UNSUPPORTED_OPEN_FILE_TYPE.getErrorCode(), LinkisStorageErrorCodeSummary.UNSUPPORTED_OPEN_FILE_TYPE.getErrorMessage());
        }
        return new Pair((Object)colNumber, (Object)rowNumber);
    }

    public <K extends MetaData, V extends Record> void write(FsWriter<K, V> fsWriter) {
        this.biConsumerWhileLoop(metaData -> {
            try {
                fsWriter.addMetaData(metaData);
            }
            catch (IOException e) {
                logger.warn("FileSplit addMetaData failed", (Throwable)e);
                throw new StorageWarnException(LinkisStorageErrorCodeSummary.UNSUPPORTED_OPEN_FILE_TYPE.getErrorCode(), LinkisStorageErrorCodeSummary.UNSUPPORTED_OPEN_FILE_TYPE.getErrorMessage());
            }
        }, record -> {
            try {
                fsWriter.addRecord(record);
            }
            catch (IOException e) {
                logger.warn("FileSplit addRecord failed", (Throwable)e);
                throw new StorageWarnException(LinkisStorageErrorCodeSummary.UNSUPPORTED_OPEN_FILE_TYPE.getErrorCode(), LinkisStorageErrorCodeSummary.UNSUPPORTED_OPEN_FILE_TYPE.getErrorMessage());
            }
        });
    }

    public Pair<Object, List<String[]>> collect() {
        ArrayList recordList = new ArrayList();
        Object metaData = this.whileLoop(collectMetaData -> this.collectMetaData((MetaData)collectMetaData), r -> recordList.add(this.collectRecord((Record)r)));
        return new Pair(metaData, recordList);
    }

    public String[] collectRecord(Record record) {
        if (record instanceof TableRecord) {
            TableRecord tableRecord = (TableRecord)record;
            return (String[])Arrays.stream(tableRecord.row).map(DataType::valueToString).toArray(String[]::new);
        }
        if (record instanceof LineRecord) {
            LineRecord lineRecord = (LineRecord)record;
            return new String[]{lineRecord.getLine()};
        }
        throw new IllegalArgumentException("Unknown record type");
    }

    public Object collectMetaData(MetaData metaData) {
        if (metaData instanceof ScriptMetaData) {
            ScriptMetaData scriptMetaData = (ScriptMetaData)metaData;
            return VariableParser.getMap(scriptMetaData.getMetaData());
        }
        if (metaData instanceof LineMetaData) {
            LineMetaData lineMetaData = (LineMetaData)metaData;
            return lineMetaData.getMetaData();
        }
        if (metaData instanceof TableMetaData) {
            TableMetaData tableMetaData = (TableMetaData)metaData;
            return Arrays.stream(tableMetaData.getColumns()).map(this::columnToMap).collect(Collectors.toList());
        }
        throw new IllegalArgumentException("Unknown metadata type");
    }

    private Map<String, String> columnToMap(Column column) {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        stringMap.put("columnName", column.getColumnName());
        stringMap.put("comment", column.getComment());
        stringMap.put("dataType", column.getDataType().getTypeName());
        return stringMap;
    }

    public boolean ifContinueRead() {
        return !this.pageTrigger || this.count <= this.end;
    }

    public boolean ifStartRead() {
        return !this.pageTrigger || this.count >= this.start;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.fsReader);
    }
}

