/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.source;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.math3.util.Pair;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.FsReader;
import org.apache.linkis.common.io.FsWriter;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSet;
import org.apache.linkis.common.io.resultset.ResultSetReader;
import org.apache.linkis.storage.conf.LinkisStorageConf;
import org.apache.linkis.storage.errorcode.LinkisStorageErrorCodeSummary;
import org.apache.linkis.storage.exception.StorageWarnException;
import org.apache.linkis.storage.resultset.ResultSetFactory;
import org.apache.linkis.storage.resultset.ResultSetReaderFactory;
import org.apache.linkis.storage.script.ScriptFsReader;
import org.apache.linkis.storage.source.FileSplit;
import org.apache.linkis.storage.source.ResultsetFileSource;
import org.apache.linkis.storage.source.TextFileSource;
import org.apache.linkis.storage.utils.StorageConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface FileSource
extends Closeable {
    public static final Logger logger = LoggerFactory.getLogger(FileSource.class);
    public static final String[] fileType = LinkisStorageConf.getFileTypeArr();
    public static final BiFunction<String, String, Boolean> suffixPredicate = (path, suffix) -> path.endsWith("." + suffix);

    public FileSource shuffle(Function<Record, Record> var1);

    public FileSource page(int var1, int var2);

    public Pair<Object, List<String[]>>[] collect();

    public Pair<Integer, Integer>[] getFileInfo(int var1);

    public <K extends MetaData, V extends Record> void write(FsWriter<K, V> var1);

    public FileSource addParams(Map<String, String> var1);

    public FileSource addParams(String var1, String var2);

    public Map<String, String> getParams();

    public int getTotalLine();

    public String[] getTypes();

    public FileSplit[] getFileSplits();

    public static boolean isResultSet(String path) {
        return suffixPredicate.apply(path, fileType[0]);
    }

    public static boolean isResultSet(FsPath fsPath) {
        return FileSource.isResultSet(fsPath.getPath());
    }

    public static FileSource create(FsPath[] fsPaths, Fs fs) {
        FileSplit[] fileSplits = (FileSplit[])Arrays.stream(fsPaths).map(fsPath -> FileSource.createResultSetFileSplit(fsPath, fs)).filter(FileSource::isTableResultSet).toArray(FileSplit[]::new);
        return new ResultsetFileSource(fileSplits);
    }

    public static boolean isTableResultSet(FileSplit fileSplit) {
        return fileSplit.type.equals("2");
    }

    public static boolean isTableResultSet(FileSource fileSource) {
        return Arrays.stream(fileSource.getFileSplits()).allMatch(FileSource::isTableResultSet);
    }

    public static FileSource create(FsPath fsPath, Fs fs) {
        if (!FileSource.canRead(fsPath.getPath())) {
            throw new StorageWarnException(LinkisStorageErrorCodeSummary.UNSUPPORTED_OPEN_FILE_TYPE.getErrorCode(), LinkisStorageErrorCodeSummary.UNSUPPORTED_OPEN_FILE_TYPE.getErrorDesc());
        }
        if (FileSource.isResultSet(fsPath)) {
            return new ResultsetFileSource(new FileSplit[]{FileSource.createResultSetFileSplit(fsPath, fs)});
        }
        return new TextFileSource(new FileSplit[]{FileSource.createTextFileSplit(fsPath, fs)});
    }

    public static FileSource create(FsPath fsPath, InputStream is) {
        if (!FileSource.canRead(fsPath.getPath())) {
            throw new StorageWarnException(LinkisStorageErrorCodeSummary.UNSUPPORTED_OPEN_FILE_TYPE.getErrorCode(), LinkisStorageErrorCodeSummary.UNSUPPORTED_OPEN_FILE_TYPE.getErrorDesc());
        }
        if (FileSource.isResultSet(fsPath)) {
            return new ResultsetFileSource(new FileSplit[]{FileSource.createResultSetFileSplit(fsPath, is)});
        }
        return new TextFileSource(new FileSplit[]{FileSource.createTextFileSplit(fsPath, is)});
    }

    public static FileSplit createResultSetFileSplit(FsPath fsPath, InputStream is) {
        ResultSet<? extends MetaData, ? extends Record> resultset = ResultSetFactory.getInstance().getResultSetByPath(fsPath);
        ResultSetReader resultsetReader = ResultSetReaderFactory.getResultSetReader(resultset, is);
        return new FileSplit((FsReader<? extends MetaData, ? extends Record>)resultsetReader, resultset.resultSetType());
    }

    public static FileSplit createResultSetFileSplit(FsPath fsPath, Fs fs) {
        ResultSet<? extends MetaData, ? extends Record> resultset = ResultSetFactory.getInstance().getResultSetByPath(fsPath, fs);
        ResultSetReader resultsetReader = null;
        try {
            resultsetReader = ResultSetReaderFactory.getResultSetReader(resultset, fs.read(fsPath));
        }
        catch (IOException e) {
            logger.warn("FileSource createResultSetFileSplit failed", (Throwable)e);
        }
        return new FileSplit((FsReader<? extends MetaData, ? extends Record>)resultsetReader, resultset.resultSetType());
    }

    public static FileSplit createTextFileSplit(FsPath fsPath, InputStream is) {
        ScriptFsReader scriptFsReader = ScriptFsReader.getScriptFsReader(fsPath, (String)StorageConfiguration.STORAGE_RS_FILE_TYPE.getValue(), is);
        return new FileSplit(scriptFsReader);
    }

    public static FileSplit createTextFileSplit(FsPath fsPath, Fs fs) {
        ScriptFsReader scriptFsReader = null;
        try {
            scriptFsReader = ScriptFsReader.getScriptFsReader(fsPath, (String)StorageConfiguration.STORAGE_RS_FILE_TYPE.getValue(), fs.read(fsPath));
        }
        catch (IOException e) {
            logger.warn("FileSource createTextFileSplit failed", (Throwable)e);
        }
        return new FileSplit(scriptFsReader);
    }

    public static boolean canRead(String path) {
        return Arrays.stream(fileType).anyMatch(suffix -> path.endsWith("." + suffix));
    }
}

