/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.source;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.math3.util.Pair;
import org.apache.linkis.common.io.FsWriter;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.storage.source.FileSource;
import org.apache.linkis.storage.source.FileSplit;

public abstract class AbstractFileSource
implements FileSource {
    private FileSplit[] fileSplits;

    public AbstractFileSource(FileSplit[] fileSplits) {
        this.fileSplits = fileSplits;
    }

    @Override
    public FileSource shuffle(Function<Record, Record> function) {
        Arrays.stream(this.fileSplits).forEach(fileSplit -> {
            fileSplit.shuffler = function;
        });
        return this;
    }

    @Override
    public FileSource page(int page, int pageSize) {
        Arrays.stream(this.fileSplits).forEach(fileSplit -> fileSplit.page(page, pageSize));
        return this;
    }

    @Override
    public FileSource addParams(Map<String, String> params) {
        Arrays.stream(this.fileSplits).forEach(fileSplit -> fileSplit.addParams(params));
        return this;
    }

    @Override
    public FileSource addParams(String key, String value) {
        Arrays.stream(this.fileSplits).forEach(fileSplit -> fileSplit.addParams(key, value));
        return this;
    }

    @Override
    public FileSplit[] getFileSplits() {
        return this.fileSplits;
    }

    @Override
    public Map<String, String> getParams() {
        return Arrays.stream(this.fileSplits).map(FileSplit::getParams).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (existingValue, newValue) -> newValue));
    }

    @Override
    public <K extends MetaData, V extends Record> void write(FsWriter<K, V> fsWriter) {
        Arrays.stream(this.fileSplits).forEach(fileSplit -> fileSplit.write(fsWriter));
    }

    @Override
    public void close() {
        Arrays.stream(this.fileSplits).forEach(IOUtils::closeQuietly);
    }

    @Override
    public Pair<Object, List<String[]>>[] collect() {
        return (Pair[])Arrays.stream(this.fileSplits).map(FileSplit::collect).toArray(Pair[]::new);
    }

    @Override
    public int getTotalLine() {
        return Arrays.stream(this.fileSplits).mapToInt(FileSplit::getTotalLine).sum();
    }

    @Override
    public String[] getTypes() {
        return (String[])Arrays.stream(this.fileSplits).map(FileSplit::getType).toArray(String[]::new);
    }

    @Override
    public Pair<Integer, Integer>[] getFileInfo(int needToCountRowNumber) {
        return (Pair[])Arrays.stream(this.fileSplits).map(fileSplit -> fileSplit.getFileInfo(needToCountRowNumber)).toArray(Pair[]::new);
    }
}

