/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.script.writer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.storage.LineRecord;
import org.apache.linkis.storage.script.Compaction;
import org.apache.linkis.storage.script.ScriptFsWriter;
import org.apache.linkis.storage.script.ScriptMetaData;
import org.apache.linkis.storage.script.Variable;
import org.apache.linkis.storage.utils.StorageConfiguration;
import org.apache.linkis.storage.utils.StorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageScriptFsWriter
extends ScriptFsWriter {
    private static final Logger log = LoggerFactory.getLogger(StorageScriptFsWriter.class);
    private final FsPath path;
    private final String charset;
    private final OutputStream outputStream;
    private final StringBuilder stringBuilder = new StringBuilder();

    public StorageScriptFsWriter(FsPath path, String charset, OutputStream outputStream) {
        this.path = path;
        this.charset = charset;
        this.outputStream = outputStream;
    }

    public void addMetaData(MetaData metaData) throws IOException {
        String suffix = StorageUtils.pathToSuffix(this.path.getPath());
        List compactions = Stream.of(Compaction.listCompactions()).filter(compaction -> compaction.belongTo(suffix)).collect(Collectors.toList());
        ArrayList<String> metadataLine = new ArrayList<String>();
        if (!compactions.isEmpty()) {
            Variable[] metaData1 = ((ScriptMetaData)metaData).getMetaData();
            Stream.of(metaData1).map(((Compaction)compactions.get(0))::compact).forEach(metadataLine::add);
            if (metadataLine.size() > 0) {
                metadataLine.add(((Compaction)compactions.get(0)).getAnnotationSymbol());
            }
            if (this.outputStream != null) {
                IOUtils.writeLines(metadataLine, (String)"\n", (OutputStream)this.outputStream, (String)this.charset);
            } else {
                metadataLine.forEach(m -> this.stringBuilder.append((String)m).append("\n"));
            }
        }
    }

    public void addRecord(Record record) throws IOException {
        LineRecord scriptRecord = (LineRecord)record;
        if (this.outputStream != null) {
            IOUtils.write((String)scriptRecord.getLine(), (OutputStream)this.outputStream, (String)this.charset);
        } else {
            this.stringBuilder.append(scriptRecord.getLine());
        }
    }

    public void close() {
        IOUtils.closeQuietly((OutputStream)this.outputStream);
    }

    public void flush() {
        if (this.outputStream instanceof HdfsDataOutputStream) {
            try {
                ((HdfsDataOutputStream)this.outputStream).hflush();
            }
            catch (IOException t) {
                log.warn("Error encountered when flush script", (Throwable)t);
            }
        } else if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (IOException t) {
                log.warn("Error encountered when flush script", (Throwable)t);
            }
        }
    }

    @Override
    public InputStream getInputStream() {
        byte[] bytes = null;
        try {
            bytes = this.stringBuilder.toString().getBytes((String)StorageConfiguration.STORAGE_RS_FILE_TYPE.getValue());
        }
        catch (UnsupportedEncodingException e) {
            log.warn("StorageScriptFsWriter getInputStream failed", (Throwable)e);
        }
        return new ByteArrayInputStream(bytes);
    }
}

