/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.script.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.storage.script.Parser;
import org.apache.linkis.storage.script.ParserFactory;
import org.apache.linkis.storage.script.ScriptFsReader;
import org.apache.linkis.storage.script.ScriptMetaData;
import org.apache.linkis.storage.script.ScriptRecord;
import org.apache.linkis.storage.script.Variable;
import org.apache.linkis.storage.utils.StorageUtils;

public class StorageScriptFsReader
extends ScriptFsReader {
    private final FsPath path;
    private final String charset;
    private final InputStream inputStream;
    private InputStreamReader inputStreamReader;
    private BufferedReader bufferedReader;
    private ScriptMetaData metadata;
    private List<Variable> variables = new ArrayList<Variable>();
    private String lineText;

    public StorageScriptFsReader(FsPath path, String charset, InputStream inputStream) {
        super(path, charset);
        this.path = path;
        this.charset = charset;
        this.inputStream = inputStream;
    }

    public Record getRecord() throws IOException {
        if (this.metadata == null) {
            throw new IOException("Must read metadata first(\u5fc5\u987b\u5148\u8bfb\u53d6metadata)");
        }
        ScriptRecord record = new ScriptRecord(this.lineText);
        this.lineText = this.bufferedReader.readLine();
        return record;
    }

    public MetaData getMetaData() throws IOException {
        if (this.metadata == null) {
            this.init();
        }
        Parser parser = this.getScriptParser();
        this.lineText = this.bufferedReader.readLine();
        while (this.hasNext() && Objects.nonNull(parser) && this.isMetadata(this.lineText, parser.prefix(), parser.prefixConf())) {
            this.variables.add(parser.parse(this.lineText));
            this.lineText = this.bufferedReader.readLine();
        }
        this.metadata = new ScriptMetaData(this.variables.toArray(new Variable[0]));
        return this.metadata;
    }

    public void init() {
        this.inputStreamReader = new InputStreamReader(this.inputStream);
        this.bufferedReader = new BufferedReader(this.inputStreamReader);
    }

    public int skip(int recordNum) throws IOException {
        if (recordNum < 0) {
            return -1;
        }
        if (this.metadata == null) {
            this.getMetaData();
        }
        try {
            return (int)this.bufferedReader.skip(recordNum);
        }
        catch (Throwable t) {
            return recordNum;
        }
    }

    public long getPosition() throws IOException {
        return -1L;
    }

    public boolean hasNext() throws IOException {
        return this.lineText != null;
    }

    public long available() throws IOException {
        return this.inputStream != null ? (long)this.inputStream.available() : 0L;
    }

    public void close() throws IOException {
        IOUtils.closeQuietly((Reader)this.bufferedReader);
        IOUtils.closeQuietly((Reader)this.inputStreamReader);
        IOUtils.closeQuietly((InputStream)this.inputStream);
    }

    public boolean isMetadata(String line, String prefix, String prefixConf) {
        String regex = "\\s*" + prefix + "\\s*(.+)\\s*=\\s*(.+)\\s*";
        if (line.matches(regex)) {
            return true;
        }
        String[] split = line.split("=");
        if (split.length != 2) {
            return false;
        }
        if (Stream.of(split[0].split(" ")).filter(str -> !"".equals(str)).count() != 4L) {
            return false;
        }
        Optional<String> optional = Stream.of(split[0].split(" ")).filter(str -> !"".equals(str)).findFirst();
        return !optional.isPresent() || optional.get().equals(prefixConf);
    }

    public Parser getScriptParser() {
        List parsers = Arrays.stream(ParserFactory.listParsers()).filter(p -> p.belongTo(StorageUtils.pathToSuffix(this.path.getPath()))).collect(Collectors.toList());
        if (parsers.size() > 0) {
            return (Parser)parsers.get(0);
        }
        return null;
    }
}

