/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.script.parser;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.linkis.storage.errorcode.LinkisStorageErrorCodeSummary;
import org.apache.linkis.storage.exception.StorageWarnException;
import org.apache.linkis.storage.script.Parser;
import org.apache.linkis.storage.script.Variable;

public abstract class CommonScriptParser
implements Parser {
    @Override
    public Variable parse(String line) {
        String variableReg = "\\s*" + this.prefix() + "\\s*(.+)\\s*=\\s*(.+)\\s*";
        Pattern pattern = Pattern.compile(variableReg);
        Matcher matcher = pattern.matcher(line);
        if (matcher.matches()) {
            String key = matcher.group(1).trim();
            String value = matcher.group(2).trim();
            return new Variable("variable", null, key, value);
        }
        String[] splitLine = line.split("=");
        if (splitLine.length != 2) {
            throw new StorageWarnException(LinkisStorageErrorCodeSummary.INVALID_CUSTOM_PARAMETER.getErrorCode(), LinkisStorageErrorCodeSummary.INVALID_CUSTOM_PARAMETER.getErrorDesc());
        }
        String[] subSplit = (String[])Arrays.stream(splitLine[0].split(" ")).filter(str -> !"".equals(str)).toArray(String[]::new);
        if (subSplit.length != 4) {
            throw new StorageWarnException(LinkisStorageErrorCodeSummary.INVALID_CUSTOM_PARAMETER.getErrorCode(), LinkisStorageErrorCodeSummary.INVALID_CUSTOM_PARAMETER.getErrorDesc());
        }
        if (!subSplit[0].trim().equals(this.prefixConf())) {
            throw new StorageWarnException(LinkisStorageErrorCodeSummary.INVALID_CUSTOM_PARAMETER.getErrorCode(), LinkisStorageErrorCodeSummary.INVALID_CUSTOM_PARAMETER.getErrorDesc());
        }
        String sortParent = subSplit[1].trim();
        String sort = subSplit[2].trim();
        String key = subSplit[3].trim();
        String value = splitLine[1].trim();
        return new Variable(sortParent, sort, key, value);
    }

    @Override
    public String getAnnotationSymbol() {
        return this.prefix().split("@")[0];
    }
}

