/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.script;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.linkis.storage.script.Variable;

public class VariableParser {
    public static final String CONFIGURATION = "configuration";
    public static final String VARIABLE = "variable";
    public static final String RUNTIME = "runtime";
    public static final String STARTUP = "startup";
    public static final String SPECIAL = "special";

    public static Variable[] getVariables(Map<String, Object> params) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Map variableMap = params.getOrDefault(VARIABLE, new HashMap());
        for (Map.Entry entry : variableMap.entrySet()) {
            variables.add(new Variable(VARIABLE, null, (String)entry.getKey(), entry.getValue().toString()));
        }
        Map configurationMap = params.getOrDefault(CONFIGURATION, new HashMap());
        for (Map.Entry entry : configurationMap.entrySet()) {
            Map subMap = (Map)entry.getValue();
            for (Map.Entry subEntry : subMap.entrySet()) {
                if (VariableParser.isContextIDINFO((String)subEntry.getKey())) continue;
                Object value = subEntry.getValue();
                if (value instanceof Map) {
                    Map innerMap = (Map)value;
                    for (Map.Entry innerEntry : innerMap.entrySet()) {
                        if (VariableParser.isContextIDINFO((String)innerEntry.getKey())) continue;
                        variables.add(new Variable((String)entry.getKey(), (String)subEntry.getKey(), (String)innerEntry.getKey(), innerEntry.getValue().toString()));
                    }
                    continue;
                }
                if (value == null) {
                    variables.add(new Variable(CONFIGURATION, (String)entry.getKey(), (String)subEntry.getKey(), ""));
                    continue;
                }
                variables.add(new Variable(CONFIGURATION, (String)entry.getKey(), (String)subEntry.getKey(), value.toString()));
            }
        }
        return variables.toArray(new Variable[variables.size()]);
    }

    private static boolean isContextIDINFO(String key) {
        return "contextID".equalsIgnoreCase(key) || "nodeName".equalsIgnoreCase(key);
    }

    public static Map<String, Object> getMap(Variable[] variables) {
        HashMap variableKey2Value = new HashMap();
        HashMap confs = new HashMap();
        Arrays.stream(variables).filter(variable -> variable.sort == null).forEach(v -> variableKey2Value.put(v.key, v.value));
        Arrays.stream(variables).filter(variable -> variable.sort != null).forEach(v -> {
            switch (v.getSort()) {
                case "startup": 
                case "runtime": 
                case "special": {
                    if (!confs.containsKey(v.getSort())) {
                        confs.put(v.getSort(), VariableParser.createMap(v));
                        break;
                    }
                    Map subMap = (Map)confs.get(v.getSort());
                    subMap.put(v.getKey(), v.getValue());
                    break;
                }
                default: {
                    if (!confs.containsKey(v.getSortParent())) {
                        HashMap<String, Map<String, Object>> subMap = new HashMap<String, Map<String, Object>>();
                        subMap.put(v.getSort(), VariableParser.createMap(v));
                        confs.put(v.getSortParent(), subMap);
                        break;
                    }
                    Map subMap = (Map)confs.get(v.getSortParent());
                    if (!subMap.containsKey(v.getSort())) {
                        subMap.put(v.getSort(), VariableParser.createMap(v));
                        break;
                    }
                    Map innerMap = (Map)subMap.get(v.getSort());
                    innerMap.put(v.getKey(), v.getValue());
                }
            }
        });
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!variableKey2Value.isEmpty()) {
            params.put(VARIABLE, variableKey2Value);
        }
        if (!confs.isEmpty()) {
            params.put(CONFIGURATION, confs);
        }
        return params;
    }

    private static Map<String, Object> createMap(Variable variable) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(variable.getKey(), variable.getValue());
        return map;
    }
}

