/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.resultset.txt;

import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSerializer;
import org.apache.linkis.storage.LineMetaData;
import org.apache.linkis.storage.LineRecord;
import org.apache.linkis.storage.domain.Dolphin;
import org.apache.linkis.storage.utils.StorageUtils;

public class TextResultSerializer
extends ResultSerializer {
    public byte[] metaDataToBytes(MetaData metaData) {
        if (metaData == null) {
            return this.lineToBytes(null);
        }
        LineMetaData textMetaData = (LineMetaData)metaData;
        return this.lineToBytes(textMetaData.getMetaData());
    }

    public byte[] recordToBytes(Record record) {
        LineRecord textRecord = (LineRecord)record;
        return this.lineToBytes(textRecord.getLine());
    }

    private byte[] lineToBytes(String value) {
        byte[] bytes = value == null ? Dolphin.NULL_BYTES : Dolphin.getBytes(value);
        return StorageUtils.mergeByteArrays(Dolphin.getIntBytes(bytes.length), bytes);
    }
}

