/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.resultset.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSerializer;
import org.apache.linkis.storage.domain.Column;
import org.apache.linkis.storage.domain.Dolphin;
import org.apache.linkis.storage.resultset.table.TableMetaData;
import org.apache.linkis.storage.resultset.table.TableRecord;

public class TableResultSerializer
extends ResultSerializer {
    public byte[] metaDataToBytes(MetaData metaData) {
        TableMetaData tableMetaData = (TableMetaData)metaData;
        Object[] objects = Arrays.stream(tableMetaData.columns).map(Column::toArray).flatMap(Arrays::stream).toArray();
        return this.lineToBytes(objects);
    }

    public byte[] recordToBytes(Record record) {
        TableRecord tableRecord = (TableRecord)record;
        return this.lineToBytes(tableRecord.row);
    }

    private byte[] lineToBytes(Object[] line) {
        ArrayList<byte[]> dataBytes = new ArrayList<byte[]>();
        ArrayList<byte[]> colIndex = new ArrayList<byte[]>();
        int colByteLen = 0;
        int length = 0;
        for (Object data : line) {
            byte[] bytes = data == null ? Dolphin.NULL_BYTES : Dolphin.getBytes(data);
            dataBytes.add(bytes);
            byte[] colBytes = Dolphin.getBytes(bytes.length);
            colIndex.add(colBytes);
            colIndex.add(Dolphin.COL_SPLIT_BYTES);
            colByteLen += colBytes.length + Dolphin.COL_SPLIT_LEN;
            length += bytes.length;
        }
        return TableResultSerializer.toByteArray(length += colByteLen + 10, colByteLen, colIndex, dataBytes);
    }

    public static byte[] toByteArray(int length, int colByteLen, List<byte[]> colIndex, List<byte[]> dataBytes) {
        ArrayList<Byte> row = new ArrayList<Byte>();
        colIndex.addAll(dataBytes);
        for (byte intByte : Dolphin.getIntBytes(length)) {
            row.add(intByte);
        }
        for (byte colByte : Dolphin.getIntBytes(colByteLen)) {
            row.add(colByte);
        }
        colIndex.forEach(bytes -> {
            for (byte b : bytes) {
                row.add(b);
            }
        });
        byte[] result = new byte[row.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Byte)row.get(i);
        }
        return result;
    }
}

