/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.resultset.table;

import java.util.ArrayList;
import org.apache.linkis.common.io.resultset.ResultDeserializer;
import org.apache.linkis.storage.domain.Column;
import org.apache.linkis.storage.domain.DataType;
import org.apache.linkis.storage.domain.Dolphin;
import org.apache.linkis.storage.errorcode.LinkisStorageErrorCodeSummary;
import org.apache.linkis.storage.exception.StorageWarnException;
import org.apache.linkis.storage.resultset.table.TableMetaData;
import org.apache.linkis.storage.resultset.table.TableRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableResultDeserializer
extends ResultDeserializer<TableMetaData, TableRecord> {
    private static final Logger logger = LoggerFactory.getLogger(TableResultDeserializer.class);
    private TableMetaData metaData;

    public TableMetaData createMetaData(byte[] bytes) {
        int colByteLen = Integer.parseInt(Dolphin.getString(bytes, 0, 10));
        String colString = Dolphin.getString(bytes, 10, colByteLen);
        String[] colArray = colString.endsWith(",") ? colString.substring(0, colString.length() - 1).split(",") : colString.split(",");
        int index = 10 + colByteLen;
        if (colArray.length % 3 != 0) {
            throw new StorageWarnException(LinkisStorageErrorCodeSummary.PARSING_METADATA_FAILED.getErrorCode(), LinkisStorageErrorCodeSummary.PARSING_METADATA_FAILED.getErrorDesc());
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        for (int i = 0; i < colArray.length; i += 3) {
            int len = Integer.parseInt(colArray[i]);
            String colName = Dolphin.getString(bytes, index, len);
            index += len;
            len = Integer.parseInt(colArray[i + 1]);
            String colType = Dolphin.getString(bytes, index, len);
            index += len;
            len = Integer.parseInt(colArray[i + 2]);
            String colComment = Dolphin.getString(bytes, index, len);
            index += len;
            columns.add(new Column(colName, DataType.toDataType(colType), colComment));
        }
        this.metaData = new TableMetaData(columns.toArray(new Column[0]));
        return this.metaData;
    }

    public TableRecord createRecord(byte[] bytes) {
        int colByteLen = Integer.parseInt(Dolphin.getString(bytes, 0, 10));
        String colString = Dolphin.getString(bytes, 10, colByteLen);
        String[] colArray = colString.endsWith(",") ? colString.substring(0, colString.length() - 1).split(",") : colString.split(",");
        int index = 10 + colByteLen;
        Object[] data = new Object[colArray.length];
        for (int i = 0; i < colArray.length; ++i) {
            int len = Integer.parseInt(colArray[i]);
            String res = Dolphin.getString(bytes, index, len);
            index += len;
            data[i] = i >= this.metaData.columns.length ? res : DataType.toValue(this.metaData.columns[i].getDataType(), res);
        }
        return new TableRecord(data);
    }
}

