/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.resultset.io;

import org.apache.commons.codec.binary.Base64;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSerializer;
import org.apache.linkis.storage.domain.Dolphin;
import org.apache.linkis.storage.resultset.io.IOMetaData;
import org.apache.linkis.storage.resultset.io.IORecord;
import org.apache.linkis.storage.utils.StorageUtils;

public class IOResultSerializer
extends ResultSerializer {
    public byte[] metaDataToBytes(MetaData metaData) {
        IOMetaData ioMetaData = (IOMetaData)metaData;
        return this.lineToBytes(ioMetaData.off + "," + ioMetaData.len);
    }

    public byte[] recordToBytes(Record record) {
        IORecord ioRecord = (IORecord)record;
        return this.lineToBytes(Base64.encodeBase64String((byte[])ioRecord.value));
    }

    private byte[] lineToBytes(String value) {
        byte[] bytes = value == null ? Dolphin.NULL_BYTES : Dolphin.getBytes(value);
        byte[] intBytes = Dolphin.getIntBytes(bytes.length);
        return StorageUtils.mergeByteArrays(intBytes, bytes);
    }
}

