/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.resultset;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSerializer;
import org.apache.linkis.common.io.resultset.ResultSet;
import org.apache.linkis.common.io.resultset.ResultSetWriter;
import org.apache.linkis.storage.FSFactory;
import org.apache.linkis.storage.conf.LinkisStorageConf;
import org.apache.linkis.storage.domain.Dolphin;
import org.apache.linkis.storage.utils.FileSystemUtils;
import org.apache.linkis.storage.utils.StorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageResultSetWriter<K extends MetaData, V extends Record>
extends ResultSetWriter<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(StorageResultSetWriter.class);
    private final ResultSet<K, V> resultSet;
    private final long maxCacheSize;
    private final FsPath storePath;
    private final ResultSerializer serializer;
    private boolean moveToWriteRow = false;
    private OutputStream outputStream = null;
    private int rowCount = 0;
    private final List<Byte> buffer = new ArrayList<Byte>();
    private Fs fs = null;
    private MetaData rMetaData = null;
    private String proxyUser = StorageUtils.getJvmUser();
    private boolean fileCreated = false;
    private boolean closed = false;
    private final Object WRITER_LOCK_CREATE = new Object();
    private final Object WRITER_LOCK_CLOSE = new Object();

    public StorageResultSetWriter(ResultSet<K, V> resultSet, long maxCacheSize, FsPath storePath) {
        super(resultSet, maxCacheSize, storePath);
        this.resultSet = resultSet;
        this.maxCacheSize = maxCacheSize;
        this.storePath = storePath;
        this.serializer = resultSet.createResultSetSerializer();
    }

    public MetaData getMetaData() {
        return this.rMetaData;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public boolean isEmpty() {
        return this.rMetaData == null && this.buffer.size() <= 31;
    }

    public void init() {
        try {
            this.writeLine(this.resultSet.getResultSetHeader(), true);
        }
        catch (IOException e) {
            logger.warn("StorageResultSetWriter init failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNewFile() {
        if (!this.fileCreated) {
            Object object = this.WRITER_LOCK_CREATE;
            synchronized (object) {
                if (!this.fileCreated && this.storePath != null && this.outputStream == null) {
                    logger.info("Try to create a new file:{}, with proxy user:{}", (Object)this.storePath, (Object)this.proxyUser);
                    this.fs = FSFactory.getFsByProxyUser(this.storePath, this.proxyUser);
                    try {
                        this.fs.init(null);
                        FileSystemUtils.createNewFile(this.storePath, this.proxyUser, true);
                        this.outputStream = this.fs.write(this.storePath, true);
                    }
                    catch (IOException e) {
                        logger.warn("StorageResultSetWriter createNewFile failed", (Throwable)e);
                    }
                    logger.info("Succeed to create a new file:{}", (Object)this.storePath);
                    this.fileCreated = true;
                }
            }
        }
        if (this.storePath != null && this.outputStream == null) {
            logger.warn("outputStream had been set null, but createNewFile() was called again.");
        }
    }

    public void writeLine(byte[] bytes, boolean cache) throws IOException {
        if (this.closed) {
            logger.warn("the writer had been closed, but writeLine() was still called.");
            return;
        }
        if ((long)bytes.length > LinkisStorageConf.ROW_BYTE_MAX_LEN) {
            throw new IOException(String.format("A single row of data cannot exceed %s", LinkisStorageConf.ROW_BYTE_MAX_LEN_STR));
        }
        if ((long)this.buffer.size() > this.maxCacheSize && !cache) {
            if (this.outputStream == null) {
                this.createNewFile();
            }
            this.flush();
            this.outputStream.write(bytes);
        } else {
            for (byte b : bytes) {
                this.buffer.add(b);
            }
        }
    }

    public String toString() {
        if (this.outputStream == null) {
            if (this.isEmpty()) {
                return "";
            }
            byte[] byteArray = this.getBytes();
            return new String(byteArray, Dolphin.CHAR_SET);
        }
        return this.storePath.getSchemaPath();
    }

    private byte[] getBytes() {
        byte[] byteArray = new byte[this.buffer.size()];
        for (int i = 0; i < this.buffer.size(); ++i) {
            byteArray[i] = this.buffer.get(i);
        }
        return byteArray;
    }

    public FsPath toFSPath() {
        return this.storePath;
    }

    public void addMetaDataAndRecordString(String content) {
        if (!this.moveToWriteRow) {
            byte[] bytes = content.getBytes(Dolphin.CHAR_SET);
            try {
                this.writeLine(bytes, false);
            }
            catch (IOException e) {
                logger.warn("addMetaDataAndRecordString failed", (Throwable)e);
            }
        }
        this.moveToWriteRow = true;
    }

    public void addRecordString(String content) {
    }

    public void addMetaData(MetaData metaData) throws IOException {
        if (!this.moveToWriteRow) {
            this.rMetaData = metaData;
            this.init();
            if (metaData == null) {
                this.writeLine(this.serializer.metaDataToBytes(metaData), true);
            } else {
                this.writeLine(this.serializer.metaDataToBytes(metaData), false);
            }
            this.moveToWriteRow = true;
        }
    }

    public void addRecord(Record record) {
        if (this.moveToWriteRow) {
            ++this.rowCount;
            try {
                this.writeLine(this.serializer.recordToBytes(record), false);
            }
            catch (IOException e) {
                logger.warn("addMetaDataAndRecordString failed", (Throwable)e);
            }
        }
    }

    public void closeFs() {
        if (this.fs != null) {
            IOUtils.closeQuietly((Closeable)this.fs);
            this.fs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closed) {
            logger.warn("the writer had been closed, but close() was still called.");
            return;
        }
        Object object = this.WRITER_LOCK_CLOSE;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        try {
            if (this.outputStream != null) {
                this.flush();
            }
        }
        finally {
            if (this.outputStream != null) {
                IOUtils.closeQuietly((OutputStream)this.outputStream);
                this.outputStream = null;
            }
            this.closeFs();
        }
    }

    public void flush() {
        this.createNewFile();
        if (this.outputStream != null) {
            try {
                if (!this.buffer.isEmpty()) {
                    this.outputStream.write(this.getBytes());
                    this.buffer.clear();
                }
                if (this.outputStream instanceof HdfsDataOutputStream) {
                    ((HdfsDataOutputStream)this.outputStream).hflush();
                } else {
                    this.outputStream.flush();
                }
            }
            catch (IOException e) {
                logger.warn("Error encountered when flush result set", (Throwable)e);
            }
        }
        if (this.closed && logger.isDebugEnabled()) {
            logger.debug("the writer had been closed, but flush() was still called.");
        }
    }
}

