/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.resultset;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultDeserializer;
import org.apache.linkis.common.io.resultset.ResultSet;
import org.apache.linkis.common.io.resultset.ResultSetReader;
import org.apache.linkis.storage.domain.Dolphin;
import org.apache.linkis.storage.exception.StorageWarnException;
import org.apache.linkis.storage.resultset.ResultSetFactory;
import org.apache.linkis.storage.utils.StorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageResultSetReader<K extends MetaData, V extends Record>
extends ResultSetReader<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(StorageResultSetReader.class);
    private final ResultSet<K, V> resultSet;
    private final InputStream inputStream;
    private final ResultDeserializer<K, V> deserializer;
    private K metaData;
    private Record row;
    private int colCount = 0;
    private int rowCount = 0;
    private Fs fs;
    private final int READ_CACHE = 1024;
    private final byte[] bytes = new byte[1024];

    public StorageResultSetReader(ResultSet<K, V> resultSet, InputStream inputStream) {
        super(resultSet, inputStream);
        this.resultSet = resultSet;
        this.inputStream = inputStream;
        this.deserializer = resultSet.createResultSetDeserializer();
    }

    public StorageResultSetReader(ResultSet<K, V> resultSet, String value) {
        this(resultSet, new ByteArrayInputStream(value.getBytes(Dolphin.CHAR_SET)));
    }

    public void init() throws IOException {
        String resType = Dolphin.getType(this.inputStream);
        if (!StringUtils.equals((CharSequence)this.resultSet.resultSetType(), (CharSequence)resType)) {
            throw new RuntimeException("File type does not match(\u6587\u4ef6\u7c7b\u578b\u4e0d\u5339\u914d): " + ResultSetFactory.resultSetType.getOrDefault(resType, "TABLE"));
        }
    }

    public byte[] readLine() {
        int rowLen = 0;
        try {
            rowLen = Dolphin.readInt(this.inputStream);
        }
        catch (IOException | StorageWarnException e) {
            logger.info("Read finished(\u8bfb\u53d6\u5b8c\u6bd5)");
            return null;
        }
        byte[] rowBuffer = new byte[]{};
        int len = 0;
        while (rowLen > 0 && len >= 0) {
            len = rowLen > 1024 ? StorageUtils.readBytes(this.inputStream, this.bytes, 1024) : StorageUtils.readBytes(this.inputStream, this.bytes, rowLen);
            if (len <= 0) continue;
            rowLen -= len;
            rowBuffer = Arrays.copyOf(rowBuffer, rowBuffer.length + len);
            System.arraycopy(this.bytes, 0, rowBuffer, rowBuffer.length - len, len);
        }
        ++this.rowCount;
        return rowBuffer;
    }

    public Record getRecord() {
        if (this.metaData == null) {
            throw new RuntimeException("Must read metadata first(\u5fc5\u987b\u5148\u8bfb\u53d6metadata)");
        }
        if (this.row == null) {
            throw new RuntimeException("Can't get the value of the field, maybe the IO stream has been read or has been closed!(\u62ff\u4e0d\u5230\u5b57\u6bb5\u7684\u503c\uff0c\u4e5f\u8bb8IO\u6d41\u5df2\u8bfb\u53d6\u5b8c\u6bd5\u6216\u5df2\u88ab\u5173\u95ed\uff01)");
        }
        return this.row;
    }

    public void setFs(Fs fs) {
        this.fs = fs;
    }

    public Fs getFs() {
        return this.fs;
    }

    public MetaData getMetaData() {
        if (this.metaData == null) {
            try {
                this.init();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.metaData = this.deserializer.createMetaData(this.readLine());
        return this.metaData;
    }

    public int skip(int recordNum) throws IOException {
        if (recordNum < 0) {
            return -1;
        }
        if (this.metaData == null) {
            this.getMetaData();
        }
        for (int i = recordNum; i > 0; --i) {
            try {
                this.inputStream.skip(Dolphin.readInt(this.inputStream));
                continue;
            }
            catch (Throwable t) {
                return recordNum - i;
            }
        }
        return recordNum;
    }

    public long getPosition() throws IOException {
        return this.rowCount;
    }

    public boolean hasNext() throws IOException {
        byte[] line;
        if (this.metaData == null) {
            this.getMetaData();
        }
        if ((line = this.readLine()) == null) {
            return false;
        }
        this.row = this.deserializer.createRecord(line);
        return this.row != null;
    }

    public long available() throws IOException {
        return this.inputStream.available();
    }

    public void close() throws IOException {
        IOUtils.closeQuietly((InputStream)this.inputStream);
        if (this.fs != null) {
            this.fs.close();
        }
    }
}

